/*
 * Decompiled with CFR 0.152.
 */
package conversions;

import conversions.ObservableQuantity;

public class SecondMomentArea
extends ObservableQuantity {
    private double value;
    private int type = 0;
    private String units = "in^4";
    private boolean metric = false;
    private String name = "";

    public boolean isMetric() {
        return this.metric;
    }

    public SecondMomentArea(double d, String string, int n) {
        this.value = d;
        this.name = string;
        this.type = n;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.convertToEnglish();
        if (this.value == d) {
            return;
        }
        this.value = d;
        this.setChanged();
    }

    public int getType() {
        return this.type;
    }

    public String getUnits() {
        return this.units;
    }

    public void convertToMetric() {
        if (this.metric) {
            return;
        }
        this.setChanged();
        this.metric = true;
        this.units = "mm^4";
        this.value *= 416231.0;
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + this.value + " " + this.units;
    }

    public void convertToEnglish() {
        if (!this.metric) {
            return;
        }
        this.setChanged();
        this.metric = false;
        this.units = "in^4";
        this.value /= 416231.0;
    }

    public void test() {
        System.out.println(this);
        this.convertToEnglish();
        System.out.println(this);
        this.convertToMetric();
        System.out.println(this);
    }
}

