/*
 * Decompiled with CFR 0.152.
 */
package conversions;

import conversions.ObservableQuantity;

public class MMInertiaQuantity
extends ObservableQuantity {
    private double value;
    private int type = 0;
    private String units = "lb-in^2";
    private boolean metric = false;
    private String name = "";

    public boolean isMetric() {
        return this.metric;
    }

    public MMInertiaQuantity(double d, String string, int n) {
        this.value = d;
        this.name = string;
        this.type = n;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.convertToEnglish();
        if (this.value == d) {
            return;
        }
        this.value = d;
        this.setChanged();
    }

    public int getType() {
        return this.type;
    }

    public String getUnits() {
        return this.units;
    }

    public void convertToMetric() {
        if (this.metric) {
            return;
        }
        this.setChanged();
        this.metric = true;
        this.units = "kg-mm^2";
        this.value *= 292.645;
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + this.value + " " + this.units;
    }

    public void convertToEnglish() {
        if (!this.metric) {
            return;
        }
        this.setChanged();
        this.metric = false;
        this.units = "lb-in^2";
        this.value /= 292.645;
    }

    public void test() {
        System.out.println(this);
        this.convertToEnglish();
        System.out.println(this);
        this.convertToMetric();
        System.out.println(this);
    }
}

