/*
 * Decompiled with CFR 0.152.
 */
package conversions;

import conversions.ObservableQuantity;

public class AreaQuantity
extends ObservableQuantity {
    private double value;
    private int type = 0;
    private String units = "inch^2";
    private boolean metric = false;
    private String name = "";

    public boolean isMetric() {
        return this.metric;
    }

    public int getType() {
        return this.type;
    }

    public AreaQuantity(double d, String string, int n) {
        this.value = d;
        this.name = string;
        this.type = n;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.convertToEnglish();
        if (this.value == d) {
            return;
        }
        this.value = d;
        this.setChanged();
    }

    public String getUnits() {
        return this.units;
    }

    public void convertToMetric() {
        if (this.metric) {
            return;
        }
        this.setChanged();
        this.metric = true;
        this.units = "mm^2";
        this.value *= 645.16;
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + this.value + " " + this.units;
    }

    public void convertToEnglish() {
        if (!this.metric) {
            return;
        }
        this.setChanged();
        this.metric = false;
        this.units = "in^2";
        this.value /= 645.16;
    }
}

