/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.oculusvr;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.oculusvr.ovrEyeRenderDesc;
import com.jogamp.oculusvr.ovrFovPort;
import com.jogamp.oculusvr.ovrQuatf;
import com.jogamp.oculusvr.ovrRecti;
import com.jogamp.oculusvr.ovrSizei;
import com.jogamp.oculusvr.ovrVector2f;
import com.jogamp.oculusvr.ovrVector2i;
import com.jogamp.oculusvr.ovrVector3f;
import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.math.Quaternion;

public class OVRUtil {
    public static ovrRecti createOVRRecti(int[] nArray) {
        ovrRecti ovrRecti2 = ovrRecti.create();
        ovrVector2i ovrVector2i2 = ovrRecti2.getPos();
        ovrSizei ovrSizei2 = ovrRecti2.getSize();
        ovrVector2i2.setX(nArray[0]);
        ovrVector2i2.setY(nArray[1]);
        ovrSizei2.setW(nArray[2]);
        ovrSizei2.setH(nArray[3]);
        return ovrRecti2;
    }

    public static ovrRecti createOVRRecti(RectangleImmutable rectangleImmutable) {
        ovrRecti ovrRecti2 = ovrRecti.create();
        ovrVector2i ovrVector2i2 = ovrRecti2.getPos();
        ovrSizei ovrSizei2 = ovrRecti2.getSize();
        ovrVector2i2.setX(rectangleImmutable.getX());
        ovrVector2i2.setY(rectangleImmutable.getY());
        ovrSizei2.setW(rectangleImmutable.getWidth());
        ovrSizei2.setH(rectangleImmutable.getHeight());
        return ovrRecti2;
    }

    public static ovrRecti[] createOVRRectis(int[][] nArray) {
        ovrRecti[] ovrRectiArray = new ovrRecti[nArray.length];
        for (int i = 0; i < ovrRectiArray.length; ++i) {
            ovrRectiArray[0] = OVRUtil.createOVRRecti(nArray[i]);
        }
        return ovrRectiArray;
    }

    public static ovrSizei createOVRSizei(int[] nArray) {
        ovrSizei ovrSizei2 = ovrSizei.create();
        ovrSizei2.setW(nArray[0]);
        ovrSizei2.setH(nArray[1]);
        return ovrSizei2;
    }

    public static ovrSizei createOVRSizei(DimensionImmutable dimensionImmutable) {
        ovrSizei ovrSizei2 = ovrSizei.create();
        ovrSizei2.setW(dimensionImmutable.getWidth());
        ovrSizei2.setH(dimensionImmutable.getHeight());
        return ovrSizei2;
    }

    public static DimensionImmutable getOVRSizei(ovrSizei ovrSizei2) {
        return new Dimension(ovrSizei2.getW(), ovrSizei2.getH());
    }

    public static PointImmutable getVec2iAsPoint(ovrVector2i ovrVector2i2) {
        return new Point(ovrVector2i2.getX(), ovrVector2i2.getY());
    }

    public static int[] getVec2i(ovrVector2i ovrVector2i2) {
        return new int[]{ovrVector2i2.getX(), ovrVector2i2.getY()};
    }

    public static void copyVec2iToInt(ovrVector2i ovrVector2i2, int[] nArray) {
        nArray[0] = ovrVector2i2.getX();
        nArray[1] = ovrVector2i2.getY();
    }

    public static float[] getVec3f(ovrVector3f ovrVector3f2) {
        return new float[]{ovrVector3f2.getX(), ovrVector3f2.getY(), ovrVector3f2.getZ()};
    }

    public static void copyVec3fToFloat(ovrVector3f ovrVector3f2, float[] fArray) {
        fArray[0] = ovrVector3f2.getX();
        fArray[1] = ovrVector3f2.getY();
        fArray[2] = ovrVector3f2.getZ();
    }

    public static Quaternion getQuaternion(ovrQuatf ovrQuatf2) {
        return new Quaternion(ovrQuatf2.getX(), ovrQuatf2.getY(), ovrQuatf2.getZ(), ovrQuatf2.getW());
    }

    public static void copyToQuaternion(ovrQuatf ovrQuatf2, Quaternion quaternion) {
        quaternion.set(ovrQuatf2.getX(), ovrQuatf2.getY(), ovrQuatf2.getZ(), ovrQuatf2.getW());
    }

    public static FovHVHalves getFovHV(ovrFovPort ovrFovPort2) {
        return new FovHVHalves(ovrFovPort2.getLeftTan(), ovrFovPort2.getRightTan(), ovrFovPort2.getUpTan(), ovrFovPort2.getDownTan(), true);
    }

    public static ovrFovPort getOVRFovPort(FovHVHalves fovHVHalves) {
        ovrFovPort ovrFovPort2 = ovrFovPort.create();
        FovHVHalves fovHVHalves2 = fovHVHalves.toTangents();
        ovrFovPort2.setLeftTan(fovHVHalves2.left);
        ovrFovPort2.setRightTan(fovHVHalves2.right);
        ovrFovPort2.setUpTan(fovHVHalves2.top);
        ovrFovPort2.setDownTan(fovHVHalves2.bottom);
        return ovrFovPort2;
    }

    public static int ovrDistCaps2DistBits(int n) {
        int n2 = 1;
        if (0 != (2 & n)) {
            n2 |= 8;
        }
        if (0 != (1 & n)) {
            n2 |= 2;
        }
        if (0 != (8 & n)) {
            n2 |= 4;
        }
        return n2;
    }

    public static String toString(ovrFovPort ovrFovPort2) {
        return "[" + ovrFovPort2.getLeftTan() + " l, " + ovrFovPort2.getRightTan() + " r, " + ovrFovPort2.getUpTan() + " u, " + ovrFovPort2.getDownTan() + " d]";
    }

    public static String toString(ovrSizei ovrSizei2) {
        return "[" + ovrSizei2.getW() + " x " + ovrSizei2.getH() + "]";
    }

    public static String toString(ovrRecti ovrRecti2) {
        return "[" + ovrRecti2.getPos().getX() + "  / " + ovrRecti2.getPos().getY() + " " + ovrRecti2.getSize().getW() + " x " + ovrRecti2.getSize().getH() + "]";
    }

    public static String toString(ovrVector2f ovrVector2f2) {
        return "[" + ovrVector2f2.getX() + ", " + ovrVector2f2.getY() + "]";
    }

    public static String toString(ovrVector3f ovrVector3f2) {
        return "[" + ovrVector3f2.getX() + ", " + ovrVector3f2.getY() + ", " + ovrVector3f2.getZ() + "]";
    }

    public static String toString(ovrEyeRenderDesc ovrEyeRenderDesc2) {
        return "[" + ovrEyeRenderDesc2.getEye() + ", fov" + OVRUtil.toString(ovrEyeRenderDesc2.getFov()) + ", viewport" + OVRUtil.toString(ovrEyeRenderDesc2.getDistortedViewport()) + ", pptCtr" + OVRUtil.toString(ovrEyeRenderDesc2.getPixelsPerTanAngleAtCenter()) + ", view-adjust" + OVRUtil.toString(ovrEyeRenderDesc2.getHmdToEyeViewOffset()) + "]";
    }
}

