/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLWindowWarpPointer01NEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    static GLWindow createWindow(Screen screen, GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException {
        GLWindow gLWindow;
        Assert.assertNotNull((Object)gLCapabilitiesImmutable);
        if (null != screen) {
            gLWindow = GLWindow.create(screen, gLCapabilitiesImmutable);
            Assert.assertNotNull((Object)gLWindow);
        } else {
            gLWindow = GLWindow.create(gLCapabilitiesImmutable);
            Assert.assertNotNull((Object)gLWindow);
        }
        gLWindow.setUpdateFPSFrames(1, null);
        GearsES2 gearsES2 = new GearsES2();
        gLWindow.addGLEventListener(gearsES2);
        gLWindow.setSize(512, 512);
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
            Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        }
    }

    @Test
    public void testWarp01Center() throws InterruptedException {
        this.testWarpImpl(false);
    }

    @Test
    public void testWarp02Random() throws InterruptedException {
        this.testWarpImpl(true);
    }

    void testWarpImpl(boolean bl) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        final GLWindow gLWindow = TestGLWindowWarpPointer01NEWT.createWindow(null, gLCapabilities);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        Animator animator = new Animator();
        animator.setUpdateFPSFrames(1, null);
        animator.add(gLWindow);
        animator.start();
        AbstractGraphicsDevice abstractGraphicsDevice = gLWindow.getScreen().getDisplay().getGraphicsDevice();
        System.err.println("GLProfiles window1: " + abstractGraphicsDevice.getConnection() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice));
        gLWindow.warpPointer(width / 2, height / 2);
        gLWindow.requestFocus();
        gLWindow.addMouseListener(new MouseAdapter(){

            void warpCenter() {
                gLWindow.warpPointer(width / 2, height / 2);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.warpCenter();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        if (bl) {
            gLWindow.addGLEventListener(new GLEventListener(){
                final Random r = new Random();

                void warpRandom(int n, int n2) {
                    int n3 = this.r.nextInt(n);
                    int n4 = this.r.nextInt(n2);
                    gLWindow.warpPointer(n3, n4);
                }

                @Override
                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void display(GLAutoDrawable gLAutoDrawable) {
                    this.warpRandom(gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
                }

                @Override
                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
        }
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        TestGLWindowWarpPointer01NEWT.destroyWindow(gLWindow);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestGLWindowWarpPointer01NEWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestGLWindowWarpPointer01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 2000L;
    }
}

