/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2.awt;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.glu.gl2.GLUgl2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLJPanelAWTBug450
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static int r_x;
    static int r_y;
    static boolean failed;
    static long duration;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getGL2ES2();
        Assert.assertNotNull((Object)glp);
        height = 256;
        width = 2 * height;
        r_x = 5 * height / 4;
        r_y = height / 2;
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws AWTException, InterruptedException, InvocationTargetException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        final JFrame jFrame = new JFrame("Swing GLJPanel");
        Assert.assertNotNull((Object)jFrame);
        final GLJPanel gLJPanel = new GLJPanel(gLCapabilities);
        Assert.assertNotNull((Object)gLJPanel);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        redSquareES2.setAspect((float)width / (float)height);
        redSquareES2.setDoRotation(false);
        gLJPanel.addGLEventListener(redSquareES2);
        gLJPanel.addGLEventListener(new GLEventListener(){
            int f = 0;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                GL2 gL2 = GLUgl2.getCurrentGL2();
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(3);
                gL2.glReadPixels(r_x, r_y, 1, 1, 32992, 5121, byteBuffer);
                byte by = byteBuffer.get(0);
                byte by2 = byteBuffer.get(1);
                byte by3 = byteBuffer.get(2);
                if (by == 0 && by2 == 0 && by3 == 0) {
                    failed = true;
                }
                if (0 == this.f) {
                    System.err.println("BGR (" + r_x + "/" + r_y + "): " + by + ", " + by2 + ", " + by3 + " - OK " + !failed);
                    TestGLJPanelAWTBug450.this.snapshot(this.f, null, gL2, gLReadBufferUtil, "png", null);
                }
                ++this.f;
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        FPSAnimator fPSAnimator = new FPSAnimator(gLJPanel, 60);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.getContentPane().add((Component)gLJPanel, "Center");
                jFrame.setSize(width, height);
                jFrame.setVisible(true);
            }
        });
        fPSAnimator.setUpdateFPSFrames(1, null);
        fPSAnimator.start();
        Assert.assertEquals((Object)true, (Object)fPSAnimator.isAnimating());
        while (fPSAnimator.isAnimating() && fPSAnimator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull((Object)jFrame);
        Assert.assertNotNull((Object)gLJPanel);
        Assert.assertNotNull((Object)fPSAnimator);
        fPSAnimator.stop();
        Assert.assertEquals((Object)false, (Object)fPSAnimator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
                jFrame.getContentPane().remove(gLJPanel);
                jFrame.remove(gLJPanel);
                gLJPanel.destroy();
                jFrame.dispose();
            }
        });
        Assert.assertFalse((boolean)failed);
    }

    @Test
    public void test01() throws AWTException, InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestGLJPanelAWTBug450.class.getName()});
    }

    static {
        duration = 500L;
    }
}

