/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.common.util.IOUtil;
import com.jogamp.junit.util.JunitTracer;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.EDTUtil;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.Gamma;
import com.jogamp.opengl.util.PNGPixelRect;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLConnection;
import jogamp.newt.DefaultEDTUtil;
import jogamp.newt.driver.PNGIcon;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2NEWT
extends UITestCase {
    static int screenIdx = 0;
    static PointImmutable wpos;
    static DimensionImmutable wsize;
    static DimensionImmutable rwsize;
    static float[] reqSurfacePixelScale;
    static long duration;
    static boolean opaque;
    static int forceAlpha;
    static boolean undecorated;
    static boolean alwaysOnTop;
    static boolean fullscreen;
    static int swapInterval;
    static boolean waitForKey;
    static boolean mouseVisible;
    static boolean mouseConfined;
    static boolean setPointerIcon;
    static boolean showFPS;
    static int loops;
    static boolean loop_shutdown;
    static boolean forceES2;
    static boolean forceES3;
    static boolean forceGL3;
    static boolean forceGL2;
    static boolean manualTest;
    static boolean exclusiveContext;
    static boolean useAnimator;
    static boolean useMappedBuffers;
    static SysExit sysExit;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    private void setTitle(Window window, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        String string = gLCapabilitiesImmutable.isBackgroundOpaque() ? "opaque" : "transl";
        float[] fArray = window.getPixelsPerMM(new float[2]);
        fArray[0] = fArray[0] * 25.4f;
        fArray[1] = fArray[1] * 25.4f;
        window.setTitle("GLWindow[" + string + "], swapI " + swapInterval + ", win: " + window.getBounds() + ", pix: " + window.getSurfaceWidth() + "x" + window.getSurfaceHeight() + ", sDPI " + fArray[0] + " x " + fArray[1]);
    }

    protected void runTestGL(final GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) throws InterruptedException {
        long l;
        Animator animator;
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen(display, screenIdx);
        final GLWindow gLWindow = GLWindow.create(screen, gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setSurfaceScale(reqSurfacePixelScale);
        float[] fArray = gLWindow.getRequestedSurfaceScale(new float[2]);
        gLWindow.setSize(wsize.getWidth(), wsize.getHeight());
        if (null != wpos) {
            gLWindow.setPosition(wpos.getX(), wpos.getY());
        }
        gLWindow.setUndecorated(bl);
        gLWindow.setAlwaysOnTop(alwaysOnTop);
        gLWindow.setFullscreen(fullscreen);
        gLWindow.setPointerVisible(mouseVisible);
        gLWindow.confinePointer(mouseConfined);
        final GearsES2 gearsES2 = new GearsES2(swapInterval);
        gearsES2.setUseMappedBuffers(useMappedBuffers);
        gearsES2.setValidateBuffers(true);
        gLWindow.addGLEventListener(gearsES2);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener(snapshotGLEventListener);
        if (waitForKey) {
            gLWindow.addGLEventListener(new GLEventListener(){

                @Override
                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void display(GLAutoDrawable gLAutoDrawable) {
                    GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                    if (waitForKey && gLAnimatorControl.getTotalFPSFrames() == 180) {
                        JunitTracer.waitForKey("3s mark");
                        gLAnimatorControl.resetFPSCounter();
                        waitForKey = false;
                    }
                }

                @Override
                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
        }
        Animator animator2 = animator = useAnimator ? new Animator() : null;
        if (useAnimator) {
            animator.setModeBits(false, 1);
            animator.setExclusiveContext(exclusiveContext);
        }
        final QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
                TestGearsES2NEWT.this.setTitle(gLWindow, gLCapabilitiesImmutable);
            }

            @Override
            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
                TestGearsES2NEWT.this.setTitle(gLWindow, gLCapabilitiesImmutable);
            }
        });
        final Display.PointerIcon[] pointerIconArray = new Display.PointerIcon[]{null, null, null, null, null};
        Object object = gLWindow.getScreen().getDisplay();
        ((Display)object).createNative();
        int n = 0;
        Display.PointerIcon pointerIcon = null;
        IOUtil.ClassResources classResources = new IOUtil.ClassResources(gLWindow.getClass(), new String[]{"newt/data/cross-grey-alpha-16x16.png"});
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 8, 8);
            System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointerIconArray[n] = pointerIcon;
        ++n;
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(gLWindow.getClass(), new String[]{"newt/data/pointer-grey-alpha-16x24.png"});
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 0, 0);
            System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointerIconArray[n] = pointerIcon;
        ++n;
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(gLWindow.getClass(), new String[]{"arrow-red-alpha-64x64.png"});
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 0, 0);
            System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointerIconArray[n] = pointerIcon;
        ++n;
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(gLWindow.getClass(), new String[]{"arrow-blue-alpha-64x64.png"});
        try {
            pointerIcon = ((Display)object).createPointerIcon(classResources, 0, 0);
            System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointerIconArray[n] = pointerIcon;
        ++n;
        if (PNGIcon.isAvailable()) {
            pointerIcon = null;
            classResources = new IOUtil.ClassResources(gLWindow.getClass(), new String[]{"jogamp-pointer-64x64.png"});
            try {
                URLConnection uRLConnection = classResources.resolve(0);
                PNGPixelRect pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), null, false, 0, false);
                System.err.printf("Create PointerIcon #%02d: %s%n", n, pNGPixelRect.toString());
                pointerIcon = ((Display)object).createPointerIcon(pNGPixelRect, 32, 0);
                System.err.printf("Create PointerIcon #%02d: %s%n", n, pointerIcon.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            pointerIconArray[n] = pointerIcon;
        }
        ++n;
        if (setPointerIcon) {
            gLWindow.setPointerIcon(pointerIconArray[0]);
            System.err.println("Set PointerIcon: " + gLWindow.getPointerIcon());
        }
        gLWindow.addKeyListener(new KeyAdapter(){
            int pointerIconIdx = 0;
            float gamma = 1.0f;
            float brightness = 0.0f;
            float contrast = 1.0f;

            @Override
            public void keyPressed(final KeyEvent keyEvent) {
                if (keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'f') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set fullscreen  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            if (gLWindow.isFullscreen()) {
                                gLWindow.setFullscreen(false);
                            } else if (keyEvent.isAltDown()) {
                                gLWindow.setFullscreen(null);
                            } else {
                                gLWindow.setFullscreen(true);
                            }
                            System.err.println("[set fullscreen post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeySymbol() == 71) {
                    new Thread(){

                        @Override
                        public void run() {
                            float f = gamma + (keyEvent.isShiftDown() ? -0.1f : 0.1f);
                            System.err.println("[set gamma]: " + gamma + " -> " + f);
                            if (Gamma.setDisplayGamma(gLWindow, f, brightness, contrast)) {
                                gamma = f;
                            }
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'a') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set alwaysontop pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setAlwaysOnTop(!gLWindow.isAlwaysOnTop());
                            System.err.println("[set alwaysontop post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'd') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set undecorated  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", d " + gLWindow.isUndecorated() + ", " + gLWindow.getInsets());
                            gLWindow.setUndecorated(!gLWindow.isUndecorated());
                            System.err.println("[set undecorated post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", d " + gLWindow.isUndecorated() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 's') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set position  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
                            gLWindow.setPosition(100, 100);
                            System.err.println("[set position post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'c') {
                    new Thread(){

                        @Override
                        public void run() {
                            Display.PointerIcon pointerIcon;
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set pointer-icon pre]");
                            Display.PointerIcon pointerIcon2 = gLWindow.getPointerIcon();
                            if (pointerIconIdx >= pointerIconArray.length) {
                                pointerIcon = null;
                                pointerIconIdx = 0;
                            } else {
                                pointerIcon = pointerIconArray[pointerIconIdx++];
                            }
                            gLWindow.setPointerIcon(pointerIcon);
                            System.err.println("[set pointer-icon post] " + pointerIcon2 + " -> " + gLWindow.getPointerIcon());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'i') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set mouse visible pre]: " + gLWindow.isPointerVisible());
                            gLWindow.setPointerVisible(!gLWindow.isPointerVisible());
                            System.err.println("[set mouse visible post]: " + gLWindow.isPointerVisible());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'j') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set mouse confined pre]: " + gLWindow.isPointerConfined());
                            gLWindow.confinePointer(!gLWindow.isPointerConfined());
                            System.err.println("[set mouse confined post]: " + gLWindow.isPointerConfined());
                            if (!gLWindow.isPointerConfined()) {
                                gearsES2.setConfinedFixedCenter(false);
                            }
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'J') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set mouse confined pre]: " + gLWindow.isPointerConfined());
                            gLWindow.confinePointer(!gLWindow.isPointerConfined());
                            System.err.println("[set mouse confined post]: " + gLWindow.isPointerConfined());
                            gearsES2.setConfinedFixedCenter(gLWindow.isPointerConfined());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'w') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set mouse pos pre]");
                            gLWindow.warpPointer(gLWindow.getSurfaceWidth() / 2, gLWindow.getSurfaceHeight() / 2);
                            System.err.println("[set mouse pos post]");
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'x') {
                    float[] fArray = gLWindow.getCurrentSurfaceScale(new float[2]);
                    float[] fArray2 = fArray[0] == 1.0f ? new float[]{0.0f, 0.0f} : new float[]{1.0f, 1.0f};
                    System.err.println("[set PixelScale pre]: had " + fArray[0] + "x" + fArray[1] + " -> req " + fArray2[0] + "x" + fArray2[1]);
                    gLWindow.setSurfaceScale(fArray2);
                    float[] fArray3 = gLWindow.getRequestedSurfaceScale(new float[2]);
                    float[] fArray4 = gLWindow.getCurrentSurfaceScale(new float[2]);
                    System.err.println("[set PixelScale post]: " + fArray[0] + "x" + fArray[1] + " (had) -> " + fArray2[0] + "x" + fArray2[1] + " (req) -> " + fArray3[0] + "x" + fArray3[1] + " (val) -> " + fArray4[0] + "x" + fArray4[1] + " (has)");
                    TestGearsES2NEWT.this.setTitle(gLWindow, gLCapabilitiesImmutable);
                }
            }
        });
        gLWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getPointerCount() == 1) {
                    gLWindow.setFullscreen(!gLWindow.isFullscreen());
                    System.err.println("setFullscreen: " + gLWindow.isFullscreen());
                }
            }
        });
        if (useAnimator) {
            animator.add(gLWindow);
            animator.start();
            Assert.assertTrue((boolean)animator.isStarted());
            Assert.assertTrue((boolean)animator.isAnimating());
            Assert.assertEquals((Object)(exclusiveContext ? animator.getThread() : null), (Object)gLWindow.getExclusiveContextThread());
        }
        if (SysExit.displayError == sysExit || SysExit.displayExit == sysExit || SysExit.displayEDTError == sysExit) {
            gLWindow.addGLEventListener(new GLEventListener(){

                @Override
                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void display(GLAutoDrawable gLAutoDrawable) {
                    GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                    if (null != gLAnimatorControl && gLAnimatorControl.isAnimating()) {
                        long l = gLAnimatorControl.getTotalFPSDuration();
                        if (l >= duration / 2L || l >= 3000L) {
                            if (SysExit.displayError == sysExit) {
                                throw new Error("test error send from GLEventListener.display - " + Thread.currentThread());
                            }
                            if (SysExit.displayExit == sysExit) {
                                System.err.println("exit(0) send from GLEventListener");
                                System.exit(0);
                            } else if (SysExit.displayEDTError == sysExit) {
                                Object object = gLAutoDrawable.getUpstreamWidget();
                                System.err.println("EDT invokeAndWaitError: upstream type " + object.getClass().getName());
                                if (object instanceof Window) {
                                    EDTUtil eDTUtil = ((Window)object).getScreen().getDisplay().getEDTUtil();
                                    System.err.println("EDT invokeAndWaitError: edt type " + eDTUtil.getClass().getName());
                                    if (eDTUtil instanceof DefaultEDTUtil) {
                                        quitAdapter.doQuit();
                                        ((DefaultEDTUtil)eDTUtil).invokeAndWaitError(new Runnable(){

                                            @Override
                                            public void run() {
                                                throw new RuntimeException("XXX Should never ever be seen! - " + Thread.currentThread());
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    } else {
                        System.exit(0);
                    }
                }

                @Override
                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
        }
        gLWindow.setVisible(true);
        if (useAnimator) {
            animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        }
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        object = gLWindow.getCurrentSurfaceScale(new float[2]);
        System.err.println("HiDPI PixelScale: " + reqSurfacePixelScale[0] + "x" + reqSurfacePixelScale[1] + " (req) -> " + fArray[0] + "x" + fArray[1] + " (val) -> " + (float)object[0] + "x" + (float)object[1] + " (has)");
        this.setTitle(gLWindow, gLCapabilitiesImmutable);
        snapshotGLEventListener.setMakeSnapshot();
        if (null != rwsize) {
            Thread.sleep(500L);
            gLWindow.setSize(rwsize.getWidth(), rwsize.getHeight());
            System.err.println("window resize pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        }
        snapshotGLEventListener.setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            long l3;
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
            if (SysExit.testError != sysExit && SysExit.testExit != sysExit && SysExit.testEDTError != sysExit || (l3 = l2 - l) < duration / 2L && l3 < 3000L) continue;
            if (SysExit.testError == sysExit) {
                throw new Error("test error send from test thread");
            }
            if (SysExit.testExit == sysExit) {
                System.err.println("exit(0) send from test thread");
                System.exit(0);
                continue;
            }
            if (SysExit.testEDTError != sysExit) continue;
            EDTUtil eDTUtil = gLWindow.getScreen().getDisplay().getEDTUtil();
            System.err.println("EDT invokeAndWaitError: edt type " + eDTUtil.getClass().getName());
            if (!(eDTUtil instanceof DefaultEDTUtil)) continue;
            quitAdapter.doQuit();
            ((DefaultEDTUtil)eDTUtil).invokeAndWaitError(new Runnable(){

                @Override
                public void run() {
                    throw new RuntimeException("XXX Should never ever be seen!");
                }
            });
        }
        if (useAnimator) {
            Assert.assertEquals((Object)(exclusiveContext ? animator.getThread() : null), (Object)gLWindow.getExclusiveContextThread());
            animator.stop();
            Assert.assertFalse((boolean)animator.isAnimating());
            Assert.assertFalse((boolean)animator.isStarted());
        }
        Assert.assertEquals(null, (Object)gLWindow.getExclusiveContextThread());
        gLWindow.destroy();
        if (NativeWindowFactory.isAWTAvailable()) {
            Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, false));
        }
    }

    @Test
    public void test01_GL2ES2() throws InterruptedException {
        for (int i = 1; i <= loops; ++i) {
            System.err.println("Loop " + i + "/" + loops);
            GLProfile gLProfile = forceGL3 ? GLProfile.get("GL3") : (forceES3 ? GLProfile.get("GLES3") : (forceES2 ? GLProfile.get("GLES2") : (forceGL2 ? GLProfile.get("GL2") : GLProfile.getGL2ES2())));
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setBackgroundOpaque(opaque);
            if (-1 < forceAlpha) {
                gLCapabilities.setAlphaBits(forceAlpha);
            }
            this.runTestGL(gLCapabilities, undecorated);
            if (!loop_shutdown) continue;
            GLProfile.shutdown();
        }
    }

    @Test
    public void test02_GLES2() throws InterruptedException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GLES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, undecorated);
    }

    @Test
    public void test03_GL3() throws InterruptedException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, undecorated);
    }

    @Test
    public void test99_PixelScale1_DefaultNorm() throws InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        TestGearsES2NEWT.reqSurfacePixelScale[0] = 1.0f;
        TestGearsES2NEWT.reqSurfacePixelScale[1] = 1.0f;
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        this.runTestGL(gLCapabilities, undecorated);
    }

    public static void main(String[] stringArray) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-translucent")) {
                opaque = false;
                continue;
            }
            if (stringArray[i].equals("-forceAlpha")) {
                forceAlpha = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-undecorated")) {
                undecorated = true;
                continue;
            }
            if (stringArray[i].equals("-atop")) {
                alwaysOnTop = true;
                continue;
            }
            if (stringArray[i].equals("-fullscreen")) {
                fullscreen = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                forceES3 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-gl2")) {
                forceGL2 = true;
                continue;
            }
            if (stringArray[i].equals("-mappedBuffers")) {
                useMappedBuffers = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (stringArray[i].equals("-mouseInvisible")) {
                mouseVisible = false;
                continue;
            }
            if (stringArray[i].equals("-mouseConfine")) {
                mouseConfined = true;
                continue;
            }
            if (stringArray[i].equals("-pointerIcon")) {
                setPointerIcon = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-y")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-pixelScale")) {
                float f;
                TestGearsES2NEWT.reqSurfacePixelScale[0] = f = MiscUtils.atof(stringArray[++i], reqSurfacePixelScale[0]);
                TestGearsES2NEWT.reqSurfacePixelScale[1] = f;
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-screen")) {
                screenIdx = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                loops = MiscUtils.atoi(stringArray[++i], 1);
                continue;
            }
            if (stringArray[i].equals("-loop-shutdown")) {
                loop_shutdown = true;
                continue;
            }
            if (stringArray[i].equals("-sysExit")) {
                sysExit = SysExit.valueOf(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manualTest = true;
        }
        wsize = new Dimension(n3, n4);
        if (0 < n5 && 0 < n6) {
            rwsize = new Dimension(n5, n6);
        }
        if (bl) {
            wpos = new Point(n, n2);
        }
        System.err.println("position " + wpos);
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("screen " + screenIdx);
        System.err.println("translucent " + !opaque);
        System.err.println("forceAlpha " + forceAlpha);
        System.err.println("undecorated " + undecorated);
        System.err.println("atop " + alwaysOnTop);
        System.err.println("fullscreen " + fullscreen);
        System.err.println("mouseVisible " + mouseVisible);
        System.err.println("mouseConfined " + mouseConfined);
        System.err.println("pointerIcon " + setPointerIcon);
        System.err.println("loops " + loops);
        System.err.println("loop shutdown " + loop_shutdown);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceES3 " + forceES3);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("forceGL2 " + forceGL2);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        System.err.println("useAnimator " + useAnimator);
        System.err.println("sysExitWithin " + (Object)((Object)sysExit));
        System.err.println("mappedBuffers " + useMappedBuffers);
        if (waitForKey) {
            JunitTracer.waitForKey("Start");
        }
        JUnitCore.main((String[])new String[]{TestGearsES2NEWT.class.getName()});
    }

    static {
        rwsize = null;
        reqSurfacePixelScale = new float[]{0.0f, 0.0f};
        duration = 500L;
        opaque = true;
        forceAlpha = -1;
        undecorated = false;
        alwaysOnTop = false;
        fullscreen = false;
        swapInterval = 1;
        waitForKey = false;
        mouseVisible = true;
        mouseConfined = false;
        setPointerIcon = false;
        showFPS = false;
        loops = 1;
        loop_shutdown = false;
        forceES2 = false;
        forceES3 = false;
        forceGL3 = false;
        forceGL2 = false;
        manualTest = false;
        exclusiveContext = false;
        useAnimator = true;
        useMappedBuffers = false;
        sysExit = SysExit.none;
    }

    static enum SysExit {
        none,
        testExit,
        testError,
        testEDTError,
        displayExit,
        displayError,
        displayEDTError;

    }
}

