/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.av;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Platform;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.test.junit.graph.TextRendererGLELBase;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.EyePose;
import com.jogamp.opengl.util.stereo.StereoClientRenderer;
import com.jogamp.opengl.util.stereo.StereoGLEventListener;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.net.URISyntaxException;
import java.nio.FloatBuffer;

public class MovieSBSStereo
implements StereoGLEventListener {
    public static final String WINDOW_KEY = "window";
    public static final String STEREO_RENDERER_KEY = "stereo";
    public static final String PLAYER = "player";
    private static boolean waitForKey = false;
    private int surfWidth;
    private int surfHeight;
    private int prevMouseX;
    private int rotate = 0;
    private float zoom0;
    private float zoom1;
    private float zoom;
    private long startTime;
    private final float alpha = 1.0f;
    private GLMediaPlayer mPlayer;
    private boolean mPlayerScaleOrig = false;
    private float[] verts = null;
    private GLArrayDataServer interleavedVBOLeft;
    private GLArrayDataServer interleavedVBORight;
    private volatile boolean resetGLState = false;
    private StereoClientRenderer stereoClientRenderer;
    private ShaderState st;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private static final String shaderBasename = "texsequence_xxx";
    private static final String myTextureLookupName = "myTexture2D";
    public static final Uri defURI;
    final int[] textSampleCount = new int[]{4};
    private final boolean enableTextRendererGLEL = false;
    private InfoTextRendererGLELBase textRendererGLEL = null;
    private boolean displayOSD = false;
    private final MouseListener mouseAction = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getY() <= MovieSBSStereo.this.surfHeight / 2 && null != MovieSBSStereo.this.mPlayer && 1 == mouseEvent.getClickCount()) {
                if (GLMediaPlayer.State.Playing == MovieSBSStereo.this.mPlayer.getState()) {
                    MovieSBSStereo.this.mPlayer.pause(false);
                } else {
                    MovieSBSStereo.this.mPlayer.play();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getY() <= MovieSBSStereo.this.surfHeight / 2) {
                MovieSBSStereo.this.rotate = -1;
                MovieSBSStereo.this.zoom = MovieSBSStereo.this.zoom0;
                System.err.println("zoom: " + MovieSBSStereo.this.zoom);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MovieSBSStereo.this.prevMouseX = mouseEvent.getX();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n2 > MovieSBSStereo.this.surfHeight / 2) {
                float f = (float)(n - MovieSBSStereo.this.prevMouseX) / (float)MovieSBSStereo.this.surfWidth;
                int n3 = -2 != MovieSBSStereo.this.mPlayer.getVID() ? MovieSBSStereo.this.mPlayer.getVideoPTS() : MovieSBSStereo.this.mPlayer.getAudioPTS();
                MovieSBSStereo.this.mPlayer.seek(n3 + (int)((float)MovieSBSStereo.this.mPlayer.getDuration() * f));
            } else {
                MovieSBSStereo.this.mPlayer.play();
                MovieSBSStereo.this.rotate = 1;
                MovieSBSStereo.this.zoom = MovieSBSStereo.this.zoom1;
            }
            MovieSBSStereo.this.prevMouseX = n;
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isShiftDown()) {
                MovieSBSStereo.this.zoom = MovieSBSStereo.this.zoom + mouseEvent.getRotation()[1] / 10.0f;
                System.err.println("zoom: " + MovieSBSStereo.this.zoom);
            }
        }
    };
    private final KeyListener keyAction = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.isAutoRepeat()) {
                return;
            }
            System.err.println("MC " + keyEvent);
            int n = -2 != MovieSBSStereo.this.mPlayer.getVID() ? MovieSBSStereo.this.mPlayer.getVideoPTS() : MovieSBSStereo.this.mPlayer.getAudioPTS();
            int n2 = 0;
            switch (keyEvent.getKeySymbol()) {
                case 79: {
                    MovieSBSStereo.this.displayOSD = !MovieSBSStereo.this.displayOSD;
                    break;
                }
                case 151: {
                    n2 = n + 1000;
                    break;
                }
                case 150: {
                    n2 = n + 10000;
                    break;
                }
                case 16: {
                    n2 = n + 30000;
                    break;
                }
                case 149: {
                    n2 = n - 1000;
                    break;
                }
                case 152: {
                    n2 = n - 10000;
                    break;
                }
                case 11: {
                    n2 = n - 30000;
                    break;
                }
                case 2: 
                case 8: 
                case 27: {
                    MovieSBSStereo.this.mPlayer.seek(0);
                    break;
                }
                case 32: {
                    if (GLMediaPlayer.State.Paused == MovieSBSStereo.this.mPlayer.getState()) {
                        MovieSBSStereo.this.mPlayer.play();
                        break;
                    }
                    MovieSBSStereo.this.mPlayer.pause(false);
                    break;
                }
                case 141: {
                    MovieSBSStereo.this.mPlayer.setPlaySpeed(1.0f);
                    break;
                }
                case 140: {
                    float f = MovieSBSStereo.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f /= 2.0f) : (f -= 0.1f);
                    MovieSBSStereo.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 139: {
                    float f = MovieSBSStereo.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f *= 2.0f) : (f += 0.1f);
                    MovieSBSStereo.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 77: {
                    float f = MovieSBSStereo.this.mPlayer.getAudioVolume();
                    f = f > 0.5f ? 0.0f : 1.0f;
                    MovieSBSStereo.this.mPlayer.setAudioVolume(f);
                }
            }
            if (0 != n2) {
                MovieSBSStereo.this.mPlayer.seek(n2);
            }
        }
    };
    private final float zNear = 0.1f;
    private final float zFar = 10000.0f;
    private final float[] mat4Tmp1 = new float[16];
    private final float[] mat4Tmp2 = new float[16];
    private final float[] vec3Tmp1 = new float[3];
    private final float[] vec3Tmp2 = new float[3];
    private final float[] vec3Tmp3 = new float[3];
    GLArrayDataServer interleavedVBOCurrent = null;
    long lastPerfPos = 0L;
    public static final StereoGLMediaEventListener stereoGLMediaEventListener;

    public MovieSBSStereo() throws IllegalStateException {
        this.mPlayer = GLMediaPlayerFactory.createDefault();
        this.mPlayer.attachObject(PLAYER, this);
        System.out.println("pC.1a " + this.mPlayer);
    }

    public void initStream(Uri uri, int n, int n2, int n3) {
        this.mPlayer.initStream(uri, n, n2, n3);
        System.out.println("pC.1b " + this.mPlayer);
    }

    public GLMediaPlayer getGLMediaPlayer() {
        return this.mPlayer;
    }

    public void setScaleOrig(boolean bl) {
        this.mPlayerScaleOrig = bl;
    }

    public void setStereoClientRenderer(StereoClientRenderer stereoClientRenderer) {
        this.stereoClientRenderer = stereoClientRenderer;
    }

    public StereoClientRenderer getStereoClientRenderer() {
        return this.stereoClientRenderer;
    }

    public void resetGLState() {
        this.resetGLState = true;
    }

    private void initShader(GL2ES2 gL2ES2) {
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, MovieSBSStereo.class, "../shader", "../shader/bin", shaderBasename, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, MovieSBSStereo.class, "../shader", "../shader/bin", shaderBasename, true);
        boolean bl = true;
        if (36197 == this.mPlayer.getTextureTarget()) {
            if (!gL2ES2.isExtensionAvailable("GL_OES_EGL_image_external")) {
                throw new GLException("GL_OES_EGL_image_external requested but not available");
            }
            if (Platform.OSType.ANDROID == Platform.getOSType() && gL2ES2.isGLES3()) {
                bl = false;
            }
        }
        shaderCode.defaultShaderCustomization(gL2ES2, bl, true);
        int n = bl ? shaderCode2.addGLSLVersion(gL2ES2) : 0;
        n = shaderCode2.insertShaderSource(0, n, this.mPlayer.getRequiredExtensionsShaderStub());
        shaderCode2.addDefaultShaderPrecision(gL2ES2, n);
        String string = this.mPlayer.getTextureLookupFunctionName(myTextureLookupName);
        shaderCode2.replaceInShaderSource(myTextureLookupName, string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("uniform ").append(this.mPlayer.getTextureSampler2DType()).append(" mgl_ActiveTexture;\n");
        stringBuilder.append(this.mPlayer.getTextureLookupFragmentShaderImpl());
        shaderCode2.insertShaderSource(0, "TEXTURE-SEQUENCE-CODE-BEGIN", 0, stringBuilder);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram(gL2ES2, shaderProgram, false);
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        Texture texture;
        Object object;
        if (null == this.mPlayer) {
            throw new InternalError("mPlayer null");
        }
        if (GLMediaPlayer.State.Uninitialized == this.mPlayer.getState()) {
            throw new IllegalStateException("mPlayer in uninitialized state: " + this.mPlayer);
        }
        boolean bl = -2 != this.mPlayer.getVID();
        this.resetGLState = false;
        this.zoom0 = -2.1f;
        this.zoom1 = -5.0f;
        this.zoom = 0.0f;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println(JoglVersion.getGLInfo(gL2ES2, null));
        System.err.println("Alpha: 1.0, opaque " + gLAutoDrawable.getChosenGLCapabilities().isBackgroundOpaque() + ", " + gLAutoDrawable.getClass().getName() + ", " + gLAutoDrawable);
        if (waitForKey) {
            UITestCase.waitForKey("Init>");
        }
        try {
            System.out.println("p0 " + this.mPlayer);
            if (GLMediaPlayer.State.Initialized == this.mPlayer.getState()) {
                this.mPlayer.initGL(gL2ES2);
            }
            System.out.println("p1 " + this.mPlayer);
            object = this.mPlayer.getLastTexture();
            if (null != object) {
                if (!bl) {
                    throw new InternalError("XXX: " + this.mPlayer);
                }
                texture = ((TextureSequence.TextureFrame)object).getTexture();
                if (null == texture) {
                    throw new InternalError("XXX: " + this.mPlayer);
                }
            } else {
                texture = null;
                if (bl) {
                    throw new InternalError("XXX: " + this.mPlayer);
                }
            }
            this.mPlayer.setTextureMinMagFilter(new int[]{9728, 9728});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (null != this.mPlayer) {
                this.mPlayer.destroy(gL2ES2);
                this.mPlayer = null;
            }
            throw new GLException(exception);
        }
        if (bl) {
            float f;
            float f2;
            this.initShader(gL2ES2);
            this.st.useProgram(gL2ES2, true);
            object = new int[]{0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight()};
            this.pmvMatrix = new PMVMatrix();
            this.reshapePMV((int)object[2], (int)object[3]);
            this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, this.pmvMatrix.glGetPMvMatrixf());
            if (!this.st.uniform(gL2ES2, this.pmvMatrixUniform)) {
                throw new GLException("Error setting PMVMatrix in shader: " + this.st);
            }
            if (!this.st.uniform(gL2ES2, new GLUniformData("mgl_ActiveTexture", this.mPlayer.getTextureUnit()))) {
                throw new GLException("Error setting mgl_ActiveTexture in shader: " + this.st);
            }
            float f3 = gLAutoDrawable.getSurfaceWidth();
            float f4 = gLAutoDrawable.getSurfaceHeight();
            float f5 = this.mPlayer.getWidth();
            float f6 = this.mPlayer.getHeight();
            float f7 = f5 / f6;
            System.err.println("XXX0: mov aspect: " + f7);
            if (this.mPlayerScaleOrig && f5 < f3 && f6 < f4) {
                f2 = f7 * (f5 / f3);
                f = f2 / f7;
            } else {
                f2 = f7;
                f = 1.0f;
            }
            this.verts = new float[]{-1.0f * f2, -1.0f * f, 0.0f, 1.0f * f2, 1.0f * f, 0.0f};
            System.err.println("XXX0: pixel  LB: " + this.verts[0] + ", " + this.verts[1] + ", " + this.verts[2]);
            System.err.println("XXX0: pixel  RT: " + this.verts[3] + ", " + this.verts[4] + ", " + this.verts[5]);
            float[] fArray = new float[3];
            float[] fArray2 = new float[3];
            this.pmvMatrix.gluProject(this.verts[0], this.verts[1], this.verts[2], (int[])object, 0, fArray, 0);
            this.pmvMatrix.gluProject(this.verts[3], this.verts[4], this.verts[5], (int[])object, 0, fArray2, 0);
            System.err.println("XXX0: win   LB: " + fArray[0] + ", " + fArray[1] + ", " + fArray[2]);
            System.err.println("XXX0: win   RT: " + fArray2[0] + ", " + fArray2[1] + ", " + fArray2[2]);
            this.interleavedVBOLeft = GLArrayDataServer.createGLSLInterleaved(9, 5126, false, 12, 35044);
            this.interleavedVBOLeft.addGLSLSubArray("mgl_Vertex", 3, 34962);
            this.interleavedVBOLeft.addGLSLSubArray("mgl_Color", 4, 34962);
            this.interleavedVBOLeft.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
            this.interleavedVBORight = GLArrayDataServer.createGLSLInterleaved(9, 5126, false, 12, 35044);
            this.interleavedVBORight.addGLSLSubArray("mgl_Vertex", 3, 34962);
            this.interleavedVBORight.addGLSLSubArray("mgl_Color", 4, 34962);
            this.interleavedVBORight.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
            this.updateInterleavedVBO(gL2ES2, this.interleavedVBOLeft, texture, 0);
            this.updateInterleavedVBO(gL2ES2, this.interleavedVBORight, texture, 1);
            this.st.ownAttribute(this.interleavedVBOLeft, true);
            this.st.ownAttribute(this.interleavedVBORight, true);
            gL2ES2.glClearColor(0.3f, 0.3f, 0.3f, 0.3f);
            gL2ES2.glEnable(2929);
            this.st.useProgram(gL2ES2, false);
            System.out.println("iVBOLeft : " + this.interleavedVBOLeft);
            System.out.println("iVBORight: " + this.interleavedVBORight);
            System.out.println(this.st);
        }
        this.mPlayer.play();
        System.out.println("play.0 " + this.mPlayer);
        this.startTime = System.currentTimeMillis();
        object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            window.addMouseListener(this.mouseAction);
            window.addKeyListener(this.keyAction);
            this.surfWidth = window.getSurfaceWidth();
            this.surfHeight = window.getSurfaceHeight();
        }
        int n = gLAutoDrawable.getChosenGLCapabilities().getSampleBuffers() ? 0 : 2;
        boolean bl2 = gL2ES2.isGLES();
        this.textRendererGLEL = null;
    }

    protected void updateInterleavedVBO(GL gL, GLArrayDataServer gLArrayDataServer, Texture texture, int n) {
        boolean bl = gLArrayDataServer.enabled();
        gLArrayDataServer.seal(gL, false);
        gLArrayDataServer.rewind();
        FloatBuffer floatBuffer = (FloatBuffer)gLArrayDataServer.getBuffer();
        TextureCoords textureCoords = texture.getImageTexCoords();
        float f = textureCoords.right() / 2.0f;
        System.err.println("XXX0: " + textureCoords + ", texHalfWidth " + f);
        System.err.println("XXX0: tex aspect: " + texture.getAspectRatio());
        System.err.println("XXX0: tex y-flip: " + texture.getMustFlipVertically());
        floatBuffer.put(this.verts[0]);
        floatBuffer.put(this.verts[1]);
        floatBuffer.put(this.verts[2]);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        if (0 == n) {
            floatBuffer.put(textureCoords.left());
            floatBuffer.put(textureCoords.bottom());
        } else {
            floatBuffer.put(textureCoords.left() + f);
            floatBuffer.put(textureCoords.bottom());
        }
        floatBuffer.put(this.verts[3]);
        floatBuffer.put(this.verts[1]);
        floatBuffer.put(this.verts[2]);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        if (0 == n) {
            floatBuffer.put(f);
            floatBuffer.put(textureCoords.bottom());
        } else {
            floatBuffer.put(textureCoords.right());
            floatBuffer.put(textureCoords.bottom());
        }
        floatBuffer.put(this.verts[0]);
        floatBuffer.put(this.verts[4]);
        floatBuffer.put(this.verts[2]);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        if (0 == n) {
            floatBuffer.put(textureCoords.left());
            floatBuffer.put(textureCoords.top());
        } else {
            floatBuffer.put(textureCoords.left() + f);
            floatBuffer.put(textureCoords.top());
        }
        floatBuffer.put(this.verts[3]);
        floatBuffer.put(this.verts[4]);
        floatBuffer.put(this.verts[2]);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        if (0 == n) {
            floatBuffer.put(f);
            floatBuffer.put(textureCoords.top());
        } else {
            floatBuffer.put(textureCoords.right());
            floatBuffer.put(textureCoords.top());
        }
        gLArrayDataServer.seal(gL, true);
        if (!bl) {
            gLArrayDataServer.enableBuffer(gL, false);
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.surfWidth = n3;
        this.surfHeight = n4;
        if (null == this.mPlayer) {
            return;
        }
        if (null != this.st) {
            this.reshapePMV(n3, n4);
            this.st.useProgram(gL2ES2, true);
            this.st.uniform(gL2ES2, this.pmvMatrixUniform);
            this.st.useProgram(gL2ES2, false);
        }
        System.out.println("pR " + this.mPlayer);
        if (null != this.textRendererGLEL) {
            this.textRendererGLEL.reshape(gLAutoDrawable, 0, 0, n3, n4);
        }
    }

    private void reshapePMV(int n, int n2) {
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.gluPerspective(45.0f, (float)n / (float)n2, 0.1f, 10000.0f);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom0);
    }

    @Override
    public void reshapeForEye(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4, EyeParameter eyeParameter, EyePose eyePose) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.interleavedVBOCurrent = 0 == eyeParameter.number ? this.interleavedVBOLeft : this.interleavedVBORight;
        this.surfWidth = gLAutoDrawable.getSurfaceWidth();
        this.surfHeight = gLAutoDrawable.getSurfaceHeight();
        if (null == this.mPlayer) {
            return;
        }
        if (null == this.st) {
            return;
        }
        this.pmvMatrix.glMatrixMode(5889);
        float[] fArray = FloatUtil.makePerspective(this.mat4Tmp1, 0, true, eyeParameter.fovhv, 0.1f, 10000.0f);
        this.pmvMatrix.glLoadMatrixf(fArray, 0);
        this.pmvMatrix.glMatrixMode(5888);
        Quaternion quaternion = new Quaternion();
        float[] fArray2 = quaternion.rotateVector(this.vec3Tmp1, 0, eyePose.position, 0);
        VectorUtil.addVec3(fArray2, fArray2, eyeParameter.positionOffset);
        quaternion.mult(eyePose.orientation);
        float[] fArray3 = quaternion.rotateVector(this.vec3Tmp2, 0, VectorUtil.VEC3_UNIT_Y, 0);
        float[] fArray4 = quaternion.rotateVector(this.vec3Tmp3, 0, VectorUtil.VEC3_UNIT_Z_NEG, 0);
        float[] fArray5 = VectorUtil.addVec3(fArray4, fArray2, fArray4);
        float[] fArray6 = FloatUtil.makeLookAt(this.mat4Tmp1, 0, fArray2, 0, fArray5, 0, fArray3, 0, this.mat4Tmp2);
        float[] fArray7 = FloatUtil.makeTranslation(this.mat4Tmp2, true, eyeParameter.distNoseToPupilX, eyeParameter.distMiddleToPupilY, eyeParameter.eyeReliefZ);
        float[] fArray8 = FloatUtil.multMatrix(fArray7, fArray6);
        this.pmvMatrix.glLoadMatrixf(fArray8, 0);
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom0);
        this.st.useProgram(gL2ES2, true);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
        if (null != this.textRendererGLEL) {
            this.textRendererGLEL.reshape(gLAutoDrawable, 0, 0, n3, n4);
        }
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (null != this.textRendererGLEL) {
            this.textRendererGLEL.dispose(gLAutoDrawable);
            this.textRendererGLEL = null;
        }
        this.disposeImpl(gLAutoDrawable, true);
    }

    private void disposeImpl(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Object object;
        if (null == this.mPlayer) {
            return;
        }
        Object object2 = gLAutoDrawable.getUpstreamWidget();
        if (object2 instanceof Window) {
            object = (Window)object2;
            object.removeMouseListener(this.mouseAction);
            object.removeKeyListener(this.keyAction);
        }
        System.out.println("pD.1 " + this.mPlayer + ", disposePlayer " + bl);
        object = gLAutoDrawable.getGL().getGL2ES2();
        if (bl) {
            this.mPlayer.destroy((GL)object);
            System.out.println("pD.X " + this.mPlayer);
            this.mPlayer = null;
        }
        this.pmvMatrixUniform = null;
        if (null != this.pmvMatrix) {
            this.pmvMatrix = null;
        }
        if (null != this.st) {
            this.st.destroy((GL2ES2)object);
            this.st = null;
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        this.display(gLAutoDrawable, 0);
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable, int n) {
        TextureSequence.TextureFrame textureFrame;
        long l;
        boolean bl = 0 != (1 & n);
        boolean bl2 = 0 != (2 & n);
        GLArrayDataServer gLArrayDataServer = null != this.interleavedVBOCurrent ? this.interleavedVBOCurrent : this.interleavedVBOLeft;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null == this.mPlayer) {
            return;
        }
        if (this.resetGLState) {
            this.resetGLState = false;
            System.err.println("XXX resetGLState");
            this.disposeImpl(gLAutoDrawable, false);
            this.init(gLAutoDrawable);
            this.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        }
        if ((l = System.currentTimeMillis()) - this.lastPerfPos > 2000L) {
            System.err.println(this.mPlayer.getPerfString());
            this.lastPerfPos = l;
        }
        if (!bl2) {
            gL2ES2.glClear(16640);
        }
        if (null == this.st) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glPushMatrix();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom);
        if (this.rotate > 0) {
            float f = (float)(System.currentTimeMillis() - this.startTime) * 360.0f / 8000.0f;
            this.pmvMatrix.glRotatef(f, 0.0f, 0.0f, 1.0f);
        } else {
            this.rotate = 0;
        }
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        gLArrayDataServer.enableBuffer(gL2ES2, true);
        Texture texture = null;
        if (null != this.mPlayer && null != (textureFrame = bl ? this.mPlayer.getLastTexture() : this.mPlayer.getNextTexture(gL2ES2))) {
            texture = textureFrame.getTexture();
            gL2ES2.glActiveTexture(33984 + this.mPlayer.getTextureUnit());
            texture.enable(gL2ES2);
            texture.bind(gL2ES2);
        }
        gL2ES2.glDrawArrays(5, 0, 4);
        if (null != texture) {
            texture.disable(gL2ES2);
        }
        gLArrayDataServer.enableBuffer(gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
        this.pmvMatrix.glPopMatrix();
        if (null != this.textRendererGLEL) {
            this.textRendererGLEL.display(gLAutoDrawable);
        }
    }

    static {
        Uri uri = null;
        try {
            uri = Uri.cast("http://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        defURI = uri;
        stereoGLMediaEventListener = new StereoGLMediaEventListener();
    }

    static class StereoGLMediaEventListener
    implements GLMediaPlayer.GLMediaEventListener {
        StereoGLMediaEventListener() {
        }

        void destroyWindow(final Window window) {
            new Thread(){

                @Override
                public void run() {
                    window.destroy();
                }
            }.start();
        }

        @Override
        public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
        }

        @Override
        public void attributesChanged(final GLMediaPlayer gLMediaPlayer, int n, long l) {
            System.err.println("MovieSimple AttributesChanges: events_mask 0x" + Integer.toHexString(n) + ", when " + l);
            System.err.println("MovieSimple State: " + gLMediaPlayer);
            GLWindow gLWindow = (GLWindow)gLMediaPlayer.getAttachedObject(MovieSBSStereo.WINDOW_KEY);
            MovieSBSStereo movieSBSStereo = (MovieSBSStereo)gLMediaPlayer.getAttachedObject(MovieSBSStereo.PLAYER);
            StereoClientRenderer stereoClientRenderer = (StereoClientRenderer)gLMediaPlayer.getAttachedObject(MovieSBSStereo.STEREO_RENDERER_KEY);
            if (0 != (0x40000 & n)) {
                System.err.println("MovieSimple State: CHANGE_SIZE");
                movieSBSStereo.resetGLState();
            }
            if (0 != (1 & n)) {
                System.err.println("MovieSimple State: INIT");
                stereoClientRenderer.addGLEventListener(movieSBSStereo);
                GLAnimatorControl gLAnimatorControl = gLWindow.getAnimator();
                gLAnimatorControl.setUpdateFPSFrames(60, null);
                gLAnimatorControl.resetFPSCounter();
                movieSBSStereo.setStereoClientRenderer(stereoClientRenderer);
            }
            if (0 != (4 & n)) {
                gLWindow.getAnimator().resetFPSCounter();
            }
            boolean bl = false;
            GLMediaPlayer.StreamException streamException = null;
            if (0 != (0x10 & n)) {
                streamException = movieSBSStereo.mPlayer.getStreamException();
                if (null != streamException) {
                    System.err.println("MovieSimple State: EOS + Exception");
                    bl = true;
                } else {
                    System.err.println("MovieSimple State: EOS");
                    new Thread(){

                        @Override
                        public void run() {
                            gLMediaPlayer.setPlaySpeed(1.0f);
                            gLMediaPlayer.seek(0);
                            gLMediaPlayer.play();
                        }
                    }.start();
                }
            }
            if (0 != (0x20 & n)) {
                streamException = movieSBSStereo.mPlayer.getStreamException();
                if (null != streamException) {
                    System.err.println("MovieSimple State: ERR + Exception");
                } else {
                    System.err.println("MovieSimple State: ERR");
                }
                bl = true;
            }
            if (bl) {
                if (null != streamException) {
                    streamException.printStackTrace();
                }
                this.destroyWindow(gLWindow);
            }
        }
    }

    private final class InfoTextRendererGLELBase
    extends TextRendererGLELBase {
        private final Font font;
        private final float fontSize = 1.0f;
        private final GLRegion regionFPS;

        InfoTextRendererGLELBase(int n, boolean bl) {
            super(n, MovieSBSStereo.this.textSampleCount);
            this.font = InfoTextRendererGLELBase.getFont(0, 0, 0);
            this.fontSize = 1.0f;
            this.setRendererCallbacks(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
            if (bl) {
                this.regionFPS = null;
            } else {
                this.regionFPS = GLRegion.create(this.renderModes, null);
                System.err.println("RegionFPS " + Region.getRenderModeString(this.renderModes) + ", sampleCount " + MovieSBSStereo.this.textSampleCount[0] + ", class " + this.regionFPS.getClass().getName());
            }
            this.staticRGBAColor[0] = 0.9f;
            this.staticRGBAColor[1] = 0.9f;
            this.staticRGBAColor[2] = 0.9f;
            this.staticRGBAColor[3] = 1.0f;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            if (null != this.regionFPS) {
                this.regionFPS.destroy(gLAutoDrawable.getGL().getGL2ES2());
            }
            super.dispose(gLAutoDrawable);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            float f = null != gLAnimatorControl ? gLAnimatorControl.getLastFPS() : 0.0f;
            float f2 = null != gLAnimatorControl ? gLAnimatorControl.getTotalFPS() : 0.0f;
            boolean bl = -2 != MovieSBSStereo.this.mPlayer.getVID();
            float f3 = (float)(bl ? MovieSBSStereo.this.mPlayer.getVideoPTS() : MovieSBSStereo.this.mPlayer.getAudioPTS()) / 1000.0f;
            float f4 = (float)MovieSBSStereo.this.mPlayer.getWidth() / (float)MovieSBSStereo.this.mPlayer.getHeight();
            String string = null != this.regionFPS ? "3.1" : "3.0";
            String string2 = String.format("%0" + string + "f/%0" + string + "f s, %s (%01.2fx, vol %01.2f), a %01.2f, fps %02.1f -> %02.1f / %02.1f", Float.valueOf(f3), Float.valueOf((float)MovieSBSStereo.this.mPlayer.getDuration() / 1000.0f), MovieSBSStereo.this.mPlayer.getState().toString().toLowerCase(), Float.valueOf(MovieSBSStereo.this.mPlayer.getPlaySpeed()), Float.valueOf(MovieSBSStereo.this.mPlayer.getAudioVolume()), Float.valueOf(f4), Float.valueOf(MovieSBSStereo.this.mPlayer.getFramerate()), Float.valueOf(f), Float.valueOf(f2));
            String string3 = String.format("audio: id %d, kbps %d, codec %s", MovieSBSStereo.this.mPlayer.getAID(), MovieSBSStereo.this.mPlayer.getAudioBitrate() / 1000, MovieSBSStereo.this.mPlayer.getAudioCodec());
            String string4 = String.format("video: id %d, kbps %d, codec %s", MovieSBSStereo.this.mPlayer.getVID(), MovieSBSStereo.this.mPlayer.getVideoBitrate() / 1000, MovieSBSStereo.this.mPlayer.getVideoCodec());
            String string5 = ((MovieSBSStereo)MovieSBSStereo.this).mPlayer.getUri().path.decode();
            if (MovieSBSStereo.this.displayOSD && null != this.renderer) {
                float f5 = this.font.getPixelSize(1.0f, this.dpiH);
                if (null != this.regionFPS) {
                    this.renderString(gLAutoDrawable, this.font, f5, string2, 1, 1, 0.0f, 0.0f, -1.0f, this.regionFPS);
                } else {
                    this.renderString(gLAutoDrawable, this.font, f5, string2, 1, 1, 0.0f, 0.0f, -1.0f, true);
                }
                this.renderString(gLAutoDrawable, this.font, f5, string3, 1, -4, 0.0f, 0.0f, -1.0f, true);
                this.renderString(gLAutoDrawable, this.font, f5, string4, 1, -3, 0.0f, 0.0f, 0.0f, true);
                this.renderString(gLAutoDrawable, this.font, f5, string5, 1, -2, 0.0f, 0.0f, 1.0f, true);
            }
        }
    }
}

