/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestIsRealizedConcurrency01AWT
extends UITestCase {
    static long durationPerTest = 500L;

    @Test
    public void testAddRemove() throws InterruptedException, InvocationTargetException {
        final Dimension dimension = new Dimension(512, 512);
        final GLCanvas gLCanvas = new GLCanvas();
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.addGLEventListener(new GearsES2());
        Animator animator = new Animator(gLCanvas);
        animator.start();
        final Frame frame = new Frame("Frame");
        Assert.assertNotNull((Object)frame);
        frame.add(gLCanvas);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setLocation(0, 0);
                frame.setPreferredSize(dimension);
                frame.setSize(dimension);
                frame.pack();
                frame.setVisible(true);
            }
        });
        Thread.sleep(durationPerTest / 2L);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(gLCanvas);
                frame.validate();
                frame.add(gLCanvas);
                frame.validate();
            }
        });
        Thread.sleep(durationPerTest / 2L);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                gLCanvas.destroy();
                frame.dispose();
            }
        });
        animator.stop();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
        }
        JUnitCore.main((String[])new String[]{TestIsRealizedConcurrency01AWT.class.getName()});
    }
}

