/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug816OSXCALayerPos03cB849AWT
extends UITestCase {
    static long duration = 1600L;
    static int width = 640;
    static int height = 480;

    @Test
    public void test() throws InterruptedException, InvocationTargetException {
        long l;
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos03cB849AWT.getGLP());
        final JFrame jFrame = new JFrame("TestBug816OSXCALayerPos03cAWT");
        Assert.assertNotNull((Object)jFrame);
        final Container container = jFrame.getContentPane();
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.addGLEventListener(new GearsES2(1));
        final JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(gLCanvas);
        Animator animator = new Animator();
        animator.add(gLCanvas);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(jFrame);
        final JCheckBox jCheckBox = new JCheckBox("Visible canvas", true);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = jCheckBox.getSelectedObjects() != null;
                System.err.println("XXXX Panel setVisible " + bl);
                jPanel.setVisible(bl);
                System.err.println("XXXX Visible: [panel " + jPanel.isVisible() + ", canvas " + gLCanvas.isVisible() + "]; Displayable: [panel " + jPanel.isDisplayable() + ", canvas " + gLCanvas.isDisplayable() + "]");
                if (jPanel.isVisible()) {
                    jFrame.validate();
                }
            }
        });
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jCheckBox, "North");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setSize(width, height);
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        animator.start();
        Assert.assertTrue((boolean)animator.isStarted());
        Assert.assertTrue((boolean)animator.isAnimating());
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull((Object)jFrame);
        Assert.assertNotNull((Object)gLCanvas);
        Assert.assertNotNull((Object)animator);
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)jFrame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                container.remove(jPanel);
                jFrame.dispose();
            }
        });
    }

    static GLProfile getGLP() {
        return GLProfile.getMaxProgrammableCore(true);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestBug816OSXCALayerPos03cB849AWT.class.getName()});
    }
}

