/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.swt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2SWT3
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    Display display = null;
    Shell shell1 = null;
    Composite composite1 = null;
    Shell shell2 = null;
    Composite composite2 = null;
    Shell shell3 = null;
    Composite composite3 = null;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2SWT3.setTestSupported(false);
        }
    }

    @Before
    public void init() {
        SWTAccessor.invoke(true, new Runnable(){

            @Override
            public void run() {
                TestSharedContextVBOES2SWT3.this.display = new Display();
                Assert.assertNotNull((Object)TestSharedContextVBOES2SWT3.this.display);
            }
        });
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestSharedContextVBOES2SWT3.this.shell1 = new Shell(TestSharedContextVBOES2SWT3.this.display);
                TestSharedContextVBOES2SWT3.this.shell1.setLayout((Layout)new FillLayout());
                TestSharedContextVBOES2SWT3.this.composite1 = new Composite((Composite)TestSharedContextVBOES2SWT3.this.shell1, 262144);
                TestSharedContextVBOES2SWT3.this.composite1.setLayout((Layout)new FillLayout());
                TestSharedContextVBOES2SWT3.this.shell2 = new Shell(TestSharedContextVBOES2SWT3.this.display);
                TestSharedContextVBOES2SWT3.this.shell2.setLayout((Layout)new FillLayout());
                TestSharedContextVBOES2SWT3.this.composite2 = new Composite((Composite)TestSharedContextVBOES2SWT3.this.shell2, 262144);
                TestSharedContextVBOES2SWT3.this.composite2.setLayout((Layout)new FillLayout());
                TestSharedContextVBOES2SWT3.this.shell3 = new Shell(TestSharedContextVBOES2SWT3.this.display);
                TestSharedContextVBOES2SWT3.this.shell3.setLayout((Layout)new FillLayout());
                TestSharedContextVBOES2SWT3.this.composite3 = new Composite((Composite)TestSharedContextVBOES2SWT3.this.shell3, 262144);
                TestSharedContextVBOES2SWT3.this.composite3.setLayout((Layout)new FillLayout());
            }
        });
    }

    @After
    public void release() {
        Assert.assertNotNull((Object)this.display);
        Assert.assertNotNull((Object)this.shell1);
        Assert.assertNotNull((Object)this.composite1);
        Assert.assertNotNull((Object)this.shell2);
        Assert.assertNotNull((Object)this.composite2);
        Assert.assertNotNull((Object)this.shell3);
        Assert.assertNotNull((Object)this.composite3);
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestSharedContextVBOES2SWT3.this.composite3.dispose();
                    TestSharedContextVBOES2SWT3.this.shell3.dispose();
                    TestSharedContextVBOES2SWT3.this.composite2.dispose();
                    TestSharedContextVBOES2SWT3.this.shell2.dispose();
                    TestSharedContextVBOES2SWT3.this.composite1.dispose();
                    TestSharedContextVBOES2SWT3.this.shell1.dispose();
                }
            });
            SWTAccessor.invoke(true, new Runnable(){

                @Override
                public void run() {
                    TestSharedContextVBOES2SWT3.this.display.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        this.display = null;
        this.shell1 = null;
        this.composite1 = null;
        this.shell2 = null;
        this.composite2 = null;
        this.shell3 = null;
        this.composite3 = null;
    }

    protected GLCanvas createGLCanvas(final Shell shell, Composite composite, final int n, final int n2, GearsES2 gearsES2) throws InterruptedException {
        GLCanvas gLCanvas = GLCanvas.create(composite, 0, caps, null);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.addGLEventListener(gearsES2);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                shell.setText("SWT GLCanvas Shared Gears Test");
                shell.setSize(width, height);
                shell.setLocation(n, n2);
            }
        });
        return gLCanvas;
    }

    @Test
    public void test01SyncedOneAnimator() throws InterruptedException {
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        final GLCanvas gLCanvas = this.createGLCanvas(this.shell1, this.composite1, 0, 0, gearsES2);
        animator.add(gLCanvas);
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        final GLCanvas gLCanvas2 = this.createGLCanvas(this.shell2, this.composite2, 0 + width, 0, gearsES22);
        gLCanvas2.setSharedAutoDrawable(gLCanvas);
        animator.add(gLCanvas2);
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        final GLCanvas gLCanvas3 = this.createGLCanvas(this.shell3, this.composite3, 0, height, gearsES23);
        gLCanvas3.setSharedAutoDrawable(gLCanvas);
        animator.add(gLCanvas3);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestSharedContextVBOES2SWT3.this.shell1.open();
                TestSharedContextVBOES2SWT3.this.shell2.open();
                TestSharedContextVBOES2SWT3.this.shell3.open();
            }
        });
        animator.start();
        Thread.sleep(160L);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLCanvas, true));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLCanvas2, true));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLCanvas3, true));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        GLContext gLContext = gLCanvas.getContext();
        GLContext gLContext2 = gLCanvas2.getContext();
        GLContext gLContext3 = gLCanvas3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                gLCanvas3.dispose();
                gLCanvas2.dispose();
                gLCanvas.dispose();
            }
        });
    }

    @Test
    public void test02AsyncEachAnimator() throws InterruptedException {
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        final GLCanvas gLCanvas = this.createGLCanvas(this.shell1, this.composite1, 0, 0, gearsES2);
        animator.add(gLCanvas);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestSharedContextVBOES2SWT3.this.shell1.open();
            }
        });
        animator.start();
        Thread.sleep(160L);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLCanvas, true));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Animator animator2 = new Animator();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        final GLCanvas gLCanvas2 = this.createGLCanvas(this.shell2, this.composite2, width, 0, gearsES22);
        gLCanvas2.setSharedAutoDrawable(gLCanvas);
        animator2.add(gLCanvas2);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestSharedContextVBOES2SWT3.this.shell2.open();
            }
        });
        animator2.start();
        Thread.sleep(200L);
        Animator animator3 = new Animator();
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        final GLCanvas gLCanvas3 = this.createGLCanvas(this.shell3, this.composite3, 0, height, gearsES23);
        gLCanvas3.setSharedAutoDrawable(gLCanvas);
        animator3.add(gLCanvas3);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestSharedContextVBOES2SWT3.this.shell3.open();
            }
        });
        animator3.start();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLCanvas2, true));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLCanvas3, true));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        GLContext gLContext = gLCanvas.getContext();
        GLContext gLContext2 = gLCanvas2.getContext();
        GLContext gLContext3 = gLCanvas3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        animator2.stop();
        Assert.assertEquals((Object)false, (Object)animator2.isAnimating());
        animator3.stop();
        Assert.assertEquals((Object)false, (Object)animator3.isAnimating());
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                gLCanvas3.dispose();
                gLCanvas2.dispose();
                gLCanvas.dispose();
            }
        });
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextVBOES2SWT3.class.getName()});
    }

    static {
        duration = 1000L;
    }
}

