/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2GL3;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLPixelStorageModes;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGPUMemSec01NEWT
extends UITestCase {
    static String hexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    static String exceptionMsg(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return string + ": fmt " + TestGPUMemSec01NEWT.hexString(n) + ", type " + TestGPUMemSec01NEWT.hexString(n2) + ", comps " + n3 + ", " + n4 + "x" + n5 + ", rowlenA1 " + n6 + ", rowlenA4 " + n7 + ", rowlenA8 " + n8;
    }

    static NEWTGLContext.WindowContext createCurrentGLOffscreenWindow(GLProfile gLProfile, int n, int n2) throws GLException, InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(gLCapabilities, n, n2, true);
        GL gL = windowContext.context.getGL();
        Assert.assertEquals((long)0L, (long)gL.glGetError());
        gL.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL.glEnable(2929);
        Assert.assertEquals((long)0L, (long)gL.glGetError());
        gL.glViewport(0, 0, n, n2);
        gL.glClear(16640);
        Assert.assertEquals((long)0L, (long)gL.glGetError());
        return windowContext;
    }

    static int readPixelsCheck(GL gL, int n, int n2, int n3, int n4, int n5) throws InterruptedException {
        IndexOutOfBoundsException indexOutOfBoundsException;
        GLPixelStorageModes gLPixelStorageModes;
        int n6;
        int n7;
        int n8;
        int n9;
        block19: {
            ByteBuffer byteBuffer;
            block18: {
                n9 = 0;
                n8 = n4 * n3;
                n7 = (n4 * n3 + 3) / 4 * 4;
                Assert.assertTrue((n7 % 4 == 0 ? 1 : 0) != 0);
                n6 = (n4 * n3 + 7) / 8 * 8;
                Assert.assertTrue((n6 % 8 == 0 ? 1 : 0) != 0);
                gLPixelStorageModes = new GLPixelStorageModes();
                gLPixelStorageModes.setPackAlignment(gL, 1);
                indexOutOfBoundsException = null;
                try {
                    byteBuffer = Buffers.newDirectByteBuffer(n5 * n8);
                    gL.glReadPixels(0, 0, n4, n5, n, n2, byteBuffer);
                    Assert.assertEquals((long)0L, (long)gL.glGetError());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                    indexOutOfBoundsException = indexOutOfBoundsException2;
                }
                Assert.assertNull((String)TestGPUMemSec01NEWT.exceptionMsg("Unexpected IndexOutOfBoundsException (size ok, alignment 1)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
                indexOutOfBoundsException = null;
                try {
                    byteBuffer = Buffers.newDirectByteBuffer(n5 * n8 - 10);
                    gL.glReadPixels(0, 0, n4, n5, n, n2, byteBuffer);
                    Assert.assertEquals((long)0L, (long)gL.glGetError());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException3) {
                    indexOutOfBoundsException = indexOutOfBoundsException3;
                    System.err.println(TestGPUMemSec01NEWT.exceptionMsg("OK Expected IndexOutOfBoundsException (size-10 bytes)", n, n2, n3, n4, n5, n8, n7, n6) + ": " + indexOutOfBoundsException.getMessage());
                    ++n9;
                }
                Assert.assertNotNull((String)TestGPUMemSec01NEWT.exceptionMsg("Expected IndexOutOfBoundsException (size-10 bytes)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
                indexOutOfBoundsException = null;
                try {
                    byteBuffer = Buffers.newDirectByteBuffer(n5 * n8 / 4);
                    gL.glReadPixels(0, 0, n4, n5, n, n2, byteBuffer);
                    Assert.assertEquals((long)0L, (long)gL.glGetError());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException4) {
                    indexOutOfBoundsException = indexOutOfBoundsException4;
                    System.err.println(TestGPUMemSec01NEWT.exceptionMsg("OK Expected IndexOutOfBoundsException (size/4 bytes)", n, n2, n3, n4, n5, n8, n7, n6) + ": " + indexOutOfBoundsException.getMessage());
                    ++n9;
                }
                Assert.assertNotNull((String)TestGPUMemSec01NEWT.exceptionMsg("Expected IndexOutOfBoundsException (size/4 bytes)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
                indexOutOfBoundsException = null;
                gLPixelStorageModes.setPackAlignment(gL, 4);
                try {
                    byteBuffer = Buffers.newDirectByteBuffer(n5 * n7);
                    gL.glReadPixels(0, 0, n4, n5, n, n2, byteBuffer);
                    Assert.assertEquals((long)0L, (long)gL.glGetError());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException5) {
                    indexOutOfBoundsException = indexOutOfBoundsException5;
                }
                Assert.assertNull((String)TestGPUMemSec01NEWT.exceptionMsg("Unexpected IndexOutOfBoundsException (size ok, alignment 4)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
                indexOutOfBoundsException = null;
                try {
                    byteBuffer = Buffers.newDirectByteBuffer(n5 * n8);
                    gL.glReadPixels(0, 0, n4, n5, n, n2, byteBuffer);
                    Assert.assertEquals((long)0L, (long)gL.glGetError());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException6) {
                    indexOutOfBoundsException = indexOutOfBoundsException6;
                    if (n8 % 4 <= 0) break block18;
                    System.err.println(TestGPUMemSec01NEWT.exceptionMsg("OK Expected IndexOutOfBoundsException (alignment 4)", n, n2, n3, n4, n5, n8, n7, n6) + ": " + indexOutOfBoundsException.getMessage());
                    ++n9;
                }
            }
            if (n8 % 4 > 0) {
                Assert.assertNotNull((String)TestGPUMemSec01NEWT.exceptionMsg("Expected IndexOutOfBoundsException (alignment 4)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
            } else {
                Assert.assertNull((String)TestGPUMemSec01NEWT.exceptionMsg("Unexpected IndexOutOfBoundsException (alignment 4)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
            }
            indexOutOfBoundsException = null;
            gLPixelStorageModes.setPackAlignment(gL, 8);
            try {
                byteBuffer = Buffers.newDirectByteBuffer(n5 * n6);
                gL.glReadPixels(0, 0, n4, n5, n, n2, byteBuffer);
                Assert.assertEquals((long)0L, (long)gL.glGetError());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException7) {
                indexOutOfBoundsException = indexOutOfBoundsException7;
            }
            Assert.assertNull((String)TestGPUMemSec01NEWT.exceptionMsg("Unexpected IndexOutOfBoundsException (size ok, alignment 8)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
            indexOutOfBoundsException = null;
            try {
                byteBuffer = Buffers.newDirectByteBuffer(n5 * n8);
                gL.glReadPixels(0, 0, n4, n5, n, n2, byteBuffer);
                Assert.assertEquals((long)0L, (long)gL.glGetError());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException8) {
                indexOutOfBoundsException = indexOutOfBoundsException8;
                if (n8 % 8 <= 0) break block19;
                System.err.println(TestGPUMemSec01NEWT.exceptionMsg("OK Expected IndexOutOfBoundsException (alignment 8)", n, n2, n3, n4, n5, n8, n7, n6) + ": " + indexOutOfBoundsException.getMessage());
                ++n9;
            }
        }
        if (n8 % 8 > 0) {
            Assert.assertNotNull((String)TestGPUMemSec01NEWT.exceptionMsg("Expected IndexOutOfBoundsException (alignment 8)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
        } else {
            Assert.assertNull((String)TestGPUMemSec01NEWT.exceptionMsg("Unexpected IndexOutOfBoundsException (alignment 8)", n, n2, n3, n4, n5, n8, n7, n6), (Object)indexOutOfBoundsException);
        }
        indexOutOfBoundsException = null;
        gLPixelStorageModes.restore(gL);
        return n9;
    }

    @Test
    public void testReadPixelsGL_640x480xRGBAxUB() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        NEWTGLContext.WindowContext windowContext = TestGPUMemSec01NEWT.createCurrentGLOffscreenWindow(gLProfile, 640, 480);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL gL = windowContext.context.getGL();
        Assert.assertEquals((long)2L, (long)TestGPUMemSec01NEWT.readPixelsCheck(gL, 6408, 5121, 4, 640, 480));
        gLDrawable.swapBuffers();
        Thread.sleep(50L);
        NEWTGLContext.destroyWindow(windowContext);
    }

    @Test
    public void testReadPixelsGL_99x100xRGBxUB() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        NEWTGLContext.WindowContext windowContext = TestGPUMemSec01NEWT.createCurrentGLOffscreenWindow(gLProfile, 640, 480);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL gL = windowContext.context.getGL();
        Assert.assertEquals((long)3L, (long)TestGPUMemSec01NEWT.readPixelsCheck(gL, 6408, 5121, 4, 99, 100));
        gLDrawable.swapBuffers();
        Thread.sleep(50L);
        NEWTGLContext.destroyWindow(windowContext);
    }

    @Test
    public void testReadPixelsGL2GL3_640x480xRGBxUB() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        if (!gLProfile.isGL2ES3()) {
            System.err.println("GL2ES3 n/a skip test");
            return;
        }
        NEWTGLContext.WindowContext windowContext = TestGPUMemSec01NEWT.createCurrentGLOffscreenWindow(gLProfile, 640, 480);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL gL = windowContext.context.getGL();
        Assert.assertEquals((long)2L, (long)TestGPUMemSec01NEWT.readPixelsCheck(gL, 6407, 5121, 3, 640, 480));
        gLDrawable.swapBuffers();
        Thread.sleep(50L);
        NEWTGLContext.destroyWindow(windowContext);
    }

    @Test
    public void testReadPixelsGL2GL3_99x100xRGBxUB() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        if (!gLProfile.isGL2ES3()) {
            System.err.println("GL2ES3 n/a skip test");
            return;
        }
        NEWTGLContext.WindowContext windowContext = TestGPUMemSec01NEWT.createCurrentGLOffscreenWindow(gLProfile, 640, 480);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL gL = windowContext.context.getGL();
        Assert.assertEquals((long)4L, (long)TestGPUMemSec01NEWT.readPixelsCheck(gL, 6407, 5121, 3, 99, 100));
        gLDrawable.swapBuffers();
        Thread.sleep(50L);
        NEWTGLContext.destroyWindow(windowContext);
    }

    @Test
    public void testReadPixelsGL2GL3_640x480xREDxUB() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        if (!gLProfile.isGL2ES3()) {
            System.err.println("GL2ES3 n/a skip test");
            return;
        }
        NEWTGLContext.WindowContext windowContext = TestGPUMemSec01NEWT.createCurrentGLOffscreenWindow(gLProfile, 640, 480);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2GL3 gL2GL3 = windowContext.context.getGL().getGL2GL3();
        Assert.assertEquals((long)2L, (long)TestGPUMemSec01NEWT.readPixelsCheck(gL2GL3, 6403, 5121, 1, 640, 480));
        gLDrawable.swapBuffers();
        Thread.sleep(50L);
        NEWTGLContext.destroyWindow(windowContext);
    }

    @Test
    public void testReadPixelsGL2GL3_102x100xREDxUB() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        if (!gLProfile.isGL2ES3()) {
            System.err.println("GL2ES3 n/a skip test");
            return;
        }
        NEWTGLContext.WindowContext windowContext = TestGPUMemSec01NEWT.createCurrentGLOffscreenWindow(gLProfile, 640, 480);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2GL3 gL2GL3 = windowContext.context.getGL().getGL2GL3();
        Assert.assertEquals((long)4L, (long)TestGPUMemSec01NEWT.readPixelsCheck(gL2GL3, 6403, 5121, 1, 102, 100));
        gLDrawable.swapBuffers();
        Thread.sleep(50L);
        NEWTGLContext.destroyWindow(windowContext);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGPUMemSec01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

