/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.graph.TextRendererGLELBase;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class GLReadBuffer00Base
extends UITestCase {
    static long duration = 500L;

    @BeforeClass
    public static void initClass() throws IOException {
        GLProfile.initSingleton();
    }

    protected abstract void test(GLCapabilitiesImmutable var1, boolean var2, boolean var3);

    @Test
    public void test00_MSAA0_DefFlip() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false);
    }

    @Test
    public void test01_MSAA0_UsrFlip() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, true);
    }

    @Test
    public void test10_MSAA8_DefFlip() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setNumSamples(8);
        gLCapabilities.setSampleBuffers(true);
        this.test(gLCapabilities, false, false);
    }

    @Test
    public void test11_MSAA8_UsrFlip() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setNumSamples(8);
        gLCapabilities.setSampleBuffers(true);
        this.test(gLCapabilities, false, true);
    }

    public static class TextRendererGLEL
    extends TextRendererGLELBase {
        final Font font = TextRendererGLEL.getFont(0, 0, 0);
        public int frameNo = 0;
        public int userCounter = 0;
        private final GLRegion regionFPS;

        public TextRendererGLEL() {
            super(2, new int[]{4});
            this.setRendererCallbacks(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
            this.regionFPS = GLRegion.create(this.renderModes, null);
            this.staticRGBAColor[0] = 0.9f;
            this.staticRGBAColor[1] = 0.9f;
            this.staticRGBAColor[2] = 0.9f;
            this.staticRGBAColor[3] = 0.99f;
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            this.regionFPS.destroy(gLAutoDrawable.getGL().getGL2ES2());
            super.dispose(gLAutoDrawable);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            String string = String.format("Frame %04d (%03d): %04dx%04d", this.frameNo, this.userCounter, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
            System.err.println("TextRendererGLEL.display: " + string);
            if (null != this.renderer) {
                float f = this.font.getPixelSize(14.0f, this.dpiH);
                gLAutoDrawable.getGL().glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
                this.renderString(gLAutoDrawable, this.font, f, string, 0, 0, 0.0f, 0.0f, -1.0f, this.regionFPS);
            } else {
                System.err.println(string);
            }
            ++this.frameNo;
        }
    }
}

