/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.PinchToZoomGesture;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.graph.demos.ui.UIShape;
import com.jogamp.opengl.util.PMVMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class SceneUIController
implements GLEventListener {
    private final ArrayList<UIShape> shapes = new ArrayList();
    private final float sceneDist;
    private final float zNear;
    private final float zFar;
    private RegionRenderer renderer;
    private final int[] sampleCount = new int[1];
    private final AABBox nearPlane1Box = new AABBox();
    private final int[] viewport = new int[]{0, 0, 0, 0};
    private final float[] sceneScale = new float[3];
    private final float[] scenePlaneOrigin = new float[3];
    private volatile UIShape activeShape = null;
    private SBCMouseListener sbcMouseListener = null;
    private SBCGestureListener sbcGestureListener = null;
    private PinchToZoomGesture pinchToZoomGesture = null;
    private GLAutoDrawable cDrawable = null;
    private static Comparator<UIShape> shapeZAscComparator = new Comparator<UIShape>(){

        @Override
        public int compare(UIShape uIShape, UIShape uIShape2) {
            float f;
            float f2 = uIShape.getBounds().getMinZ() + uIShape.getTranslate()[2];
            if (FloatUtil.isEqual(f2, f = uIShape2.getBounds().getMinZ() + uIShape2.getTranslate()[2], 1.1920929E-7f)) {
                return 0;
            }
            if (f2 < f) {
                return -1;
            }
            return 1;
        }
    };
    private final float[] dpyTmp1V3 = new float[3];
    private final float[] dpyTmp2V3 = new float[3];
    private final float[] dpyTmp3V3 = new float[3];

    public SceneUIController(float f, float f2, float f3) {
        this(null, f, f2, f3);
    }

    public SceneUIController(RegionRenderer regionRenderer, float f, float f2, float f3) {
        this.renderer = regionRenderer;
        this.sceneDist = f;
        this.zFar = f3;
        this.zNear = f2;
        this.sampleCount[0] = 4;
    }

    public void setRenderer(RegionRenderer regionRenderer) {
        this.renderer = regionRenderer;
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.sbcMouseListener) {
            this.sbcMouseListener = new SBCMouseListener();
            gLWindow.addMouseListener(this.sbcMouseListener);
            this.sbcGestureListener = new SBCGestureListener();
            gLWindow.addGestureListener(this.sbcGestureListener);
            this.pinchToZoomGesture = new PinchToZoomGesture(gLWindow.getNativeSurface(), false);
            gLWindow.addGestureHandler(this.pinchToZoomGesture);
        }
    }

    public void detachInputListenerFrom(GLWindow gLWindow) {
        if (null != this.sbcMouseListener) {
            gLWindow.removeMouseListener(this.sbcMouseListener);
            this.sbcMouseListener = null;
            gLWindow.removeGestureListener(this.sbcGestureListener);
            this.sbcGestureListener = null;
            gLWindow.removeGestureHandler(this.pinchToZoomGesture);
            this.pinchToZoomGesture = null;
        }
    }

    public ArrayList<UIShape> getShapes() {
        return this.shapes;
    }

    public void addShape(UIShape uIShape) {
        this.shapes.add(uIShape);
    }

    public void removeShape(UIShape uIShape) {
        this.shapes.remove(uIShape);
    }

    public int getSampleCount() {
        return this.sampleCount[0];
    }

    public int setSampleCount(int n) {
        this.sampleCount[0] = Math.min(8, Math.max(n, 1));
        this.markAllShapesDirty();
        return this.sampleCount[0];
    }

    public void setAllShapesQuality(int n) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).setQuality(n);
        }
    }

    public void setAllShapesSharpness(float f) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).setSharpness(f);
        }
    }

    public void markAllShapesDirty() {
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).markShapeDirty();
        }
    }

    public final float[] getSceneScale() {
        return this.sceneScale;
    }

    public final float[] getScenePlaneOrigin() {
        return this.scenePlaneOrigin;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println("SceneUIController: init");
        this.cDrawable = gLAutoDrawable;
    }

    private void transformShape(PMVMatrix pMVMatrix, UIShape uIShape) {
        boolean bl;
        float[] fArray = uIShape.getTranslate();
        pMVMatrix.glTranslatef(fArray[0], fArray[1], fArray[2]);
        Quaternion quaternion = uIShape.getRotation();
        boolean bl2 = !quaternion.isIdentity();
        float[] fArray2 = uIShape.getScale();
        boolean bl3 = bl = !VectorUtil.isVec3Equal(fArray2, 0, VectorUtil.VEC3_ONE, 0, 1.1920929E-7f);
        if (bl2 || bl) {
            boolean bl4;
            float[] fArray3 = uIShape.getRotationOrigin();
            boolean bl5 = bl4 = !VectorUtil.isVec3Zero(fArray3, 0, 1.1920929E-7f);
            if (bl4) {
                pMVMatrix.glTranslatef(fArray3[0], fArray3[1], fArray3[2]);
            }
            if (bl) {
                pMVMatrix.glScalef(fArray2[0], fArray2[1], fArray2[2]);
            }
            if (bl2) {
                pMVMatrix.glRotate(quaternion);
            }
            if (bl4) {
                pMVMatrix.glTranslatef(-fArray3[0], -fArray3[1], -fArray3[2]);
            }
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL2ES2.glClear(16640);
        PMVMatrix pMVMatrix = this.renderer.getMatrix();
        pMVMatrix.glMatrixMode(5888);
        Object[] objectArray = this.shapes.toArray();
        Arrays.sort(objectArray, shapeZAscComparator);
        this.renderer.enable(gL2ES2, true);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            UIShape uIShape = (UIShape)objectArray[i];
            if (!uIShape.isEnabled()) continue;
            uIShape.validate(gL2ES2, this.renderer);
            pMVMatrix.glPushMatrix();
            this.transformShape(pMVMatrix, uIShape);
            uIShape.drawShape(gL2ES2, this.renderer, this.sampleCount);
            pMVMatrix.glPopMatrix();
        }
        this.renderer.enable(gL2ES2, false);
    }

    public void pickShape(final int n, final int n2, final float[] fArray, final UIShape[] uIShapeArray, final Runnable runnable) {
        if (null == this.cDrawable) {
            return;
        }
        this.cDrawable.invoke(false, new GLRunnable(){

            @Override
            public boolean run(GLAutoDrawable gLAutoDrawable) {
                uIShapeArray[0] = SceneUIController.this.pickShapeImpl(n, n2, fArray);
                if (null != uIShapeArray[0]) {
                    runnable.run();
                }
                return true;
            }
        });
    }

    private UIShape pickShapeImpl(int n, int n2, float[] fArray) {
        PMVMatrix pMVMatrix = this.renderer.getMatrix();
        pMVMatrix.glMatrixMode(5888);
        Ray ray = new Ray();
        Object[] objectArray = this.shapes.toArray();
        Arrays.sort(objectArray, shapeZAscComparator);
        for (int i = objectArray.length - 1; i >= 0; --i) {
            AABBox aABBox;
            UIShape uIShape = (UIShape)objectArray[i];
            if (!uIShape.isEnabled()) continue;
            pMVMatrix.glPushMatrix();
            this.transformShape(pMVMatrix, uIShape);
            boolean bl = pMVMatrix.gluUnProjectRay(n, n2, 0.0f, 0.3f, this.viewport, 0, ray);
            pMVMatrix.glPopMatrix();
            if (!bl || !(aABBox = uIShape.getBounds()).intersectsRay(ray)) continue;
            if (null == aABBox.getRayIntersection(fArray, ray, 1.1920929E-7f, true, this.dpyTmp1V3, this.dpyTmp2V3, this.dpyTmp3V3)) {
                throw new InternalError("Ray " + ray + ", box " + aABBox);
            }
            return uIShape;
        }
        return null;
    }

    public void windowToShapeCoords(final UIShape uIShape, final int n, final int n2, final float[] fArray, final Runnable runnable) {
        if (null == this.cDrawable || null == uIShape) {
            return;
        }
        this.cDrawable.invoke(false, new GLRunnable(){

            @Override
            public boolean run(GLAutoDrawable gLAutoDrawable) {
                if (SceneUIController.this.windowToShapeCoordsImpl(uIShape, n, n2, fArray)) {
                    runnable.run();
                }
                return true;
            }
        });
    }

    private boolean windowToShapeCoordsImpl(UIShape uIShape, int n, int n2, float[] fArray) {
        PMVMatrix pMVMatrix = this.renderer.getMatrix();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glPushMatrix();
        this.transformShape(pMVMatrix, uIShape);
        boolean bl = false;
        float[] fArray2 = uIShape.getBounds().getCenter();
        if (pMVMatrix.gluProject(fArray2[0], fArray2[1], fArray2[2], this.viewport, 0, this.dpyTmp1V3, 0) && pMVMatrix.gluUnProject(n, n2, this.dpyTmp1V3[2], this.viewport, 0, fArray, 0)) {
            bl = true;
        }
        pMVMatrix.glPopMatrix();
        return bl;
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println("SceneUIController: dispose");
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).destroy(gL2ES2, this.renderer);
        }
        this.shapes.clear();
        this.cDrawable = null;
    }

    public static void mapWin2ObjectCoords(PMVMatrix pMVMatrix, int[] nArray, float f, float f2, float f3, float f4, float f5, float[] fArray, float[] fArray2) {
        fArray[0] = FloatUtil.getOrthoWinZ(f5, f, f2);
        pMVMatrix.gluUnProject(f3, f4, fArray[0], nArray, 0, fArray2, 0);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.viewport[0] = n;
        this.viewport[1] = n2;
        this.viewport[2] = n3;
        this.viewport[3] = n4;
        PMVMatrix pMVMatrix = this.renderer.getMatrix();
        this.renderer.reshapePerspective(45.0f, n3, n4, this.zNear, this.zFar);
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        System.err.printf("Reshape: zNear %f,  zFar %f%n", Float.valueOf(this.zNear), Float.valueOf(this.zFar));
        System.err.printf("Reshape: Frustum: %s%n", pMVMatrix.glGetFrustum());
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[1];
        SceneUIController.mapWin2ObjectCoords(pMVMatrix, this.viewport, this.zNear, this.zFar, 0.0f, 0.0f, 1.0f, fArray3, fArray);
        System.err.printf("Reshape: mapped.00: [%f, %f, %f], winZ %f -> [%f, %f, %f]%n", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(fArray3[0]), Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]));
        SceneUIController.mapWin2ObjectCoords(pMVMatrix, this.viewport, this.zNear, this.zFar, n3, n4, 1.0f, fArray3, fArray2);
        System.err.printf("Reshape: mapped.11: [%f, %f, %f], winZ %f -> [%f, %f, %f]%n", Float.valueOf(n3), Float.valueOf(n4), Float.valueOf(1.0f), Float.valueOf(fArray3[0]), Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), Float.valueOf(fArray2[2]));
        this.nearPlane1Box.setSize(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2]);
        System.err.printf("Reshape: dist1Box: %s%n", this.nearPlane1Box);
        this.scenePlaneOrigin[0] = this.nearPlane1Box.getMinX() * this.sceneDist;
        this.scenePlaneOrigin[1] = this.nearPlane1Box.getMinY() * this.sceneDist;
        this.scenePlaneOrigin[2] = this.nearPlane1Box.getMinZ() * this.sceneDist;
        this.sceneScale[0] = this.nearPlane1Box.getWidth() * this.sceneDist / (float)n3;
        this.sceneScale[1] = this.nearPlane1Box.getHeight() * this.sceneDist / (float)n4;
        this.sceneScale[2] = 1.0f;
        System.err.printf("Scene Origin [%f, %f, %f]%n", Float.valueOf(this.scenePlaneOrigin[0]), Float.valueOf(this.scenePlaneOrigin[1]), Float.valueOf(this.scenePlaneOrigin[2]));
        System.err.printf("Scene Scale  %f * [%f x %f] / [%d x %d] = [%f, %f, %f]%n", Float.valueOf(this.sceneDist), Float.valueOf(this.nearPlane1Box.getWidth()), Float.valueOf(this.nearPlane1Box.getHeight()), n3, n4, Float.valueOf(this.sceneScale[0]), Float.valueOf(this.sceneScale[1]), Float.valueOf(this.sceneScale[2]));
        pMVMatrix.glTranslatef(this.scenePlaneOrigin[0], this.scenePlaneOrigin[1], this.scenePlaneOrigin[2]);
        pMVMatrix.glScalef(this.sceneScale[0], this.sceneScale[1], this.sceneScale[2]);
    }

    public final UIShape getShape(int n) {
        if (0 > n) {
            return null;
        }
        return this.shapes.get(n);
    }

    public final UIShape getActiveShape() {
        return this.activeShape;
    }

    public void release() {
        this.setActiveShape(null);
    }

    private void setActiveShape(UIShape uIShape) {
        this.activeShape = uIShape;
    }

    final void dispatchMouseEvent(MouseEvent mouseEvent, int n, int n2) {
        if (null == this.activeShape) {
            this.dispatchMouseEventPickShape(mouseEvent, n, n2, true);
        } else {
            this.dispatchMouseEventForShape(this.activeShape, mouseEvent, n, n2);
        }
    }

    final void dispatchMouseEventPickShape(final MouseEvent mouseEvent, final int n, final int n2, final boolean bl) {
        final float[] fArray = new float[3];
        final UIShape[] uIShapeArray = new UIShape[]{null};
        this.pickShape(n, n2, fArray, uIShapeArray, new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    SceneUIController.this.setActiveShape(uIShapeArray[0]);
                }
                uIShapeArray[0].dispatchMouseEvent(mouseEvent, n, n2, fArray);
            }
        });
    }

    final void dispatchMouseEventForShape(final UIShape uIShape, final MouseEvent mouseEvent, final int n, final int n2) {
        final float[] fArray = new float[3];
        this.windowToShapeCoords(uIShape, n, n2, fArray, new Runnable(){

            @Override
            public void run() {
                uIShape.dispatchMouseEvent(mouseEvent, n, n2, fArray);
            }
        });
    }

    private class SBCMouseListener
    implements MouseListener {
        int lx = -1;
        int ly = -1;
        int lId = -1;

        private SBCMouseListener() {
        }

        void clear() {
            this.lx = -1;
            this.ly = -1;
            this.lId = -1;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (-1 == this.lId || mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                this.lId = mouseEvent.getPointerId(0);
            }
            int n = mouseEvent.getX();
            int n2 = SceneUIController.this.viewport[3] - mouseEvent.getY() - 1;
            SceneUIController.this.dispatchMouseEvent(mouseEvent, n, n2);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = SceneUIController.this.viewport[3] - mouseEvent.getY() - 1;
            SceneUIController.this.dispatchMouseEvent(mouseEvent, n, n2);
            if (1 == mouseEvent.getPointerCount()) {
                SceneUIController.this.release();
                this.clear();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = SceneUIController.this.viewport[3] - mouseEvent.getY() - 1;
            SceneUIController.this.dispatchMouseEventPickShape(mouseEvent, n, n2, false);
            SceneUIController.this.release();
            this.clear();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (null != SceneUIController.this.activeShape && !SceneUIController.this.pinchToZoomGesture.isWithinGesture() && mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                int n = this.lx;
                int n2 = SceneUIController.this.viewport[3] - this.ly - 1;
                SceneUIController.this.dispatchMouseEventForShape(SceneUIController.this.activeShape, mouseEvent, n, n2);
            }
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
            int n = this.lx;
            int n2 = SceneUIController.this.viewport[3] - this.ly - 1;
            SceneUIController.this.dispatchMouseEventPickShape(mouseEvent, n, n2, true);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (-1 == this.lId || mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                this.lId = mouseEvent.getPointerId(0);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SceneUIController.this.release();
            this.clear();
        }
    }

    private final class SBCGestureListener
    implements GestureHandler.GestureListener {
        private SBCGestureListener() {
        }

        @Override
        public void gestureDetected(final GestureHandler.GestureEvent gestureEvent) {
            InputEvent inputEvent;
            if (null != SceneUIController.this.activeShape && (inputEvent = gestureEvent.getTrigger()) instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                final int n = mouseEvent.getX();
                final int n2 = SceneUIController.this.viewport[3] - mouseEvent.getY() - 1;
                final float[] fArray = new float[3];
                final UIShape uIShape = SceneUIController.this.activeShape;
                SceneUIController.this.windowToShapeCoords(uIShape, n, n2, fArray, new Runnable(){

                    @Override
                    public void run() {
                        uIShape.dispatchGestureEvent(gestureEvent, n, n2, fArray);
                    }
                });
            }
        }
    }
}

