/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParenting01cAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @Test
    public void test01CreateVisibleDestroy1() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        Assert.assertNotNull((Object)gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertNull((Object)gLWindow.getParent());
        gLWindow.setTitle("testWindowParenting01CreateVisibleDestroy");
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01cAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        Assert.assertNotNull((Object)newtCanvasAWT);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertNull((Object)gLWindow.getParent());
        final Frame frame = new Frame("AWT Parent Frame");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Button("North"), "North");
        frame.add((Component)new Button("South"), "South");
        frame.add((Component)new Button("East"), "East");
        frame.add((Component)new Button("West"), "West");
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)new Button("north"), "North");
        container.add((Component)new Button("south"), "South");
        container.add((Component)new Button("east"), "East");
        container.add((Component)new Button("west"), "West");
        container.add((Component)newtCanvasAWT, "Center");
        frame.add((Component)container, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)newtCanvasAWT.getNativeWindow(), (Object)gLWindow.getParent());
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        boolean bl = gLWindow.getChosenCapabilities().isOnscreen();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(newtCanvasAWT);
            }
        });
        if (bl) {
            Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        if (bl) {
            Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        }
        gLWindow.destroy();
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
    }

    @Test
    public void test02AWTWinHopFrame2Frame() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        gLWindow.setUndecorated(true);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01cAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        final Frame frame = new Frame("AWT Parent Frame");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Button("North"), "North");
        frame.add((Component)new Button("South"), "South");
        frame.add((Component)new Button("East"), "East");
        frame.add((Component)new Button("West"), "West");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setLocation(0, 0);
                frame.setVisible(true);
            }
        });
        final Frame frame2 = new Frame("AWT Parent Frame");
        frame2.setLayout(new BorderLayout());
        frame2.add((Component)new Button("North"), "North");
        frame2.add((Component)new Button("South"), "South");
        frame2.add((Component)new Button("East"), "East");
        frame2.add((Component)new Button("West"), "West");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setSize(width, height);
                frame2.setLocation(640, 480);
                frame2.setVisible(true);
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.add((Component)newtCanvasAWT, "Center");
                frame.validate();
            }
        });
        Assert.assertEquals((Object)newtCanvasAWT.getNativeWindow(), (Object)gLWindow.getParent());
        block4: for (int i = 0; i < 3; ++i) {
            Thread.sleep(durationPerTest);
            switch (i) {
                case 0: {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            frame.remove(newtCanvasAWT);
                            frame2.add((Component)newtCanvasAWT, "Center");
                            frame.validate();
                            frame2.validate();
                        }
                    });
                    continue block4;
                }
                case 1: {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            frame2.remove(newtCanvasAWT);
                            frame.add((Component)newtCanvasAWT, "Center");
                            frame.validate();
                            frame2.validate();
                        }
                    });
                }
            }
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
                frame2.dispose();
            }
        });
        gLWindow.destroy();
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull((Object)gLEventListener);
        Assert.assertNotNull((Object)gLWindow);
        Window window = gLWindow.getDelegatedWindow();
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", window)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestParenting01cAWT.atoi(stringArray[++i]);
        }
        String string = TestParenting01cAWT.class.getName();
        JUnitTestRunner.main((String[])new String[]{string, "filtertrace=true", "haltOnError=false", "haltOnFailure=false", "showoutput=true", "outputtoformatters=true", "logfailedtests=true", "logtestlistenerevents=true", "formatter=org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter", "formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter,TEST-" + string + ".xml"});
    }

    static {
        durationPerTest = 800L;
    }
}

