/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestWindowClosingProtocol01AWT
extends UITestCase {
    @Test
    public void testCloseFrameGLCanvas() throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame("testCloseFrameGLCanvas AWT");
        AWTRobotUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(frame);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        gLCanvas.addGLEventListener(new GearsES2());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.add(gLCanvas);
                frame.pack();
                frame.setSize(512, 512);
                frame.validate();
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(frame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        WindowClosingProtocol.WindowClosingMode windowClosingMode = gLCanvas.getDefaultCloseOperation();
        Assert.assertEquals((Object)((Object)WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE), (Object)((Object)windowClosingMode));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.closeWindow(frame, false, windowClosingListener));
        Thread.sleep(100L);
        Assert.assertEquals((Object)true, (Object)frame.isDisplayable());
        Assert.assertEquals((Object)true, (Object)frame.isVisible());
        Assert.assertEquals((Object)true, (Object)gLCanvas.isValid());
        Assert.assertEquals((Object)true, (Object)gLCanvas.isDisplayable());
        Assert.assertEquals((Object)true, (Object)windowClosingListener.isWindowClosing());
        Assert.assertEquals((Object)false, (Object)windowClosingListener.isWindowClosed());
        gLCanvas.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE);
        windowClosingMode = gLCanvas.getDefaultCloseOperation();
        Assert.assertEquals((Object)((Object)WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE), (Object)((Object)windowClosingMode));
        Thread.sleep(300L);
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.closeWindow(frame, false, windowClosingListener));
        Thread.sleep(100L);
        Assert.assertEquals((Object)true, (Object)frame.isDisplayable());
        Assert.assertEquals((Object)true, (Object)frame.isVisible());
        Assert.assertEquals((Object)true, (Object)windowClosingListener.isWindowClosing());
        Assert.assertEquals((Object)false, (Object)windowClosingListener.isWindowClosed());
        for (int i = 0; i < 20 && gLCanvas.isRealized(); ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)false, (Object)gLCanvas.isRealized());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
    }

    @Test
    public void testCloseJFrameGLCanvas() throws InterruptedException, InvocationTargetException {
        final JFrame jFrame = new JFrame("testCloseJFrameGLCanvas AWT");
        AWTRobotUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(jFrame);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        gLCanvas.addGLEventListener(new GearsES2());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.getContentPane().add(gLCanvas);
                jFrame.pack();
                jFrame.setSize(512, 512);
                jFrame.validate();
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        Assert.assertEquals((long)1L, (long)jFrame.getDefaultCloseOperation());
        WindowClosingProtocol.WindowClosingMode windowClosingMode = gLCanvas.getDefaultCloseOperation();
        Assert.assertEquals((Object)((Object)WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE), (Object)((Object)windowClosingMode));
        Thread.sleep(300L);
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.closeWindow(jFrame, false, windowClosingListener));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, false));
        Assert.assertEquals((Object)true, (Object)jFrame.isDisplayable());
        Assert.assertEquals((Object)false, (Object)jFrame.isVisible());
        Assert.assertEquals((Object)true, (Object)gLCanvas.isValid());
        Assert.assertEquals((Object)true, (Object)gLCanvas.isDisplayable());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        Assert.assertEquals((Object)true, (Object)jFrame.isDisplayable());
        Assert.assertEquals((Object)true, (Object)jFrame.isVisible());
        jFrame.setDefaultCloseOperation(2);
        Assert.assertEquals((long)2L, (long)jFrame.getDefaultCloseOperation());
        windowClosingMode = gLCanvas.getDefaultCloseOperation();
        Assert.assertEquals((Object)((Object)WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE), (Object)((Object)windowClosingMode));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.closeWindow(jFrame, true, windowClosingListener));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, false));
        Assert.assertEquals((Object)false, (Object)jFrame.isDisplayable());
        Assert.assertEquals((Object)false, (Object)gLCanvas.isValid());
        Assert.assertEquals((Object)false, (Object)gLCanvas.isDisplayable());
        Assert.assertEquals((Object)false, (Object)gLCanvas.isRealized());
    }

    public static void main(String[] stringArray) {
        String string = TestWindowClosingProtocol01AWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

