/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.spi.JPEGImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestJPEGImage01NEWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 100L;
    static String _fname = null;

    public void testImpl(InputStream inputStream) throws InterruptedException, IOException {
        JPEGImage jPEGImage = JPEGImage.read(inputStream);
        Assert.assertNotNull((Object)jPEGImage);
        boolean bl = 4 == jPEGImage.getBytesPerPixel();
        System.err.println("JPEGImage: " + jPEGImage + ", hasAlpha " + bl);
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (bl) {
            gLCapabilities.setAlphaBits(1);
        }
        int n = gLProfile.isGL2ES3() ? (bl ? 32856 : 32849) : (bl ? 6408 : 6407);
        TextureData textureData = new TextureData(gLProfile, n, jPEGImage.getWidth(), jPEGImage.getHeight(), 0, new GLPixelBuffer.GLPixelAttributes(jPEGImage.getGLFormat(), jPEGImage.getGLType()), false, false, false, jPEGImage.getData(), null);
        System.err.println("TextureData: " + textureData);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle("TestJPEGImage01NEWT");
        gLWindow.setSize(textureData.getWidth(), textureData.getHeight());
        final TextureDraw01ES2Listener textureDraw01ES2Listener = new TextureDraw01ES2Listener(textureData, 0);
        gLWindow.addGLEventListener(textureDraw01ES2Listener);
        gLWindow.addGLEventListener(new GLEventListener(){
            boolean shot = false;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != ((TextureDraw01Accessor)((Object)textureDraw01ES2Listener)).getTexture() && !this.shot) {
                    this.shot = true;
                    TestJPEGImage01NEWT.this.snapshot(0, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.setVisible(true);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void testReadES2_RGBn() throws InterruptedException, IOException, MalformedURLException {
        String string = null == _fname ? "test-ntscN_3-01-160x90-90pct-yuv444-base.jpg" : _fname;
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), string);
        this.testImpl(uRLConnection.getInputStream());
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (!stringArray[i].equals("-file")) continue;
            _fname = stringArray[++i];
        }
        JUnitCore.main((String[])new String[]{TestJPEGImage01NEWT.class.getName()});
    }
}

