/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.caps;

import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTranslucencyNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getGL2ES2();
        Assert.assertNotNull((Object)glp);
        width = 512;
        height = 512;
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities, boolean bl) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Gears NEWT Test (translucent " + !gLCapabilities.isBackgroundOpaque() + ")");
        gLWindow.setUndecorated(bl);
        gLWindow.addGLEventListener(new GearsES2());
        Animator animator = new Animator(gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        final GLWindow gLWindow2 = gLWindow;
        gLWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'f') {
                    new Thread(){

                        @Override
                        public void run() {
                            gLWindow2.setFullscreen(!gLWindow2.isFullscreen());
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'd') {
                    new Thread(){

                        @Override
                        public void run() {
                            gLWindow2.setUndecorated(!gLWindow2.isUndecorated());
                        }
                    }.start();
                }
            }
        });
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test01OpaqueDecorated() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setBackgroundOpaque(true);
        this.runTestGL(gLCapabilities, false);
    }

    @Test
    public void test01TransparentDecorated() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setBackgroundOpaque(false);
        this.runTestGL(gLCapabilities, false);
    }

    @Test
    public void test01TransparentUndecorated() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setBackgroundOpaque(false);
        this.runTestGL(gLCapabilities, true);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            bl = true;
        }
        if (bl) {
            UITestCase.waitForKey("main");
        }
        JUnitCore.main((String[])new String[]{TestTranslucencyNEWT.class.getName()});
    }

    static {
        duration = 500L;
    }
}

