/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.AnimatorBase;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug816OSXCALayerPos01AWT
extends UITestCase {
    static long duration = 1600L;
    static final int width = 640;
    static final int height = 480;
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static int swapInterval = 1;
    static Dimension rwsize = new Dimension(800, 600);
    static int testNum = -1;

    static void setComponentSize(final Frame frame, final Component component, final Dimension dimension, final Component component2, final Dimension dimension2) {
        try {
            AWTEDTExecutor.singleton.invoke(true, new Runnable(){

                @Override
                public void run() {
                    component.setMinimumSize(dimension);
                    component.setPreferredSize(dimension);
                    component.setSize(dimension);
                    if (null != component2) {
                        component2.setMinimumSize(dimension2);
                        component2.setPreferredSize(dimension2);
                        component2.setSize(dimension2);
                    }
                    if (null != frame) {
                        frame.pack();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    static void setFrameSize(final Frame frame, final boolean bl, final Dimension dimension) {
        try {
            AWTEDTExecutor.singleton.invoke(true, new Runnable(){

                @Override
                public void run() {
                    frame.setSize(dimension);
                    if (bl) {
                        frame.validate();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    protected void runTestGL(GLCapabilities gLCapabilities, FrameLayout frameLayout, final boolean bl, final boolean bl2) throws InterruptedException, InvocationTargetException {
        long l;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        GLCanvas gLCanvas;
        final JFrame jFrame = new JFrame("Bug816: " + this.getTestMethodName());
        Assert.assertNotNull((Object)jFrame);
        Container container = jFrame.getContentPane();
        final GLCanvas gLCanvas2 = new GLCanvas(gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas2);
        if (bl) {
            gLCanvas = new GLCanvas(gLCapabilities);
            Assert.assertNotNull((Object)gLCanvas);
        } else {
            gLCanvas = null;
        }
        Dimension dimension = new Dimension(320, 480);
        final Dimension dimension2 = new Dimension(bl ? 704 : 384, 544);
        TestBug816OSXCALayerPos01AWT.setComponentSize(null, gLCanvas2, dimension, gLCanvas, dimension);
        switch (frameLayout) {
            case None: {
                container.add(gLCanvas2);
                break;
            }
            case Flow: {
                object5 = new Container();
                ((Container)object5).setLayout(new FlowLayout(0, 0, 0));
                ((Container)object5).add(gLCanvas2);
                if (bl) {
                    ((Container)object5).add(gLCanvas);
                }
                container.add((Component)object5);
                break;
            }
            case DoubleBorderCenterSurrounded: {
                object5 = new Container();
                ((Container)object5).setLayout(new BorderLayout());
                ((Container)object5).add((Component)new Button("north"), "North");
                ((Container)object5).add((Component)new Button("south"), "South");
                ((Container)object5).add((Component)new Button("east"), "East");
                ((Container)object5).add((Component)new Button("west"), "West");
                if (bl) {
                    object4 = new Container();
                    ((Container)object4).setLayout(new GridLayout(1, 2));
                    ((Container)object4).add(gLCanvas2);
                    ((Container)object4).add(gLCanvas);
                    ((Container)object5).add((Component)object4, "Center");
                } else {
                    ((Container)object5).add((Component)gLCanvas2, "Center");
                }
                container.setLayout(new BorderLayout());
                container.add((Component)new Button("NORTH"), "North");
                container.add((Component)new Button("SOUTH"), "South");
                container.add((Component)new Button("EAST"), "East");
                container.add((Component)new Button("WEST"), "West");
                container.add((Component)object5, "Center");
                break;
            }
            case Box: {
                object5 = new Container();
                ((Container)object5).setLayout(new BoxLayout((Container)object5, 0));
                ((Container)object5).add(gLCanvas2);
                if (bl) {
                    ((Container)object5).add(gLCanvas);
                }
                container.add((Component)object5);
                break;
            }
            case Split: {
                object5 = new Dimension(16, 16);
                object4 = new JScrollPane(22, 31);
                object3 = ((JScrollPane)object4).getVerticalScrollBar();
                ((JComponent)object3).setPreferredSize((Dimension)object5);
                object2 = ((JScrollBar)object3).getModel();
                object2.setMinimum(0);
                object2.setMaximum(100);
                object2.setValue(50);
                object2.setExtent(1);
                ((JScrollBar)object3).setEnabled(true);
                object3 = new JScrollPane(21, 32);
                object2 = ((JScrollPane)object3).getHorizontalScrollBar();
                ((JComponent)object2).setPreferredSize((Dimension)object5);
                object = ((JScrollBar)object2).getModel();
                object.setMinimum(0);
                object.setMaximum(100);
                object.setValue(50);
                object.setExtent(1);
                ((JScrollBar)object2).setEnabled(true);
                object2 = new JSplitPane(1, true, (Component)(bl ? gLCanvas : object4), gLCanvas2);
                ((JSplitPane)object2).setResizeWeight(0.5);
                object = new JSplitPane(0, true, (Component)object2, (Component)object3);
                ((JSplitPane)object).setResizeWeight(0.5);
                container.add((Component)object);
            }
        }
        object5 = new GearsES2(swapInterval);
        gLCanvas2.addGLEventListener((GLEventListener)object5);
        if (bl) {
            object4 = new RedSquareES2(swapInterval);
            gLCanvas.addGLEventListener((GLEventListener)object4);
        }
        object4 = new Animator();
        ((AnimatorBase)object4).add(gLCanvas2);
        if (bl) {
            ((AnimatorBase)object4).add(gLCanvas);
        }
        object3 = new QuitAdapter();
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter((WindowListener)object3), (NativeSurfaceHolder)gLCanvas2).addTo(jFrame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (bl2) {
                    jFrame.pack();
                } else {
                    TestBug816OSXCALayerPos01AWT.setFrameSize(jFrame, true, dimension2);
                }
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas2, true));
        if (bl) {
            Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        }
        ((Animator)object4).start();
        Assert.assertTrue((boolean)((AnimatorBase)object4).isStarted());
        Assert.assertTrue((boolean)((Animator)object4).isAnimating());
        System.err.println("canvas1 pos/siz: " + gLCanvas2.getX() + "/" + gLCanvas2.getY() + " " + gLCanvas2.getSurfaceWidth() + "x" + gLCanvas2.getSurfaceHeight());
        if (bl) {
            System.err.println("canvas2 pos/siz: " + gLCanvas.getX() + "/" + gLCanvas.getY() + " " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight());
        }
        Thread.sleep(Math.max(1000L, duration / 2L));
        if (null != rwsize) {
            object2 = new Dimension(TestBug816OSXCALayerPos01AWT.rwsize.width / 2, TestBug816OSXCALayerPos01AWT.rwsize.height);
            object = new Dimension(bl ? TestBug816OSXCALayerPos01AWT.rwsize.width + 64 : TestBug816OSXCALayerPos01AWT.rwsize.width / 2 + 64, TestBug816OSXCALayerPos01AWT.rwsize.height + 64);
            if (bl2) {
                TestBug816OSXCALayerPos01AWT.setComponentSize(jFrame, gLCanvas2, (Dimension)object2, gLCanvas, (Dimension)object2);
            } else {
                TestBug816OSXCALayerPos01AWT.setFrameSize(jFrame, true, (Dimension)object);
            }
            System.err.println("resize canvas1 pos/siz: " + gLCanvas2.getX() + "/" + gLCanvas2.getY() + " " + gLCanvas2.getSurfaceWidth() + "x" + gLCanvas2.getSurfaceHeight());
            if (bl) {
                System.err.println("resize canvas2 pos/siz: " + gLCanvas.getX() + "/" + gLCanvas.getY() + " " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight());
            }
        }
        long l2 = l = System.currentTimeMillis();
        while (!((QuitAdapter)object3).shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull((Object)jFrame);
        Assert.assertNotNull((Object)gLCanvas2);
        if (bl) {
            Assert.assertNotNull((Object)gLCanvas);
        } else {
            Assert.assertNull((Object)gLCanvas);
        }
        Assert.assertNotNull((Object)object4);
        ((Animator)object4).stop();
        Assert.assertFalse((boolean)((Animator)object4).isAnimating());
        Assert.assertFalse((boolean)((AnimatorBase)object4).isStarted());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)jFrame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.remove(gLCanvas2);
                if (bl) {
                    jFrame.remove(gLCanvas);
                }
                jFrame.dispose();
            }
        });
    }

    static GLProfile getGLP() {
        return GLProfile.getMaxProgrammableCore(true);
    }

    @Test
    public void test00_Compo_None_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 0) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.None, false, true);
    }

    @Test
    public void test01_Compo_Flow_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 1) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Flow, false, true);
    }

    @Test
    public void test02_Compo_DblBrd_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 2) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.DoubleBorderCenterSurrounded, false, true);
    }

    @Test
    public void test03_Compo_Box_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 3) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Box, false, true);
    }

    @Test
    public void test04_Compo_Split_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 4) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Split, false, true);
    }

    @Test
    public void test05_Compo_Flow_Two() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 5) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Flow, true, true);
    }

    @Test
    public void test06_Compo_DblBrd_Two() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 6) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.DoubleBorderCenterSurrounded, true, true);
    }

    @Test
    public void test07_Compo_Box_Two() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 7) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Box, true, true);
    }

    @Test
    public void test08_Compo_Split_Two() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 8) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Split, true, true);
    }

    @Test
    public void test10_Frame_None_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 10) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.None, false, false);
    }

    @Test
    public void test11_Frame_Flow_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 11) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Flow, false, false);
    }

    @Test
    public void test12_Frame_DblBrd_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 12) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.DoubleBorderCenterSurrounded, false, false);
    }

    @Test
    public void test13_Frame_Box_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 13) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Box, false, false);
    }

    @Test
    public void test14_Frame_Split_One() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 14) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Split, false, false);
    }

    @Test
    public void test15_Frame_Flow_Two() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 15) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Flow, true, false);
    }

    @Test
    public void test16_Frame_DblBrd_Two() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 16) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.DoubleBorderCenterSurrounded, true, false);
    }

    @Test
    public void test17_Frame_Box_Two() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 17) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Box, true, false);
    }

    @Test
    public void test18_Frame_Split_Two() throws InterruptedException, InvocationTargetException {
        if (testNum != -1 && testNum != 18) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos01AWT.getGLP());
        this.runTestGL(gLCapabilities, FrameLayout.Split, true, false);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-test")) {
                testNum = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-noresize")) {
                rwsize = null;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (!stringArray[i].equals("-vsync")) continue;
            swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
        }
        System.err.println("resize " + rwsize);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("swapInterval " + swapInterval);
        JUnitCore.main((String[])new String[]{TestBug816OSXCALayerPos01AWT.class.getName()});
    }

    public static enum FrameLayout {
        None,
        Flow,
        DoubleBorderCenterSurrounded,
        Box,
        Split;

    }
}

