/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.graph.demos.MSAATool;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.PMVMatrix;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class GPURendererListenerBase01
implements GLEventListener {
    private final RegionRenderer renderer;
    private final int renderModes;
    private final boolean debug;
    private final boolean trace;
    protected GLRegion region;
    private final GLReadBufferUtil screenshot;
    private KeyAction keyAction;
    private volatile GLAutoDrawable autoDrawable = null;
    private final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    protected final float zNear = 0.1f;
    protected final float zFar = 7000.0f;
    protected final AABBox nearPlane1Box;
    private float xTran = -10.0f;
    private float yTran = 10.0f;
    private float ang = 0.0f;
    private float zTran = -70.0f;
    private final int[] sampleCount = new int[]{4};
    protected volatile float weight = 1.0f;
    boolean ignoreInput = false;
    int screenshot_num = 0;

    public GPURendererListenerBase01(RegionRenderer regionRenderer, int n, boolean bl, boolean bl2) {
        this.renderer = regionRenderer;
        this.renderModes = n;
        this.debug = bl;
        this.trace = bl2;
        this.screenshot = new GLReadBufferUtil(false, false);
        this.nearPlane1Box = new AABBox();
    }

    public final RegionRenderer getRenderer() {
        return this.renderer;
    }

    public final int getRenderModes() {
        return this.renderModes;
    }

    public final float getZTran() {
        return this.zTran;
    }

    public final float getXTran() {
        return this.xTran;
    }

    public final float getYTran() {
        return this.yTran;
    }

    public final float getAngle() {
        return this.ang;
    }

    public final int[] getSampleCount() {
        return this.sampleCount;
    }

    public final float[] getPosition() {
        return this.position;
    }

    public void setMatrix(float f, float f2, float f3, float f4, int n) {
        this.xTran = f;
        this.yTran = f2;
        this.zTran = f3;
        this.ang = f4;
        this.sampleCount[0] = n;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Debug", null, gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Trace", null, gL2ES2, new Object[]{System.err})).getGL2ES2();
        }
        System.err.println("*** " + gL2ES2.getContext().getGLVersion());
        System.err.println("*** GLDebugMessage " + gL2ES2.getContext().isGLDebugMessageEnabled());
        MSAATool.dump(gLAutoDrawable);
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.getRenderer().init(gL2ES2, this.renderModes);
    }

    public static void mapWin2ObjectCoords(PMVMatrix pMVMatrix, int[] nArray, float f, float f2, float f3, float f4, float f5, float[] fArray, float[] fArray2) {
        fArray[0] = (1.0f / f - 1.0f / f5) / (1.0f / f - 1.0f / f2);
        pMVMatrix.gluUnProject(f3, f4, fArray[0], nArray, 0, fArray2, 0);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        PMVMatrix pMVMatrix = this.renderer.getMatrix();
        this.renderer.reshapePerspective(45.0f, n3, n4, 0.1f, 7000.0f);
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        System.err.printf("Reshape: zNear %f,  zFar %f%n", Float.valueOf(0.1f), Float.valueOf(7000.0f));
        System.err.printf("Reshape: Frustum: %s%n", pMVMatrix.glGetFrustum());
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[1];
        int[] nArray = new int[]{0, 0, n3, n4};
        GPURendererListenerBase01.mapWin2ObjectCoords(pMVMatrix, nArray, 0.1f, 7000.0f, 0.0f, 0.0f, 1.0f, fArray3, fArray);
        System.err.printf("Reshape: mapped.00: [%f, %f, %f], winZ %f -> [%f, %f, %f]%n", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(fArray3[0]), Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]));
        GPURendererListenerBase01.mapWin2ObjectCoords(pMVMatrix, nArray, 0.1f, 7000.0f, n3, n4, 1.0f, fArray3, fArray2);
        System.err.printf("Reshape: mapped.11: [%f, %f, %f], winZ %f -> [%f, %f, %f]%n", Float.valueOf(n3), Float.valueOf(n4), Float.valueOf(1.0f), Float.valueOf(fArray3[0]), Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), Float.valueOf(fArray2[2]));
        this.nearPlane1Box.setSize(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2]);
        System.err.printf("Reshape: dist1Box: %s%n", this.nearPlane1Box);
        this.dumpMatrix();
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = null;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.region) {
            this.region.destroy(gL2ES2);
        }
        this.screenshot.dispose(gL2ES2);
        this.renderer.destroy(gL2ES2);
    }

    public void zoom(int n) {
        this.zTran += (float)n;
        this.dumpMatrix();
    }

    public void move(float f, float f2) {
        this.xTran += f;
        this.yTran += f2;
        this.dumpMatrix();
    }

    public void rotate(float f) {
        this.ang += f;
        this.ang %= 360.0f;
        this.dumpMatrix();
    }

    public void editGlobalWeight(float f) {
        if (!RenderState.isWeightValid(this.weight + f)) {
            return;
        }
        this.weight += f;
        System.err.println("Global Weight: " + this.weight);
    }

    void dumpMatrix() {
        System.err.println("Matrix: " + this.xTran + " / " + this.yTran + " / " + this.zTran + " @ " + this.ang);
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener(this.keyAction);
        }
    }

    public void detachInputListenerFrom(GLWindow gLWindow) {
        if (null == this.keyAction) {
            return;
        }
        gLWindow.removeKeyListener(this.keyAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, String string3, boolean bl) throws GLException, IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.printf("-%03dx%03d-Z%04d-S%02d-%s", gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), (int)Math.abs(this.zTran), this.sampleCount[0], string3);
        String string4 = string + string2 + stringWriter + ".png";
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string4));
        }
    }

    public void setIgnoreInput(boolean bl) {
        this.ignoreInput = bl;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public class KeyAction
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (GPURendererListenerBase01.this.ignoreInput) {
                return;
            }
            if (keyEvent.getKeyCode() == 49) {
                GPURendererListenerBase01.this.zoom(10);
            } else if (keyEvent.getKeyCode() == 50) {
                GPURendererListenerBase01.this.zoom(-10);
            } else if (keyEvent.getKeyCode() == 150) {
                GPURendererListenerBase01.this.move(0.0f, -1.0f);
            } else if (keyEvent.getKeyCode() == 152) {
                GPURendererListenerBase01.this.move(0.0f, 1.0f);
            } else if (keyEvent.getKeyCode() == 149) {
                GPURendererListenerBase01.this.move(-1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 151) {
                GPURendererListenerBase01.this.move(1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 54) {
                int[] nArray = GPURendererListenerBase01.this.sampleCount;
                nArray[0] = nArray[0] - 1;
                System.err.println("Sample Count: " + GPURendererListenerBase01.this.sampleCount[0]);
            } else if (keyEvent.getKeyCode() == 55) {
                int[] nArray = GPURendererListenerBase01.this.sampleCount;
                nArray[0] = nArray[0] + 1;
                System.err.println("Sample Count: " + GPURendererListenerBase01.this.sampleCount[0]);
            } else if (keyEvent.getKeyCode() == 48) {
                GPURendererListenerBase01.this.rotate(1.0f);
            } else if (keyEvent.getKeyCode() == 57) {
                GPURendererListenerBase01.this.rotate(-1.0f);
            } else if (keyEvent.getKeyCode() == 81) {
                GPURendererListenerBase01.this.editGlobalWeight(-0.1f);
            } else if (keyEvent.getKeyCode() == 87) {
                GPURendererListenerBase01.this.editGlobalWeight(0.1f);
            } else if (keyEvent.getKeyCode() == 86) {
                if (null != GPURendererListenerBase01.this.autoDrawable) {
                    GPURendererListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        @Override
                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            GL gL = gLAutoDrawable.getGL();
                            int n = gL.getSwapInterval();
                            n = n == 0 ? 1 : 0;
                            gL.setSwapInterval(n);
                            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                            if (null != gLAnimatorControl) {
                                gLAnimatorControl.resetFPSCounter();
                            }
                            if (gLAutoDrawable instanceof FPSCounter) {
                                ((FPSCounter)((Object)gLAutoDrawable)).resetFPSCounter();
                            }
                            System.err.println("Swap Interval: " + n);
                            return true;
                        }
                    });
                }
            } else if (keyEvent.getKeyCode() == 83) {
                GPURendererListenerBase01.this.rotate(-1.0f);
                if (null != GPURendererListenerBase01.this.autoDrawable) {
                    GPURendererListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        @Override
                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            try {
                                String string = Region.getRenderModeString(GPURendererListenerBase01.this.renderModes);
                                String string2 = string + (Region.hasVariableWeight(GPURendererListenerBase01.this.renderModes) ? "-vc" : "-uc");
                                GPURendererListenerBase01.this.printScreen(gLAutoDrawable, "./", "demo-" + string2, "snap" + GPURendererListenerBase01.this.screenshot_num, false);
                                ++GPURendererListenerBase01.this.screenshot_num;
                            }
                            catch (GLException gLException) {
                                gLException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            return true;
                        }
                    });
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

