/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.bugs;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;

public abstract class Issue344Base
implements GLEventListener {
    GLU glu = new GLU();
    TextRenderer renderer;
    float textScaleFactor;
    Font font = new Font("default", 0, 200);
    boolean useMipMaps = true;

    protected Issue344Base() {
    }

    protected abstract String getText();

    protected void run(String[] stringArray) {
        final Frame frame = new Frame(this.getClass().getName());
        frame.setLayout(new BorderLayout());
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.addGLEventListener(this);
        frame.add((Component)gLCanvas, "Center");
        frame.setSize(512, 512);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                }).start();
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glEnable(2929);
        this.renderer = new TextRenderer(this.font, this.useMipMaps);
        Rectangle2D rectangle2D = this.renderer.getBounds(this.getText());
        float f = (float)rectangle2D.getWidth();
        this.textScaleFactor = 2.0f / (f * 1.1f);
        gL2.setSwapInterval(0);
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16640);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        this.glu.gluLookAt(0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.renderer.begin3DRendering();
        Rectangle2D rectangle2D = this.renderer.getBounds(this.getText());
        float f = (float)rectangle2D.getWidth();
        float f2 = (float)rectangle2D.getHeight();
        this.renderer.draw3D(this.getText(), f / -2.0f * this.textScaleFactor, f2 / -2.0f * this.textScaleFactor, 3.0f, this.textScaleFactor);
        this.renderer.end3DRendering();
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluPerspective(15.0f, (float)n3 / (float)n4, 5.0f, 15.0f);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }
}

