/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLSampler;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.test.util.MiscUtils;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLPlatformFilters;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class HighLevelBindingTest
extends UITestCase {
    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("OS: " + System.getProperty("os.name"));
        System.out.println("ARCH: " + System.getProperty("os.arch"));
        System.out.println("VM: " + System.getProperty("java.vm.name"));
        System.out.println("lib path: " + System.getProperty("java.library.path"));
    }

    @Test
    public void enumsTest() {
        EnumSet<CLDevice.FPConfig> enumSet = CLDevice.FPConfig.valuesOf(17);
        Assert.assertEquals((long)0L, (long)CLDevice.FPConfig.valuesOf(0).size());
        Assert.assertTrue((boolean)enumSet.contains((Object)CLDevice.FPConfig.DENORM));
        Assert.assertTrue((boolean)enumSet.contains((Object)CLDevice.FPConfig.ROUND_TO_INF));
        for (CLDevice.FPConfig enum_ : CLDevice.FPConfig.values()) {
            EnumSet<CLDevice.FPConfig> enumSet2 = CLDevice.FPConfig.valuesOf(enum_.CONFIG);
            Assert.assertTrue((boolean)enumSet2.contains((Object)enum_));
        }
        for (Enum enum_ : CLDevice.GlobalMemCacheType.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLDevice.GlobalMemCacheType.valueOf(((CLDevice.GlobalMemCacheType)enum_).TYPE)));
        }
        for (Enum enum_ : CLDevice.LocalMemType.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLDevice.LocalMemType.valueOf(((CLDevice.LocalMemType)enum_).TYPE)));
        }
        for (Enum enum_ : CLDevice.Type.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLDevice.Type.valueOf(((CLDevice.Type)enum_).TYPE)));
        }
        for (Enum enum_ : CLDevice.Capabilities.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLDevice.Capabilities.valueOf(((CLDevice.Capabilities)enum_).CAPS)));
        }
        for (Enum enum_ : CLMemory.Mem.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLMemory.Mem.valueOf(((CLMemory.Mem)enum_).CONFIG)));
        }
        for (Enum enum_ : CLMemory.GLObjectType.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLMemory.GLObjectType.valueOf(((CLMemory.GLObjectType)enum_).TYPE)));
        }
        for (Enum enum_ : CLSampler.AddressingMode.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLSampler.AddressingMode.valueOf(((CLSampler.AddressingMode)enum_).MODE)));
        }
        for (Enum enum_ : CLSampler.FilteringMode.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLSampler.FilteringMode.valueOf(((CLSampler.FilteringMode)enum_).MODE)));
        }
        for (Enum enum_ : CLImageFormat.ChannelOrder.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLImageFormat.ChannelOrder.valueOf(((CLImageFormat.ChannelOrder)enum_).ORDER)));
        }
        for (Enum enum_ : CLImageFormat.ChannelType.values()) {
            Assert.assertEquals((Object)enum_, (Object)((Object)CLImageFormat.ChannelType.valueOf(((CLImageFormat.ChannelType)enum_).TYPE)));
        }
    }

    @Test
    public void contextlessTest() {
        CLPlatform[] cLPlatformArray;
        System.out.println(" - - - highLevelTest; contextless - - - ");
        for (CLPlatform cLPlatform : cLPlatformArray = CLPlatform.listCLPlatforms()) {
            CLDevice[] cLDeviceArray;
            System.out.println("platform info:");
            System.out.println("    name: " + cLPlatform.getName());
            System.out.println("    id: " + cLPlatform.ID);
            System.out.println("    profile: " + cLPlatform.getProfile());
            System.out.println("    spec version: " + cLPlatform.getSpecVersion());
            System.out.println("    impl version: " + cLPlatform.getVersion().getImplVersion());
            System.out.println("    vendor: " + cLPlatform.getVendor());
            System.out.println("    max FLOPS device: " + cLPlatform.getMaxFlopsDevice());
            System.out.println("    extensions: " + cLPlatform.getExtensions());
            for (CLDevice cLDevice : cLDeviceArray = cLPlatform.listCLDevices()) {
                System.out.println("device info:");
                System.out.println("    name: " + cLDevice.getName());
                System.out.println("    profile: " + cLDevice.getProfile());
                System.out.println("    vendor: " + cLDevice.getVendor());
                System.out.println("    vendor id: " + cLDevice.getVendorID());
                System.out.println("    version: " + cLDevice.getVersion());
                System.out.println("    driver version: " + cLDevice.getDriverVersion());
                System.out.println("    type: " + (Object)((Object)cLDevice.getType()));
                System.out.println("    mem base addr align: " + cLDevice.getMemBaseAddrAlign());
                System.out.println("    global mem: " + cLDevice.getGlobalMemSize() / 0x100000L + " MB");
                System.out.println("    max alloc mem: " + cLDevice.getMaxMemAllocSize() / 0x100000L + " MB");
                System.out.println("    max param size: " + cLDevice.getMaxParameterSize() + " byte");
                System.out.println("    local mem: " + cLDevice.getLocalMemSize() / 1024L + " KB");
                System.out.println("    local mem type: " + (Object)((Object)cLDevice.getLocalMemType()));
                System.out.println("    global mem cache size: " + cLDevice.getGlobalMemCacheSize());
                System.out.println("    global mem cacheline size: " + cLDevice.getGlobalMemCachelineSize());
                System.out.println("    global mem cache type: " + (Object)((Object)cLDevice.getGlobalMemCacheType()));
                System.out.println("    constant buffer size: " + cLDevice.getMaxConstantBufferSize());
                System.out.println("    error correction support: " + cLDevice.isErrorCorrectionSupported());
                System.out.println("    queue properties: " + cLDevice.getQueueProperties());
                System.out.println("    clock: " + cLDevice.getMaxClockFrequency() + " MHz");
                System.out.println("    timer res: " + cLDevice.getProfilingTimerResolution() + " ns");
                System.out.println("    max work group size: " + cLDevice.getMaxWorkGroupSize());
                System.out.println("    max compute units: " + cLDevice.getMaxComputeUnits());
                System.out.println("    max work item dimensions: " + cLDevice.getMaxWorkItemDimensions());
                System.out.println("    max work item sizes: " + Arrays.toString(cLDevice.getMaxWorkItemSizes()));
                System.out.println("    compiler available: " + cLDevice.isCompilerAvailable());
                System.out.println("    image support: " + cLDevice.isImageSupportAvailable());
                System.out.println("    max read image args: " + cLDevice.getMaxReadImageArgs());
                System.out.println("    max write image args: " + cLDevice.getMaxWriteImageArgs());
                System.out.println("    max image2d dimensions: " + Arrays.asList(cLDevice.getMaxImage2dWidth(), cLDevice.getMaxImage2dHeight()));
                System.out.println("    max image3d dimensions: " + Arrays.asList(cLDevice.getMaxImage2dWidth(), cLDevice.getMaxImage2dHeight(), cLDevice.getMaxImage3dDepth()));
                System.out.println("    number of address bits: " + cLDevice.getAddressBits());
                System.out.println("    half FP available: " + cLDevice.isHalfFPAvailable());
                System.out.println("    double FP available: " + cLDevice.isDoubleFPAvailable());
                System.out.println("    little endian: " + cLDevice.isLittleEndian());
                System.out.println("    half FP config: " + cLDevice.getHalfFPConfig());
                System.out.println("    single FP config: " + cLDevice.getSingleFPConfig());
                System.out.println("    double FP config: " + cLDevice.getDoubleFPConfig());
                System.out.println("    execution capabilities: " + cLDevice.getExecutionCapabilities());
                System.out.println("    gl memory sharing: " + cLDevice.isGLMemorySharingSupported());
                System.out.println("    extensions: " + cLDevice.getExtensions());
            }
        }
    }

    @Test
    public void platformTest() {
        CLPlatform cLPlatform = CLPlatform.getDefault(CLPlatformFilters.version(CLVersion.CL_1_0), CLPlatformFilters.type(CLDevice.Type.GPU));
        CLPlatform cLPlatform2 = CLPlatform.getDefault(CLPlatformFilters.version(CLVersion.CL_1_0), CLPlatformFilters.type(CLDevice.Type.CPU));
        if (cLPlatform != null) {
            Assert.assertTrue((cLPlatform.listCLDevices(CLDevice.Type.GPU).length > 0 ? 1 : 0) != 0);
        } else if (cLPlatform2 != null) {
            Assert.assertTrue((cLPlatform2.listCLDevices(CLDevice.Type.CPU).length > 0 ? 1 : 0) != 0);
        } else {
            Assert.fail((String)"please tell us about your hardware");
        }
    }

    @Test
    public void createContextTest() {
        System.out.println(" - - - highLevelTest; create context - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault();
        CLDevice[] cLDeviceArray = cLPlatform.listCLDevices();
        int n = cLDeviceArray.length;
        CLContext cLContext = CLContext.create();
        Assert.assertNotNull((Object)cLContext);
        Assert.assertEquals((long)n, (long)cLContext.getDevices().length);
        cLContext.release();
        cLContext = CLContext.create(cLPlatform);
        Assert.assertNotNull((Object)cLContext);
        Assert.assertEquals((long)n, (long)cLContext.getDevices().length);
        cLContext.release();
        for (CLDevice cLDevice : cLDeviceArray) {
            cLContext = CLContext.create(cLDevice);
            Assert.assertNotNull((Object)cLContext);
            Assert.assertEquals((long)1L, (long)cLContext.getDevices().length);
            cLContext.release();
        }
        cLContext = CLContext.create(CLDevice.Type.ALL);
        Assert.assertNotNull((Object)cLContext);
        Assert.assertEquals((long)n, (long)cLContext.getDevices().length);
        cLContext.release();
        cLContext = CLContext.create(cLPlatform, CLDevice.Type.ALL);
        Assert.assertNotNull((Object)cLContext);
        Assert.assertEquals((long)n, (long)cLContext.getDevices().length);
        cLContext.release();
        try {
            CLContext.create(new CLDevice[]{null});
            Assert.fail((String)"create with null device");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CLContext.create(new CLDevice.Type[]{null});
            Assert.fail((String)"create with null CLDevice.Type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CLContext.create((CLPlatform)null, new CLDevice.Type[]{null});
            Assert.fail((String)"create with null CLDevice.Type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void vectorAddGMTest() throws IOException {
        CLDevice cLDevice2;
        System.out.println(" - - - highLevelTest; global memory kernel - - - ");
        CLPlatform[] cLPlatformArray = CLPlatform.listCLPlatforms();
        CLContext cLContext = CLContext.create(cLPlatformArray[0]);
        CLDevice[] cLDeviceArray = cLContext.getDevices();
        System.out.println("context devices:");
        for (CLDevice cLDevice2 : cLDeviceArray) {
            System.out.println("   " + cLDevice2.toString());
        }
        System.out.println("max FLOPS device: " + cLContext.getMaxFlopsDevice());
        InputStream inputStream = this.getClass().getResourceAsStream("testkernels.cl");
        CLProgram cLProgram = cLContext.createProgram(inputStream).build();
        CLDevice[] cLDeviceArray2 = cLProgram.getCLDevices();
        cLDevice2 = cLDeviceArray2[0];
        Assert.assertEquals((long)cLDeviceArray.length, (long)cLDeviceArray2.length);
        System.out.println("build log:\n" + cLProgram.getBuildLog());
        System.out.println("build status:\n" + cLProgram.getBuildStatus());
        String string = cLProgram.getSource();
        Assert.assertFalse((boolean)string.trim().isEmpty());
        Map<CLDevice, byte[]> map = cLProgram.getBinaries();
        Assert.assertFalse((boolean)map.isEmpty());
        int n = 11444777;
        int n2 = cLDevice2.getMaxWorkItemSizes()[0];
        int n3 = 0;
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        ByteBuffer byteBuffer3 = null;
        boolean bl = false;
        int n4 = 1;
        while (!bl) {
            try {
                n3 = MiscUtils.roundUp(n2, n);
                System.out.println("allocating three buffers of size: " + n3);
                byteBuffer = Buffers.newDirectByteBuffer(n3 * 4);
                byteBuffer2 = Buffers.newDirectByteBuffer(n3 * 4);
                byteBuffer3 = Buffers.newDirectByteBuffer(n3 * 4);
                bl = true;
            }
            catch (OutOfMemoryError cLBuffer) {
                n /= ++n4;
                System.out.println("not enough direct buffer memory; retrying with smaller buffers");
            }
        }
        MiscUtils.fillBuffer(byteBuffer, 23456);
        MiscUtils.fillBuffer(byteBuffer2, 46987);
        CLBuffer<Object> cLBuffer = cLContext.createBuffer(byteBuffer, CLMemory.Mem.READ_ONLY);
        CLBuffer<ByteBuffer> cLBuffer2 = cLContext.createBuffer(byteBuffer2, CLMemory.Mem.READ_ONLY);
        CLBuffer<ByteBuffer> cLBuffer3 = cLContext.createBuffer(byteBuffer3, CLMemory.Mem.WRITE_ONLY);
        CLKernel cLKernel = cLProgram.createCLKernel("VectorAddGM");
        cLKernel.setArg(0, cLBuffer).setArg(1, cLBuffer2).setArg(2, cLBuffer3).setArg(3, n);
        CLCommandQueue cLCommandQueue = cLDevice2.createCommandQueue();
        cLCommandQueue.putWriteBuffer(cLBuffer, false).putWriteBuffer(cLBuffer2, false).put1DRangeKernel(cLKernel, 0L, n3, n2).putReadBuffer(cLBuffer3, true).finish().release();
        System.out.println("a+b=c result snapshot: ");
        for (int i = 0; i < 10; ++i) {
            System.out.print(byteBuffer3.getInt() + ", ");
        }
        System.out.println("...; " + byteBuffer3.remaining() / 4 + " more");
        Assert.assertTrue((3 == cLContext.getMemoryObjects().size() ? 1 : 0) != 0);
        cLBuffer.release();
        Assert.assertTrue((2 == cLContext.getMemoryObjects().size() ? 1 : 0) != 0);
        Assert.assertTrue((2 == cLContext.getMemoryObjects().size() ? 1 : 0) != 0);
        cLBuffer2.release();
        Assert.assertTrue((1 == cLContext.getMemoryObjects().size() ? 1 : 0) != 0);
        Assert.assertTrue((1 == cLContext.getMemoryObjects().size() ? 1 : 0) != 0);
        cLBuffer3.release();
        Assert.assertTrue((0 == cLContext.getMemoryObjects().size() ? 1 : 0) != 0);
        Assert.assertTrue((1 == cLContext.getPrograms().size() ? 1 : 0) != 0);
        cLProgram.release();
        Assert.assertTrue((0 == cLContext.getPrograms().size() ? 1 : 0) != 0);
        cLContext.release();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = HighLevelBindingTest.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

