/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.GLPixelBuffer;
import java.nio.Buffer;

public class TextureData {
    protected int width;
    protected int height;
    private int border;
    protected GLPixelBuffer.GLPixelAttributes pixelAttributes;
    protected int internalFormat;
    protected boolean mipmap;
    private boolean dataIsCompressed;
    protected boolean mustFlipVertically;
    protected Buffer buffer;
    private Buffer[] mipmapData;
    private Flusher flusher;
    protected int rowLength;
    protected int alignment;
    protected int estimatedMemorySize;
    protected boolean haveEXTABGR;
    protected boolean haveGL12;
    protected GLProfile glProfile;
    protected ColorSpace pixelCS = ColorSpace.RGB;

    public TextureData(GLProfile gLProfile, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, Buffer buffer, Flusher flusher) throws IllegalArgumentException {
        this(gLProfile, n, n2, n3, n4, new GLPixelBuffer.GLPixelAttributes(n5, n6), bl, bl2, bl3, buffer, flusher);
    }

    public TextureData(GLProfile gLProfile, int n, int n2, int n3, int n4, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, boolean bl, boolean bl2, boolean bl3, Buffer buffer, Flusher flusher) throws IllegalArgumentException {
        if (bl && bl2) {
            throw new IllegalArgumentException("Can not generate mipmaps for compressed textures");
        }
        this.glProfile = gLProfile;
        this.width = n2;
        this.height = n3;
        this.border = n4;
        this.pixelAttributes = gLPixelAttributes;
        this.internalFormat = n;
        this.mipmap = bl;
        this.dataIsCompressed = bl2;
        this.mustFlipVertically = bl3;
        this.buffer = buffer;
        this.flusher = flusher;
        this.alignment = 1;
        this.estimatedMemorySize = TextureData.estimatedMemorySize(buffer);
    }

    public TextureData(GLProfile gLProfile, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, Buffer[] bufferArray, Flusher flusher) throws IllegalArgumentException {
        this(gLProfile, n, n2, n3, n4, new GLPixelBuffer.GLPixelAttributes(n5, n6), bl, bl2, bufferArray, flusher);
    }

    public TextureData(GLProfile gLProfile, int n, int n2, int n3, int n4, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, boolean bl, boolean bl2, Buffer[] bufferArray, Flusher flusher) throws IllegalArgumentException {
        this.glProfile = gLProfile;
        this.width = n2;
        this.height = n3;
        this.border = n4;
        this.pixelAttributes = gLPixelAttributes;
        this.internalFormat = n;
        this.dataIsCompressed = bl;
        this.mustFlipVertically = bl2;
        this.mipmapData = (Buffer[])bufferArray.clone();
        this.flusher = flusher;
        this.alignment = 1;
        for (int i = 0; i < bufferArray.length; ++i) {
            this.estimatedMemorySize += TextureData.estimatedMemorySize(bufferArray[i]);
        }
    }

    public ColorSpace getColorSpace() {
        return this.pixelCS;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        this.pixelCS = colorSpace;
    }

    protected TextureData(GLProfile gLProfile) {
        this.glProfile = gLProfile;
        this.pixelAttributes = GLPixelBuffer.GLPixelAttributes.UNDEF;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBorder() {
        return this.border;
    }

    public GLPixelBuffer.GLPixelAttributes getPixelAttributes() {
        return this.pixelAttributes;
    }

    public int getPixelFormat() {
        return this.pixelAttributes.format;
    }

    public int getPixelType() {
        return this.pixelAttributes.type;
    }

    public int getInternalFormat() {
        return this.internalFormat;
    }

    public boolean getMipmap() {
        return this.mipmap;
    }

    public boolean isDataCompressed() {
        return this.dataIsCompressed;
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Buffer[] getMipmapData() {
        return this.mipmapData;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setPixelAttributes(GLPixelBuffer.GLPixelAttributes gLPixelAttributes) {
        this.pixelAttributes = gLPixelAttributes;
    }

    public void setPixelFormat(int n) {
        if (this.pixelAttributes.format != n) {
            this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(n, this.pixelAttributes.type);
        }
    }

    public void setPixelType(int n) {
        if (this.pixelAttributes.type != n) {
            this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(this.pixelAttributes.format, n);
        }
    }

    public void setInternalFormat(int n) {
        this.internalFormat = n;
    }

    public void setMipmap(boolean bl) {
        this.mipmap = bl;
    }

    public void setIsDataCompressed(boolean bl) {
        this.dataIsCompressed = bl;
    }

    public void setMustFlipVertically(boolean bl) {
        this.mustFlipVertically = bl;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
        this.estimatedMemorySize = TextureData.estimatedMemorySize(buffer);
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setRowLength(int n) {
        this.rowLength = n;
    }

    public void setHaveEXTABGR(boolean bl) {
        this.haveEXTABGR = bl;
    }

    public void setHaveGL12(boolean bl) {
        this.haveGL12 = bl;
    }

    public GLProfile getGLProfile() {
        return this.glProfile;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public void flush() {
        if (this.flusher != null) {
            this.flusher.flush();
            this.flusher = null;
        }
    }

    public void destroy() {
        this.flush();
    }

    public String toString() {
        return "TextureData[" + this.width + "x" + this.height + ", y-flip " + this.mustFlipVertically + ", internFormat 0x" + Integer.toHexString(this.internalFormat) + ", " + this.pixelAttributes + ", border " + this.border + ", estSize " + this.estimatedMemorySize + ", alignment " + this.alignment + ", rowlen " + this.rowLength;
    }

    protected static int estimatedMemorySize(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        return buffer.capacity() * Buffers.sizeOfBufferElem(buffer);
    }

    public static interface Flusher {
        public void flush();
    }

    public static enum ColorSpace {
        RGB,
        YCbCr,
        YCCK,
        CMYK;

    }
}

