/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParenting01dAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() throws InterruptedException {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @Test
    public void test01GLWindowReparentRecreateNoPreserve() throws InterruptedException, InvocationTargetException {
        this.testGLWindowInvisibleReparentRecreateImpl(false);
    }

    @Test
    public void test02GLWindowReparentRecreateGLPreserve() throws InterruptedException, InvocationTargetException {
        this.testGLWindowInvisibleReparentRecreateImpl(true);
    }

    private void testGLWindowInvisibleReparentRecreateImpl(boolean bl) throws InterruptedException, InvocationTargetException {
        long l;
        GLWindow gLWindow = GLWindow.create(glCaps);
        Assert.assertNotNull((Object)gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertNull((Object)gLWindow.getParent());
        gLWindow.setTitle("testWindowParenting01CreateVisibleDestroy");
        MyGLEventListenerCounter myGLEventListenerCounter = new MyGLEventListenerCounter();
        gLWindow.addGLEventListener(myGLEventListenerCounter);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        gLWindow.addGLEventListener(redSquareES2);
        Assert.assertEquals((String)("Init Counter Invalid " + myGLEventListenerCounter), (long)0L, (long)myGLEventListenerCounter.initCount);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        Assert.assertNotNull((Object)newtCanvasAWT);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertNull((Object)gLWindow.getParent());
        Assert.assertEquals((String)("Init Counter Invalid " + myGLEventListenerCounter), (long)0L, (long)myGLEventListenerCounter.initCount);
        final Frame frame = new Frame("AWT Parent Frame");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Button("North"), "North");
        frame.add((Component)new Button("South"), "South");
        frame.add((Component)new Button("East"), "East");
        frame.add((Component)new Button("West"), "West");
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)new Button("north"), "North");
        container.add((Component)new Button("south"), "South");
        container.add((Component)new Button("east"), "East");
        container.add((Component)new Button("west"), "West");
        container.add((Component)newtCanvasAWT, "Center");
        frame.add((Component)container, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)newtCanvasAWT.getNativeWindow(), (Object)gLWindow.getParent());
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, true));
        gLWindow.display();
        Assert.assertEquals((String)("Init Counter Invalid " + myGLEventListenerCounter), (long)1L, (long)myGLEventListenerCounter.initCount);
        Assert.assertEquals((String)("Dispose Counter Invalid " + myGLEventListenerCounter), (long)0L, (long)myGLEventListenerCounter.disposeCount);
        int n = 1 | (bl ? 2 : 0);
        System.err.println(this.getSimpleTestName(".") + ": Start Reparent #1");
        Window.ReparentOperation reparentOperation = gLWindow.reparentWindow(null, -1, -1, n);
        System.err.println(this.getSimpleTestName(".") + ": Result Reparent #1: " + (Object)((Object)reparentOperation));
        Assert.assertEquals((Object)((Object)Window.ReparentOperation.ACTION_NATIVE_CREATION), (Object)((Object)reparentOperation));
        gLWindow.display();
        Assert.assertEquals((String)("Init Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter), (long)1L, (long)myGLEventListenerCounter.initCount);
        Assert.assertEquals((String)("Dispose Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter), (long)0L, (long)myGLEventListenerCounter.disposeCount);
        gLWindow.setVisible(false);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, false));
        System.err.println(this.getSimpleTestName(".") + ": Start Reparent #2");
        Window.ReparentOperation reparentOperation2 = gLWindow.reparentWindow(newtCanvasAWT.getNativeWindow(), -1, -1, n);
        System.err.println(this.getSimpleTestName(".") + ": Result Reparent #2: " + (Object)((Object)reparentOperation2));
        Assert.assertEquals((Object)((Object)Window.ReparentOperation.ACTION_NATIVE_CREATION), (Object)((Object)reparentOperation2));
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, true));
        gLWindow.display();
        if (bl) {
            Assert.assertEquals((String)("Init Counter Invalid (Preserve Failed 2) " + myGLEventListenerCounter), (long)1L, (long)myGLEventListenerCounter.initCount);
            Assert.assertEquals((String)("Dispose Counter Invalid (Preserve Failed 2) " + myGLEventListenerCounter), (long)0L, (long)myGLEventListenerCounter.disposeCount);
        } else {
            Assert.assertEquals((String)("Init Counter Invalid (Preserve Failed 2) " + myGLEventListenerCounter), (long)2L, (long)myGLEventListenerCounter.initCount);
            Assert.assertEquals((String)("Dispose Counter Invalid (Preserve Failed 2) " + myGLEventListenerCounter), (long)1L, (long)myGLEventListenerCounter.disposeCount);
        }
        long l2 = l = System.currentTimeMillis();
        while (l2 - l < durationPerTest) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        boolean bl2 = gLWindow.getChosenCapabilities().isOnscreen();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(newtCanvasAWT);
            }
        });
        if (bl2) {
            Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        if (bl2) {
            Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        }
        gLWindow.destroy();
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        if (bl) {
            Assert.assertEquals((String)("Init Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter), (long)1L, (long)myGLEventListenerCounter.initCount);
            Assert.assertEquals((String)("Dispose Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter), (long)1L, (long)myGLEventListenerCounter.disposeCount);
        } else {
            Assert.assertEquals((String)("Init Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter), (long)2L, (long)myGLEventListenerCounter.initCount);
            Assert.assertEquals((String)("Dispose Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter), (long)2L, (long)myGLEventListenerCounter.disposeCount);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
        }
        String string = TestParenting01dAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 800L;
    }

    static class MyGLEventListenerCounter
    extends GLEventListenerCounter {
        MyGLEventListenerCounter() {
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
            System.err.println("MyGLEventListenerCounter.init: " + this);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            super.dispose(gLAutoDrawable);
            System.err.println("MyGLEventListenerCounter.dispose: " + this);
        }
    }
}

