/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.EDTUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestDisplayLifecycle01NEWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
        caps = new GLCapabilities(glp);
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, int n, int n2) throws InterruptedException {
        GLWindow gLWindow;
        Object object;
        Assert.assertNotNull((Object)gLCapabilities);
        if (null != screen) {
            object = NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)object);
            gLWindow = GLWindow.create((Window)object);
        } else {
            gLWindow = GLWindow.create(gLCapabilities);
        }
        gLWindow.setUpdateFPSFrames(1, null);
        object = new GearsES2();
        TestDisplayLifecycle01NEWT.setDemoFields((GLEventListener)object, gLWindow);
        gLWindow.addGLEventListener((GLEventListener)object);
        gLWindow.addWindowListener(new TraceWindowAdapter());
        gLWindow.setSize(n, n2);
        return gLWindow;
    }

    private void testDisplayCreate01(Display display, Screen screen) throws InterruptedException {
        Assert.assertEquals((long)0L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)0L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertNotNull((Object)display.getEDTUtil());
        Assert.assertEquals((Object)false, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)0L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        GLWindow gLWindow = TestDisplayLifecycle01NEWT.createWindow(screen, caps, width, height);
        Assert.assertEquals((Object)screen, (Object)gLWindow.getScreen());
        Assert.assertEquals((long)0L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)0L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)0L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertNotNull((Object)gLWindow.getScreen());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((long)0L, (long)gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)screen, (Object)gLWindow.getScreen());
        Assert.assertEquals((long)1L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)1L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)1L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        System.err.println("Frames for setVisible(true) 1: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue((0 < gLWindow.getTotalFPSFrames() ? 1 : 0) != 0);
        while (gLWindow.getTotalFPSDuration() < 1L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.setVisible(false);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        gLWindow.resetFPSCounter();
        Assert.assertEquals((long)0L, (long)gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        System.err.println("Frames for setVisible(true) 1: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue((0 < gLWindow.getTotalFPSFrames() ? 1 : 0) != 0);
        while (gLWindow.getTotalFPSDuration() < 2L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.destroy();
        Assert.assertEquals((Object)screen, (Object)gLWindow.getScreen());
        Assert.assertEquals((long)0L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)0L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertNotNull((Object)display.getEDTUtil());
        Assert.assertEquals((Object)false, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)0L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        gLWindow.resetFPSCounter();
        Assert.assertEquals((long)0L, (long)gLWindow.getTotalFPSFrames());
        gLWindow.display();
        Assert.assertEquals((long)0L, (long)gLWindow.getTotalFPSFrames());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)screen, (Object)gLWindow.getScreen());
        Assert.assertEquals((long)1L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)1L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)1L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        System.err.println("Frames for setVisible(true) 2: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue((0 < gLWindow.getTotalFPSFrames() ? 1 : 0) != 0);
        while (gLWindow.getTotalFPSDuration() < 1L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.destroy();
        Display.dumpDisplayList("Post destroy(true)");
        Assert.assertEquals((long)0L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)0L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        EDTUtil eDTUtil = display.getEDTUtil();
        Assert.assertNotNull((Object)eDTUtil);
        Assert.assertEquals((Object)false, (Object)eDTUtil.isRunning());
        eDTUtil.start();
        Assert.assertEquals((Object)true, (Object)eDTUtil.isRunning());
        eDTUtil.invoke(true, null);
        Assert.assertEquals((Object)true, (Object)eDTUtil.isRunning());
        eDTUtil.invokeStop(true, null);
        eDTUtil.waitUntilStopped();
        Assert.assertEquals((Object)false, (Object)eDTUtil.isRunning());
        Assert.assertEquals((long)0L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertNotNull((Object)gLWindow.getScreen());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
    }

    @Test
    public void testDisplayCreate01_AutoDestroyLifecycle() throws InterruptedException {
        Assert.assertEquals((long)0L, (long)Display.getActiveDisplayNumber());
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen(display, 0);
        this.testDisplayCreate01(display, screen);
        this.testDisplayCreate01(display, screen);
        Assert.assertEquals((long)0L, (long)Display.getActiveDisplayNumber());
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow) {
        Assert.assertNotNull((Object)gLEventListener);
        Assert.assertNotNull((Object)gLWindow);
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", gLWindow)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestDisplayLifecycle01NEWT.atoi(stringArray[++i]);
        }
        System.err.println("durationPerTest: " + durationPerTest);
        String string = TestDisplayLifecycle01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 100L;
    }
}

