/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.math;

import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.geom.Frustum;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.PMVMatrix;
import java.nio.FloatBuffer;
import jogamp.common.os.PlatformPropsImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPMVMatrix01NEWT
extends UITestCase {
    static final float epsilon = 1.0E-5f;
    static FloatBuffer matrix2x3R = FloatBuffer.wrap(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f});
    static FloatBuffer matrix2x3C = FloatBuffer.wrap(new float[]{1.0f, 4.0f, 2.0f, 5.0f, 3.0f, 6.0f});
    static FloatBuffer matrix3x2R = FloatBuffer.wrap(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f});
    static FloatBuffer matrix3x2C = FloatBuffer.wrap(new float[]{1.0f, 3.0f, 5.0f, 2.0f, 4.0f, 6.0f});
    static FloatBuffer translated123R = FloatBuffer.wrap(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 2.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    static FloatBuffer translated123C = FloatBuffer.wrap(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 2.0f, 3.0f, 1.0f});
    static FloatBuffer translated123I = FloatBuffer.wrap(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, -2.0f, -3.0f, 1.0f});
    static FloatBuffer translated123IT = FloatBuffer.wrap(new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, -2.0f, 0.0f, 0.0f, 1.0f, -3.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    static DrawableContext dc;

    @Test
    public void test00MatrixToString() {
        String string = PMVMatrix.matrixToString(null, "%10.5f", translated123C).toString();
        String string2 = FloatUtil.matrixToString(null, null, "%10.5f", translated123C, 0, 4, 4, false).toString();
        String string3 = FloatUtil.matrixToString(null, null, "%10.5f", translated123R, 0, 4, 4, true).toString();
        System.err.println("PMV-C-O 4x4: ");
        System.err.println(string);
        System.err.println();
        System.err.println("FLU-C-O 4x4: ");
        System.err.println(string2);
        System.err.println();
        System.err.println("FLU-R-O 4x4: ");
        System.err.println(string3);
        System.err.println();
        Assert.assertEquals((Object)string, (Object)string2);
        Assert.assertEquals((Object)string2, (Object)string3);
        String string4 = FloatUtil.matrixToString(null, null, "%10.5f", matrix2x3R, 0, 2, 3, true).toString();
        String string5 = FloatUtil.matrixToString(null, null, "%10.5f", matrix2x3C, 0, 2, 3, false).toString();
        System.err.println("FLU-R-O 2x3: ");
        System.err.println(string4);
        System.err.println();
        System.err.println("FLU-C-O 2x3: ");
        System.err.println(string5);
        System.err.println();
        Assert.assertEquals((Object)string5, (Object)string4);
        String string6 = FloatUtil.matrixToString(null, null, "%10.5f", matrix3x2R, 0, 3, 2, true).toString();
        String string7 = FloatUtil.matrixToString(null, null, "%10.5f", matrix3x2C, 0, 3, 2, false).toString();
        System.err.println("FLU-R-O 3x2: ");
        System.err.println(string6);
        System.err.println();
        System.err.println("FLU-C-O 3x2: ");
        System.err.println(string7);
        System.err.println();
        Assert.assertEquals((Object)string7, (Object)string6);
    }

    @Test
    public void test01MviUpdateTraditionalAccess() {
        PMVMatrix pMVMatrix = new PMVMatrix();
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits not zero, " + pMVMatrix.toString()), (long)0L, (long)pMVMatrix.getRequestMask());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        FloatBuffer floatBuffer = pMVMatrix.glGetPMatrixf();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits not zero, " + pMVMatrix.toString()), (long)0L, (long)pMVMatrix.getRequestMask());
        pMVMatrix.glTranslatef(1.0f, 2.0f, 3.0f);
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits not zero, " + pMVMatrix.toString()), (long)0L, (long)pMVMatrix.getRequestMask());
        boolean bl = pMVMatrix.update();
        Assert.assertEquals((String)"Update has been perfomed, but non requested", (Object)false, (Object)bl);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits not zero, " + pMVMatrix.toString()), (long)0L, (long)pMVMatrix.getRequestMask());
        FloatBuffer floatBuffer2 = pMVMatrix.glGetPMatrixf();
        MiscUtils.assertFloatBufferEquals("P not identity, " + pMVMatrix.toString(), floatBuffer, floatBuffer2, 1.0E-5f);
        FloatBuffer floatBuffer3 = pMVMatrix.glGetMvMatrixf();
        MiscUtils.assertFloatBufferEquals("Mv not translated123, " + pMVMatrix.toString(), translated123C, floatBuffer3, 1.0E-5f);
        FloatBuffer floatBuffer4 = pMVMatrix.glGetMviMatrixf();
        MiscUtils.assertFloatBufferEquals("Mvi not translated123, " + pMVMatrix.toString(), translated123I, floatBuffer4, 1.0E-5f);
        Assert.assertEquals((String)("Request bit Mvi not set, " + pMVMatrix.toString()), (long)1L, (long)pMVMatrix.getRequestMask());
        Assert.assertEquals((String)("Remaining dirty bits not Mvit|Frustum, " + pMVMatrix.toString()), (long)6L, (long)pMVMatrix.getDirtyBits());
        Frustum frustum = pMVMatrix.glGetFrustum();
        Assert.assertNotNull((String)("Frustum is null" + pMVMatrix.toString()), (Object)frustum);
        Assert.assertEquals((String)("Remaining dirty bits not Mvit, " + pMVMatrix.toString()), (long)2L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits Mvi|Frustum not set, " + pMVMatrix.toString()), (long)5L, (long)pMVMatrix.getRequestMask());
        FloatBuffer floatBuffer5 = pMVMatrix.glGetMvitMatrixf();
        MiscUtils.assertFloatBufferEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, floatBuffer5, 1.0E-5f);
        Assert.assertTrue((String)("Dirty bits not clean, " + pMVMatrix.toString()), (0 == pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Request bits Mvi|Mvit|Frustum not set, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getRequestMask());
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits Mvi|Mvit|Frustum not set, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getRequestMask());
        MiscUtils.assertFloatBufferEquals("P not identity, " + pMVMatrix.toString(), floatBuffer, floatBuffer2, 1.0E-5f);
        MiscUtils.assertFloatBufferEquals("Mv not identity, " + pMVMatrix.toString(), floatBuffer, floatBuffer3, 1.0E-5f);
        MiscUtils.assertFloatBufferNotEqual("Mvi already identity w/o update, " + pMVMatrix.toString(), floatBuffer, floatBuffer4, 1.0E-5f);
        MiscUtils.assertFloatBufferNotEqual("Mvit already identity w/o update, " + pMVMatrix.toString(), floatBuffer, floatBuffer5, 1.0E-5f);
        MiscUtils.assertFloatBufferEquals("Mvi not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, floatBuffer4, 1.0E-5f);
        MiscUtils.assertFloatBufferEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, floatBuffer5, 1.0E-5f);
        Assert.assertNotNull((String)("Frustum is null" + pMVMatrix.toString()), (Object)frustum);
        bl = pMVMatrix.update();
        Assert.assertEquals((String)"Update has not been perfomed, but requested", (Object)true, (Object)bl);
        Assert.assertTrue((String)("Dirty bits not clean, " + pMVMatrix.toString()), (0 == pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Request bits Mvi|Mvit|Frustum not set, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getRequestMask());
        MiscUtils.assertFloatBufferEquals("Mvi not identity after update, " + pMVMatrix.toString(), floatBuffer, floatBuffer4, 1.0E-5f);
        MiscUtils.assertFloatBufferEquals("Mvit not identity after update, " + pMVMatrix.toString(), floatBuffer, floatBuffer5, 1.0E-5f);
        Assert.assertNotNull((String)("Frustum is null" + pMVMatrix.toString()), (Object)frustum);
    }

    @Test
    public void test02MviUpdateShaderAccess() {
        PMVMatrix pMVMatrix = new PMVMatrix();
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits not zero, " + pMVMatrix.toString()), (long)0L, (long)pMVMatrix.getRequestMask());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        FloatBuffer floatBuffer = pMVMatrix.glGetPMatrixf();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits not zero, " + pMVMatrix.toString()), (long)0L, (long)pMVMatrix.getRequestMask());
        FloatBuffer floatBuffer2 = pMVMatrix.glGetPMatrixf();
        MiscUtils.assertFloatBufferEquals("P not identity, " + pMVMatrix.toString(), floatBuffer, floatBuffer2, 1.0E-5f);
        FloatBuffer floatBuffer3 = pMVMatrix.glGetMvMatrixf();
        MiscUtils.assertFloatBufferEquals("Mv not identity, " + pMVMatrix.toString(), floatBuffer, floatBuffer3, 1.0E-5f);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Request bits not zero, " + pMVMatrix.toString()), (long)0L, (long)pMVMatrix.getRequestMask());
        FloatBuffer floatBuffer4 = pMVMatrix.glGetMviMatrixf();
        MiscUtils.assertFloatBufferEquals("Mvi not identity, " + pMVMatrix.toString(), floatBuffer, floatBuffer4, 1.0E-5f);
        Assert.assertEquals((String)("Remaining dirty bits not Mvit|Frustum, " + pMVMatrix.toString()), (long)6L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bit Mvi not set, " + pMVMatrix.toString()), (long)1L, (long)pMVMatrix.getRequestMask());
        FloatBuffer floatBuffer5 = pMVMatrix.glGetMvitMatrixf();
        MiscUtils.assertFloatBufferEquals("Mvi not identity, " + pMVMatrix.toString(), floatBuffer, floatBuffer5, 1.0E-5f);
        Assert.assertEquals((String)("Remaining dirty bits not Frustum, " + pMVMatrix.toString()), (long)4L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)("Request bits Mvi and Mvit not set, " + pMVMatrix.toString()), (long)3L, (long)pMVMatrix.getRequestMask());
        Frustum frustum = pMVMatrix.glGetFrustum();
        Assert.assertNotNull((String)("Frustum is null" + pMVMatrix.toString()), (Object)frustum);
        Assert.assertTrue((String)("Dirty bits not clean, " + pMVMatrix.toString()), (0 == pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Request bits Mvi|Mvit|Frustum not set, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getRequestMask());
        pMVMatrix.glTranslatef(1.0f, 2.0f, 3.0f);
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getDirtyBits());
        MiscUtils.assertFloatBufferEquals("P not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), floatBuffer, floatBuffer2, 1.0E-5f);
        MiscUtils.assertFloatBufferEquals("Mv not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123C, floatBuffer3, 1.0E-5f);
        MiscUtils.assertFloatBufferNotEqual("Mvi already translated123 w/o update, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, floatBuffer4, 1.0E-5f);
        MiscUtils.assertFloatBufferNotEqual("Mvit already translated123 w/o update, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, floatBuffer5, 1.0E-5f);
        MiscUtils.assertFloatBufferEquals("Mvi not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), floatBuffer, floatBuffer4, 1.0E-5f);
        MiscUtils.assertFloatBufferEquals("Mvit not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), floatBuffer, floatBuffer5, 1.0E-5f);
        Assert.assertNotNull((String)("Frustum is null" + pMVMatrix.toString()), (Object)frustum);
        boolean bl = pMVMatrix.update();
        Assert.assertEquals((String)"Update has not been perfomed, but requested", (Object)true, (Object)bl);
        Assert.assertTrue((String)("Dirty bits not clean, " + pMVMatrix.toString()), (0 == pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Request bits Mvi|Mvit|Frustum not set, " + pMVMatrix.toString()), (long)7L, (long)pMVMatrix.getRequestMask());
        MiscUtils.assertFloatBufferEquals("Mvi not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, floatBuffer4, 1.0E-5f);
        MiscUtils.assertFloatBufferEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, floatBuffer5, 1.0E-5f);
    }

    @Test
    public void test03MvTranslate() {
        Object object = new PMVMatrix();
        ((PMVMatrix)object).glMatrixMode(5889);
        ((PMVMatrix)object).glLoadIdentity();
        ((PMVMatrix)object).glMatrixMode(5888);
        ((PMVMatrix)object).glLoadIdentity();
        ((PMVMatrix)object).glTranslatef(5.0f, 6.0f, 7.0f);
        FloatBuffer floatBuffer = ((PMVMatrix)object).glGetMvMatrixf();
        object = FloatBuffer.allocate(16);
        GL2ES1 gL2ES1 = TestPMVMatrix01NEWT.dc.glc.getGL().getGL2ES1();
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(5.0f, 6.0f, 7.0f);
        gL2ES1.glGetFloatv(2982, (FloatBuffer)object);
        MiscUtils.assertFloatBufferEquals("Arrays not equal, expected" + PlatformPropsImpl.NEWLINE + PMVMatrix.matrixToString(null, "%10.5f", (FloatBuffer)object).toString() + ", actual" + PlatformPropsImpl.NEWLINE + PMVMatrix.matrixToString(null, "%10.5f", floatBuffer).toString(), (FloatBuffer)object, floatBuffer, 1.0E-5f);
    }

    @Test
    public void test04MvTranslateRotate() {
        Object object = new PMVMatrix();
        ((PMVMatrix)object).glMatrixMode(5889);
        ((PMVMatrix)object).glLoadIdentity();
        ((PMVMatrix)object).glMatrixMode(5888);
        ((PMVMatrix)object).glLoadIdentity();
        ((PMVMatrix)object).glTranslatef(5.0f, 6.0f, 7.0f);
        ((PMVMatrix)object).glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        FloatBuffer floatBuffer = ((PMVMatrix)object).glGetMvMatrixf();
        object = FloatBuffer.allocate(16);
        GL2ES1 gL2ES1 = TestPMVMatrix01NEWT.dc.glc.getGL().getGL2ES1();
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(5.0f, 6.0f, 7.0f);
        gL2ES1.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        gL2ES1.glGetFloatv(2982, (FloatBuffer)object);
        MiscUtils.assertFloatBufferEquals("Arrays not equal, expected" + PlatformPropsImpl.NEWLINE + PMVMatrix.matrixToString(null, "%10.5f", (FloatBuffer)object).toString() + ", actual" + PlatformPropsImpl.NEWLINE + PMVMatrix.matrixToString(null, "%10.5f", floatBuffer).toString(), (FloatBuffer)object, floatBuffer, 1.0E-5f);
    }

    @BeforeClass
    public static void setup() throws Throwable {
        try {
            dc = TestPMVMatrix01NEWT.createOffscreenDrawableAndCurrentFFPContext();
        }
        catch (Throwable throwable) {
            TestPMVMatrix01NEWT.setTestSupported(false);
            throw throwable;
        }
    }

    @AfterClass
    public static void cleanup() {
        TestPMVMatrix01NEWT.destroyDrawableContext(dc);
    }

    private static DrawableContext createOffscreenDrawableAndCurrentFFPContext() throws Throwable {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLProfile);
        GLDrawable gLDrawable = gLDrawableFactory.createOffscreenDrawable(null, gLCapabilities, null, 64, 64);
        gLDrawable.setRealized(true);
        GLContext gLContext = null;
        try {
            gLContext = gLDrawable.createContext(null);
            Assert.assertTrue((String)"Context could not be made current", (0 < gLContext.makeCurrent() ? 1 : 0) != 0);
            return new DrawableContext(gLDrawable, gLContext);
        }
        catch (Throwable throwable) {
            if (null != gLContext) {
                gLContext.destroy();
            }
            gLDrawable.setRealized(false);
            throw throwable;
        }
    }

    private static void destroyDrawableContext(DrawableContext drawableContext) {
        if (null != drawableContext.glc) {
            drawableContext.glc.destroy();
            drawableContext.glc = null;
        }
        if (null != drawableContext.d) {
            drawableContext.d.setRealized(false);
            drawableContext.d = null;
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestPMVMatrix01NEWT.class.getName()});
    }

    static class DrawableContext {
        GLDrawable d;
        GLContext glc;

        DrawableContext(GLDrawable gLDrawable, GLContext gLContext) {
            this.d = gLDrawable;
            this.glc = gLContext;
        }
    }
}

