/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.anim;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.lang.reflect.InvocationTargetException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAnimatorGLWindow01NEWT
extends UITestCase {
    static final int width = 640;
    static final int height = 480;
    static long duration = 1500L;

    protected GLWindow createGLWindow(GLCapabilities gLCapabilities, int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.addGLEventListener(gearsES2);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(640, 480);
        gLWindow.setTitle("GLWindow: " + n + "/" + n2);
        return gLWindow;
    }

    static void pauseAnimator(Animator animator, boolean bl) {
        if (bl) {
            animator.pause();
            Assert.assertEquals((Object)true, (Object)animator.isStarted());
            Assert.assertEquals((Object)true, (Object)animator.isPaused());
            Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        } else {
            animator.resume();
            Assert.assertEquals((Object)true, (Object)animator.isStarted());
            Assert.assertEquals((Object)false, (Object)animator.isPaused());
            Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        }
    }

    static void stopAnimator(Animator animator) {
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
    }

    @Test
    public void test01SyncedOneAnimator() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        Animator animator = new Animator();
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        GearsES2 gearsES2 = new GearsES2(0);
        GLWindow gLWindow = this.createGLWindow(gLCapabilities, 0, 0, gearsES2);
        animator.add(gLWindow);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        GearsES2 gearsES22 = new GearsES2(0);
        GLWindow gLWindow2 = this.createGLWindow(gLCapabilities, gLWindow.getX() + 640, gLWindow.getY() + 0, gearsES22);
        animator.add(gLWindow2);
        GearsES2 gearsES23 = new GearsES2(0);
        GLWindow gLWindow3 = this.createGLWindow(gLCapabilities, gLWindow.getX() + 0, gLWindow.getY() + 480, gearsES23);
        animator.add(gLWindow3);
        gLWindow.setVisible(true);
        gLWindow2.setVisible(true);
        gLWindow3.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow, true));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow2, true));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow3, true));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator, true);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator, false);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.stopAnimator(animator);
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow3, false));
    }

    @Test
    public void test02AsyncEachAnimator() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLWindow gLWindow = this.createGLWindow(gLCapabilities, 0, 0, gearsES2);
        animator.add(gLWindow);
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        gLWindow.setVisible(true);
        Animator animator2 = new Animator();
        GearsES2 gearsES22 = new GearsES2(0);
        GLWindow gLWindow2 = this.createGLWindow(gLCapabilities, gLWindow.getX() + 640, gLWindow.getY() + 0, gearsES22);
        animator2.add(gLWindow2);
        animator2.start();
        Assert.assertEquals((Object)true, (Object)animator2.isStarted());
        Assert.assertEquals((Object)false, (Object)animator2.isPaused());
        Assert.assertEquals((Object)true, (Object)animator2.isAnimating());
        gLWindow2.setVisible(true);
        Animator animator3 = new Animator();
        GearsES2 gearsES23 = new GearsES2(0);
        GLWindow gLWindow3 = this.createGLWindow(gLCapabilities, gLWindow.getX() + 0, gLWindow.getY() + 480, gearsES23);
        animator3.add(gLWindow3);
        animator3.start();
        Assert.assertEquals((Object)true, (Object)animator3.isStarted());
        Assert.assertEquals((Object)false, (Object)animator3.isPaused());
        Assert.assertEquals((Object)true, (Object)animator3.isAnimating());
        gLWindow3.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow, true));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow2, true));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow3, true));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator, true);
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator2, true);
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator3, true);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator, false);
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator2, false);
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator3, false);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.stopAnimator(animator);
        TestAnimatorGLWindow01NEWT.stopAnimator(animator2);
        TestAnimatorGLWindow01NEWT.stopAnimator(animator3);
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow3, false));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestAnimatorGLWindow01NEWT.class.getName()});
    }
}

