/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestShutdownCompleteNEWT
extends UITestCase {
    static long duration = 300L;
    static boolean initOnly = false;
    static boolean waitForEach = false;
    static boolean waitForKey = false;

    protected void runTestGL(boolean bl) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        gLCapabilities.setOnscreen(bl);
        gLCapabilities.setPBuffer(!bl);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Gears NEWT Test");
        gLWindow.addGLEventListener(new GearsES2());
        Animator animator = new Animator(gLWindow);
        gLWindow.setSize(256, 256);
        gLWindow.setVisible(true);
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isRealized());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @AfterClass
    public static void afterAll() {
        if (waitForKey) {
            UITestCase.waitForKey("Exit");
        }
    }

    protected void oneLife(boolean bl) throws InterruptedException {
        if (waitForEach) {
            UITestCase.waitForKey("Start One Life");
        }
        long l = Platform.currentTimeMicros();
        GLProfile.initSingleton();
        long l2 = Platform.currentTimeMicros();
        if (!initOnly) {
            this.runTestGL(true);
        }
        long l3 = Platform.currentTimeMicros();
        if (bl) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, false).toString());
        }
        long l4 = Platform.currentTimeMicros();
        GLProfile.shutdown();
        long l5 = Platform.currentTimeMicros();
        System.err.println("Total:                          " + (double)(l5 - l) / 1000.0 + "ms");
        System.err.println("  GLProfile.initSingleton():    " + (double)(l2 - l) / 1000.0 + "ms");
        System.err.println("  Demo Code:                    " + (double)(l3 - l2) / 1000.0 + "ms");
        System.err.println("  GLInfo:                       " + (double)(l4 - l3) / 1000.0 + "ms");
        System.err.println("  GLProfile.shutdown():         " + (double)(l5 - l4) / 1000.0 + "ms");
    }

    @Test
    public void test01OneLife() throws InterruptedException {
        this.oneLife(false);
    }

    @Test
    public void test02AnotherLifeWithGLInfo() throws InterruptedException {
        this.oneLife(true);
    }

    @Test
    public void test03AnotherLife() throws InterruptedException {
        this.oneLife(true);
    }

    @Test
    public void test03TwoLifes() throws InterruptedException {
        this.oneLife(false);
        this.oneLife(false);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (stringArray[i].equals("-waitForEach")) {
                waitForEach = true;
                waitForKey = true;
                continue;
            }
            if (!stringArray[i].equals("-initOnly")) continue;
            initOnly = true;
        }
        if (waitForKey) {
            UITestCase.waitForKey("Start");
        }
        String string = TestShutdownCompleteNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

