/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.util.List;
import jogamp.opengl.GLAutoDrawableBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2NEWT0
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;
    static long durationPostDestroy;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2NEWT0.setTestSupported(false);
        }
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, GearsES2 gearsES2, GLAutoDrawable gLAutoDrawable) throws InterruptedException {
        boolean bl = null != gLAutoDrawable;
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedAutoDrawable(gLAutoDrawable);
        }
        gLWindow.setSize(width, height);
        gLWindow.addGLEventListener(gearsES2);
        animator.add(gLWindow);
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, true));
        gLWindow.display();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow, true));
        Assert.assertTrue((String)"Gears not initialized", (boolean)gearsES2.waitForInit(true));
        return gLWindow;
    }

    @Test
    public void test01CommonAnimatorSharedCopyBuffer() throws InterruptedException {
        this.testCommonAnimatorSharedImpl(false);
    }

    @Test
    public void test02CommonAnimatorMapBuffer() throws InterruptedException {
        this.testCommonAnimatorSharedImpl(true);
    }

    private void testCommonAnimatorSharedImpl(boolean bl) throws InterruptedException {
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setUseMappedBuffers(bl);
        gearsES2.setValidateBuffers(true);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, gearsES2, null);
        GLContext gLContext = gLWindow.getContext();
        Assert.assertTrue((String)"Ctx is shared before shared creation", (!gLContext.isShared() ? 1 : 0) != 0);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        MiscUtils.dumpSharedGLContext("XXX-C-1.1", gLContext);
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, gearsES22, gLWindow);
        GLContext gLContext2 = gLWindow2.getContext();
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Object object = gLContext.getCreatedShares();
        Object object2 = gLContext2.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-2.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-2.2", gLContext2);
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)1L, (long)object.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)1L, (long)object2.size());
        object = new GearsES2(0);
        ((GearsES2)object).setSharedGears(gearsES2);
        object2 = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), (GearsES2)object, gLWindow);
        GLContext gLContext3 = ((GLAutoDrawableBase)object2).getContext();
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)((GearsES2)object).usesSharedGears());
        animator.start();
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((GLWindow)object2).destroy();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(object2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(object2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)object2, false));
        list = gLContext.getCreatedShares();
        list2 = gLContext2.getCreatedShares();
        list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-D-0.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-D-0.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-D-0.3", gLContext3);
        Assert.assertTrue((String)"Ctx1 is shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)1L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)1L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        try {
            Thread.sleep(durationPostDestroy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        gLWindow2.destroy();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow2, false));
        list = gLContext.getCreatedShares();
        list2 = gLContext2.getCreatedShares();
        list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-D-1.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-D-1.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-D-1.3", gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)0L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)1L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)1L, (long)list3.size());
        try {
            Thread.sleep(durationPostDestroy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        gLWindow.destroy();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLWindow, false));
        list = gLContext.getCreatedShares();
        list2 = gLContext2.getCreatedShares();
        list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-D-2.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-D-2.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-D-2.3", gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (!gLContext.isShared() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Ctx2 is not shared", (!gLContext2.isShared() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Ctx3 is not shared", (!gLContext3.isShared() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)0L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)0L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)0L, (long)list3.size());
        try {
            Thread.sleep(durationPostDestroy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextVBOES2NEWT0.class.getName()});
    }

    static {
        duration = 1000L;
        durationPostDestroy = 1000L;
    }
}

