/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.android;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LauncherUtil {
    public static final String LAUNCH_ACTIVITY_NORMAL = "org.jogamp.launcher.action.LAUNCH_ACTIVITY_NORMAL";
    public static final String LAUNCH_ACTIVITY_TRANSPARENT = "org.jogamp.launcher.action.LAUNCH_ACTIVITY_TRANSPARENT";
    public static final String LAUNCH_MAIN = "org.jogamp.launcher.action.LAUNCH_MAIN";
    public static final String LAUNCH_JUNIT = "org.jogamp.launcher.action.LAUNCH_JUNIT";
    public static final String SCHEME = "launch";
    public static final String HOST = "jogamp.org";
    static final String SYS_PKG = "sys";
    static final String USR_PKG = "pkg";
    static final String ARG = "arg";

    public static final Intent getIntent(String string, DataSet dataSet) {
        dataSet.validate();
        return new Intent(string, dataSet.getUri());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            stringArray = new String[]{"launch://jogamp.org/com.jogamp.TestActivity?sys=jogamp.pack1&sys=javax.pack2&pkg=com.jogamp.pack3&pkg=com.jogamp.pack4&jogamp.common.debug=true&com.jogamp.test=false", "launch://jogamp.org/com.jogamp.TestActivity?sys=jogamp.pack1&jogamp.common.debug=true&com.jogamp.test=false", "launch://jogamp.org/com.jogamp.TestActivity?pkg=jogamp.pack1&jogamp.common.debug=true&com.jogamp.test=false", "launch://jogamp.org/com.jogamp.TestActivity?pkg=jogamp.pack1&pkg=com.jogamp.pack2", "launch://jogamp.org/com.jogamp.TestActivity?pkg=jogamp.pack1&pkg=javax.pack2&pkg=com.jogamp.pack3&jogamp.common.debug=true&com.jogamp.test=false&arg=arg1&arg=arg2=arg2value&arg=arg3", "launch://jogamp.org/com.jogamp.TestActivity?pkg=jogamp.pack1&jogamp.common.debug=true&com.jogamp.test=false&arg=arg1&arg=arg2=arg2value&arg=arg3", "launch://jogamp.org/com.jogamp.TestActivity?pkg=jogamp.pack1&arg=arg1&arg=arg2=arg2value&arg=arg3"};
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Uri uri = Uri.parse((String)string);
            DataSet dataSet = DataSet.create(uri);
            if (null == dataSet) {
                ++n;
                System.err.println("Error: NULL JogAmpLauncherUtil: <" + string + "> -> " + uri + " -> NULL");
                continue;
            }
            Uri uri2 = dataSet.getUri();
            if (!uri.equals((Object)uri2)) {
                ++n;
                System.err.println("Error: Not equal: <" + string + "> -> " + uri + " -> " + uri2);
                continue;
            }
            System.err.println("OK: " + uri2);
        }
        System.err.println("LauncherUtil Self Test: Errors: " + n);
    }

    public static class DataSet {
        static final char SLASH = '/';
        static final char QMARK = '?';
        static final char AMPER = '&';
        static final char ASSIG = '=';
        static final String COLSLASH2 = "://";
        static final String EMPTY = "";
        String activityName = null;
        ArrayList<String> sysPackages = new ArrayList();
        ArrayList<String> usrPackages = new ArrayList();
        OrderedProperties properties = new OrderedProperties();
        ArrayList<String> arguments = new ArrayList();

        public final void setActivityName(String string) {
            this.activityName = string;
        }

        public final String getActivityName() {
            return this.activityName;
        }

        public final void addSysPackage(String string) {
            this.sysPackages.add(string);
        }

        public final void addAllSysPackages(List<String> list) {
            this.sysPackages.addAll(list);
        }

        public final List<String> getSysPackages() {
            return this.sysPackages;
        }

        public final void addUsrPackage(String string) {
            this.usrPackages.add(string);
        }

        public final void addAllUsrPackages(List<String> list) {
            this.usrPackages.addAll(list);
        }

        public final List<String> getUsrPackages() {
            return this.usrPackages;
        }

        public final void setProperty(String string, String string2) {
            this.properties.setProperty(string, string2);
        }

        public final void addAllProperties(OrderedProperties orderedProperties) {
            this.properties.addAll(orderedProperties);
        }

        public final void setSystemProperties() {
            this.properties.setSystemProperties();
        }

        public final void clearSystemProperties() {
            this.properties.clearSystemProperties();
        }

        public final String getProperty(String string) {
            return this.properties.getProperty(string);
        }

        public final OrderedProperties getProperties() {
            return this.properties;
        }

        public final List<String> getPropertyKeys() {
            return this.properties.getPropertyKeys();
        }

        public final void addArgument(String string) {
            this.arguments.add(string);
        }

        public final void addAllArguments(List<String> list) {
            this.arguments.addAll(list);
        }

        public final ArrayList<String> getArguments() {
            return this.arguments;
        }

        public final Uri getUri() {
            Object object;
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(LauncherUtil.SCHEME).append(COLSLASH2).append(LauncherUtil.HOST).append('/').append(this.getActivityName());
            boolean bl = true;
            boolean bl2 = false;
            if (this.sysPackages.size() > 0) {
                if (bl) {
                    stringBuilder.append('?');
                    bl = false;
                }
                for (n = 0; n < this.sysPackages.size(); ++n) {
                    if (bl2) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append(LauncherUtil.SYS_PKG).append('=').append(this.sysPackages.get(n));
                    bl2 = true;
                }
            }
            if (this.usrPackages.size() > 0) {
                if (bl) {
                    stringBuilder.append('?');
                    bl = false;
                }
                for (n = 0; n < this.usrPackages.size(); ++n) {
                    if (bl2) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append(LauncherUtil.USR_PKG).append('=').append(this.usrPackages.get(n));
                    bl2 = true;
                }
            }
            Iterator<String> iterator = this.properties.keyList.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuilder.append('?');
                    bl = false;
                }
                if (bl2) {
                    stringBuilder.append('&');
                }
                object = iterator.next();
                stringBuilder.append((String)object).append('=').append(this.properties.map.get(object));
                bl2 = true;
            }
            object = this.arguments.iterator();
            while (object.hasNext()) {
                if (bl) {
                    stringBuilder.append('?');
                    bl = false;
                }
                if (bl2) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(LauncherUtil.ARG).append('=').append((String)object.next());
                bl2 = true;
            }
            return Uri.parse((String)stringBuilder.toString());
        }

        public static final DataSet create(Uri uri) {
            if (!uri.getScheme().equals(LauncherUtil.SCHEME)) {
                return null;
            }
            if (!uri.getHost().equals(LauncherUtil.HOST)) {
                return null;
            }
            DataSet dataSet = new DataSet();
            String string = uri.getPath();
            if ('/' == string.charAt(0)) {
                string = string.substring(1);
            }
            if ('/' == string.charAt(string.length() - 1)) {
                string = string.substring(0, string.length() - 1);
            }
            dataSet.setActivityName(string);
            string = uri.getQuery();
            int n = null != string ? string.length() : -1;
            int n2 = -1;
            while (n2 < n) {
                String string2;
                int n3;
                int n4 = n2 + 1;
                if (0 == (n2 = string.indexOf(38, n4))) continue;
                if (0 > n2) {
                    n2 = n;
                }
                if (0 < (n3 = (string2 = string.substring(n4, n2)).indexOf(61))) {
                    String string3 = string2.substring(0, n3);
                    String string4 = string2.substring(n3 + 1);
                    if (string3.equals(LauncherUtil.SYS_PKG)) {
                        if (string4.length() == 0) {
                            throw new IllegalArgumentException("Empty package name: part <" + string2 + ">, query <" + string + "> of " + uri);
                        }
                        dataSet.addSysPackage(string4);
                        continue;
                    }
                    if (string3.equals(LauncherUtil.USR_PKG)) {
                        if (string4.length() == 0) {
                            throw new IllegalArgumentException("Empty package name: part <" + string2 + ">, query <" + string + "> of " + uri);
                        }
                        dataSet.addUsrPackage(string4);
                        continue;
                    }
                    if (string3.equals(LauncherUtil.ARG)) {
                        if (string4.length() == 0) {
                            throw new IllegalArgumentException("Empty argument name: part <" + string2 + ">, query <" + string + "> of " + uri);
                        }
                        dataSet.addArgument(string4);
                        continue;
                    }
                    dataSet.setProperty(string3, string4);
                    continue;
                }
                if (string2.equals(LauncherUtil.USR_PKG) || string2.equals(LauncherUtil.ARG)) {
                    throw new IllegalArgumentException("Reserved key <" + string2 + "> in query <" + string + "> of " + uri);
                }
                dataSet.setProperty(string2, EMPTY);
            }
            dataSet.validate();
            return dataSet;
        }

        public final void validate() {
            if (null == this.activityName) {
                throw new RuntimeException("Activity is not NULL");
            }
        }
    }

    public static class OrderedProperties {
        HashMap<String, String> map = new HashMap();
        ArrayList<String> keyList = new ArrayList();

        public final void setProperty(String string, String string2) {
            if (string.equals(LauncherUtil.SYS_PKG)) {
                throw new IllegalArgumentException("Illegal property key, 'sys' is reserved");
            }
            if (string.equals(LauncherUtil.USR_PKG)) {
                throw new IllegalArgumentException("Illegal property key, 'pkg' is reserved");
            }
            if (string.equals(LauncherUtil.ARG)) {
                throw new IllegalArgumentException("Illegal property key, 'arg' is reserved");
            }
            String string3 = this.map.put(string, string2);
            if (null != string3) {
                this.map.put(string, string3);
                throw new IllegalArgumentException("Property overwriting not allowed: " + string + ": " + string3 + " -> " + string2);
            }
            this.keyList.add(string);
        }

        public final void addAll(OrderedProperties orderedProperties) {
            for (String string : orderedProperties.keyList) {
                this.setProperty(string, orderedProperties.map.get(string));
            }
        }

        public final void setSystemProperties() {
            for (String string : this.keyList) {
                System.setProperty(string, this.map.get(string));
            }
        }

        public final void clearSystemProperties() {
            Iterator<String> iterator = this.keyList.iterator();
            while (iterator.hasNext()) {
                System.clearProperty(iterator.next());
            }
        }

        public final String getProperty(String string) {
            return this.map.get(string);
        }

        public final Map<String, String> getProperties() {
            return this.map;
        }

        public final List<String> getPropertyKeys() {
            return this.keyList;
        }
    }

    public static abstract class BaseActivityLauncher
    extends Activity {
        final OrderedProperties props = new OrderedProperties();
        final ArrayList<String> args = new ArrayList();

        public String getAction() {
            return LauncherUtil.LAUNCH_ACTIVITY_NORMAL;
        }

        public final OrderedProperties getProperties() {
            return this.props;
        }

        public final ArrayList<String> getArguments() {
            return this.args;
        }

        public void init() {
        }

        public boolean finishAfterDelegate() {
            return true;
        }

        public abstract String getActivityName();

        public abstract List<String> getUsrPackages();

        public abstract List<String> getSysPackages();

        public void onCreate(Bundle bundle) {
            super.onCreate(bundle);
            this.init();
            DataSet dataSet = new DataSet();
            dataSet.setActivityName(this.getActivityName());
            dataSet.addAllSysPackages(this.getSysPackages());
            dataSet.addAllUsrPackages(this.getUsrPackages());
            dataSet.addAllProperties(this.props);
            dataSet.addAllArguments(this.args);
            Intent intent = LauncherUtil.getIntent(this.getAction(), dataSet);
            Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Launching Activity: " + intent));
            this.startActivity(intent);
            if (this.finishAfterDelegate()) {
                this.finish();
            }
        }
    }
}

