/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.universe;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.universe.PlatformGeometryState;
import com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.universe.ViewerAvatarState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewerAvatar;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.Locale;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;

public class SimpleUniverseState {
    private SimpleUniverse universe = null;
    private Controller control;
    private ArrayList localeBGs;
    private int totalBGs = 0;
    private PlatformGeometryState platformGeom;
    private ViewerAvatarState viewerAvatar;

    public SimpleUniverseState(ConfiguredUniverse configuredUniverse, Controller controller) {
        this.universe = configuredUniverse;
        this.control = controller;
    }

    public SimpleUniverseState(SimpleUniverse simpleUniverse, Controller controller) {
        this.universe = simpleUniverse;
        this.control = controller;
    }

    public SimpleUniverseState(Controller controller) {
        this.control = controller;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        int n = multiTransformGroup.getNumTransforms();
        dataOutput.writeInt(n);
        Transform3D transform3D = new Transform3D();
        Matrix4d matrix4d = new Matrix4d();
        for (int i = 0; i < n; ++i) {
            TransformGroup transformGroup = multiTransformGroup.getTransformGroup(i);
            transformGroup.getTransform(transform3D);
            transform3D.get(matrix4d);
            this.control.writeMatrix4d(dataOutput, matrix4d);
        }
        this.control.writeObject(dataOutput, this.control.createState(this.universe.getViewingPlatform().getPlatformGeometry()));
        this.control.writeObject(dataOutput, this.control.createState(this.universe.getViewer().getAvatar()));
        this.writeLocales(dataOutput);
    }

    public void readObject(DataInput dataInput, Canvas3D canvas3D) throws IOException {
        int n = dataInput.readInt();
        this.universe = canvas3D != null ? new ConfiguredUniverse(canvas3D, n) : new ConfiguredUniverse(ConfiguredUniverse.getConfigURL(), n);
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        Matrix4d matrix4d = new Matrix4d();
        for (int i = 0; i < n; ++i) {
            TransformGroup transformGroup = multiTransformGroup.getTransformGroup(i);
            matrix4d = this.control.readMatrix4d(dataInput);
            Transform3D transform3D = new Transform3D(matrix4d);
            transformGroup.setTransform(transform3D);
        }
        SceneGraphObjectState sceneGraphObjectState = this.control.readObject(dataInput);
        this.platformGeom = sceneGraphObjectState instanceof PlatformGeometryState ? (PlatformGeometryState)sceneGraphObjectState : null;
        sceneGraphObjectState = this.control.readObject(dataInput);
        this.viewerAvatar = sceneGraphObjectState instanceof ViewerAvatarState ? (ViewerAvatarState)sceneGraphObjectState : null;
        this.readLocales(dataInput);
    }

    private void writeLocales(DataOutput dataOutput) throws IOException {
        Enumeration<Locale> enumeration = this.universe.getAllLocales();
        dataOutput.writeInt(this.universe.numLocales());
        this.localeBGs = new ArrayList(this.universe.numLocales());
        boolean bl = false;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Locale locale = enumeration.nextElement();
            HiResCoord hiResCoord = new HiResCoord();
            this.writeHiResCoord(dataOutput, hiResCoord);
            int[] nArray = !bl ? new int[locale.numBranchGraphs() - 1] : new int[locale.numBranchGraphs()];
            dataOutput.writeInt(nArray.length);
            int n2 = 0;
            Enumeration enumeration2 = locale.getAllBranchGraphs();
            while (enumeration2.hasMoreElements()) {
                BranchGroup branchGroup = (BranchGroup)enumeration2.nextElement();
                if (branchGroup instanceof ViewingPlatform) continue;
                this.control.getSymbolTable().addBranchGraphReference(branchGroup, n);
                nArray[n2] = n++;
                dataOutput.writeInt(nArray[n2]);
                ++n2;
                ++this.totalBGs;
            }
            this.localeBGs.add(nArray);
        }
    }

    private void readLocales(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        this.localeBGs = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Locale locale;
            HiResCoord hiResCoord = this.readHiResCoord(dataInput);
            if (i == 0) {
                locale = this.universe.getLocale();
                locale.setHiRes(hiResCoord);
            } else {
                locale = new Locale(this.universe, hiResCoord);
            }
            int n2 = dataInput.readInt();
            int[] nArray = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArray[i] = dataInput.readInt();
                ++this.totalBGs;
            }
            this.localeBGs.add(nArray);
        }
    }

    public void buildGraph() {
        Enumeration<Locale> enumeration = this.universe.getAllLocales();
        for (int i = 0; i < this.localeBGs.size(); ++i) {
            Locale locale = enumeration.nextElement();
            int[] nArray = (int[])this.localeBGs.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                SymbolTableData symbolTableData = this.control.getSymbolTable().getBranchGraphRoot(nArray[j]);
                locale.addBranchGraph((BranchGroup)symbolTableData.j3dNode);
            }
        }
        if (this.viewerAvatar != null) {
            this.viewerAvatar.buildGraph();
            this.universe.getViewer().setAvatar((ViewerAvatar)this.viewerAvatar.getNode());
        }
        if (this.platformGeom != null) {
            this.universe.getViewingPlatform().setPlatformGeometry((PlatformGeometry)this.platformGeom.getNode());
            this.platformGeom.buildGraph();
        }
    }

    public int[] getAllGraphIDs() {
        int[] nArray = new int[this.totalBGs];
        int n = 0;
        for (int i = 0; i < this.localeBGs.size(); ++i) {
            int[] nArray2 = (int[])this.localeBGs.get(i);
            for (int j = 0; j < nArray2.length; ++j) {
                nArray[n++] = nArray2[j];
            }
        }
        return nArray;
    }

    public void detachAllGraphs() {
        boolean bl = false;
        try {
            for (int i = 0; i < this.localeBGs.size(); ++i) {
                int[] nArray = (int[])this.localeBGs.get(i);
                for (int j = 0; j < nArray.length; ++j) {
                    SymbolTableData symbolTableData = this.control.getSymbolTable().getBranchGraphRoot(nArray[j]);
                    ((BranchGroup)symbolTableData.j3dNode).detach();
                }
            }
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            throw new CapabilityNotSetException("Locale BranchGraphs MUST have ALLOW_DETACH capability set");
        }
    }

    public void attachAllGraphs() {
        Enumeration<Locale> enumeration = this.universe.getAllLocales();
        for (int i = 0; i < this.localeBGs.size(); ++i) {
            Locale locale = enumeration.nextElement();
            int[] nArray = (int[])this.localeBGs.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                SymbolTableData symbolTableData = this.control.getSymbolTable().getBranchGraphRoot(nArray[j]);
                locale.addBranchGraph((BranchGroup)symbolTableData.j3dNode);
            }
        }
    }

    public ConfiguredUniverse getNode() {
        if (this.universe instanceof ConfiguredUniverse) {
            return (ConfiguredUniverse)this.universe;
        }
        return null;
    }

    private void writeHiResCoord(DataOutput dataOutput, HiResCoord hiResCoord) throws IOException {
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        int[] nArray3 = new int[8];
        hiResCoord.getHiResCoord(nArray, nArray2, nArray3);
        for (int i = 0; i < 8; ++i) {
            dataOutput.writeInt(nArray[i]);
            dataOutput.writeInt(nArray2[i]);
            dataOutput.writeInt(nArray3[i]);
        }
    }

    private HiResCoord readHiResCoord(DataInput dataInput) throws IOException {
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        int[] nArray3 = new int[8];
        for (int i = 0; i < 8; ++i) {
            nArray[i] = dataInput.readInt();
            nArray2[i] = dataInput.readInt();
            nArray3[i] = dataInput.readInt();
        }
        return new HiResCoord(nArray, nArray2, nArray3);
    }
}

