/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry.PrimitiveState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.SceneGraphObject;

public class ConeState
extends PrimitiveState {
    private float radius = 1.0f;
    private float height = 2.0f;
    private int xdivision = 15;
    private int ydivision = 1;
    private int bodyAppearance = 0;
    private int capAppearance = 0;

    public ConeState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.bodyAppearance = controller.getSymbolTable().addReference(((Cone)this.node).getShape(0).getAppearance());
            this.capAppearance = controller.getSymbolTable().addReference(((Cone)this.node).getShape(1).getAppearance());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.bodyAppearance);
        dataOutput.writeInt(this.capAppearance);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.bodyAppearance = dataInput.readInt();
        this.capAppearance = dataInput.readInt();
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeFloat(((Cone)this.node).getRadius());
        dataOutput.writeFloat(((Cone)this.node).getHeight());
        dataOutput.writeInt(((Cone)this.node).getXdivisions());
        dataOutput.writeInt(((Cone)this.node).getYdivisions());
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.radius = dataInput.readFloat();
        this.height = dataInput.readFloat();
        this.xdivision = dataInput.readInt();
        this.ydivision = dataInput.readInt();
    }

    public void buildGraph() {
        if (this.bodyAppearance == this.capAppearance) {
            ((Cone)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
        } else {
            ((Cone)this.node).setAppearance(0, (Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
            ((Cone)this.node).setAppearance(1, (Appearance)this.control.getSymbolTable().getJ3dNode(this.capAppearance));
        }
        super.buildGraph();
    }

    public SceneGraphObject createNode(Class clazz) {
        Cone cone = (Cone)this.createNode(clazz, new Class[]{Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Appearance.class}, new Object[]{new Float(this.radius), new Float(this.height), new Integer(this.primflags), new Integer(this.xdivision), new Integer(this.ydivision), null});
        return cone;
    }

    protected SceneGraphObject createNode() {
        return new Cone(this.radius, this.height, this.primflags, this.xdivision, this.ydivision, null);
    }
}

