/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;

public class TextureDraw01GL2Listener
implements GLEventListener,
TextureDraw01Accessor {
    private final GLU glu = new GLU();
    private final TextureData textureData;
    private Texture texture;
    boolean keepTextureBound;

    public TextureDraw01GL2Listener(TextureData textureData) {
        this.textureData = textureData;
        this.keepTextureBound = false;
    }

    @Override
    public void setKeepTextureBound(boolean bl) {
        this.keepTextureBound = bl;
    }

    @Override
    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (null != this.textureData) {
            this.texture = TextureIO.newTexture(gLAutoDrawable.getGL(), this.textureData);
            if (this.keepTextureBound) {
                this.texture.enable(gL2);
                this.texture.bind(gL2);
            }
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluOrtho2D(0.0f, 1.0f, 0.0f, 1.0f);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (null != this.texture) {
            this.texture.disable(gL2);
            this.texture.destroy(gL2);
        }
        if (null != this.textureData) {
            this.textureData.destroy();
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (null != this.texture) {
            if (!this.keepTextureBound) {
                this.texture.enable(gL2);
                this.texture.bind(gL2);
            }
            gL2.glTexEnvi(8960, 8704, 7681);
            TextureCoords textureCoords = this.texture.getImageTexCoords();
            gL2.glBegin(7);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
            gL2.glVertex3f(0.0f, 0.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
            gL2.glVertex3f(1.0f, 0.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
            gL2.glVertex3f(1.0f, 1.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
            gL2.glVertex3f(0.0f, 1.0f, 0.0f);
            gL2.glEnd();
            if (!this.keepTextureBound) {
                this.texture.disable(gL2);
            }
        }
    }
}

