/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.caps;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.caps.MultisampleChooser01;
import com.jogamp.opengl.test.junit.jogl.demos.es2.MultisampleDemoES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLReadBufferUtil;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMultisampleES2NEWT
extends UITestCase {
    static long durationPerTest = 60L;

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], 500);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestMultisampleES2NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    @Test
    public void testOnscreenMultiSampleAA0() throws InterruptedException {
        this.testMultiSampleAAImpl(false, false, 0);
    }

    @Test
    public void testOnscreenMultiSampleAA8() throws InterruptedException {
        this.testMultiSampleAAImpl(false, false, 8);
    }

    @Test
    public void testOffscreenPBufferMultiSampleAA0() throws InterruptedException {
        this.testMultiSampleAAImpl(false, true, 0);
    }

    @Test(timeout=10000L)
    public void testOffsreenPBufferMultiSampleAA8() throws InterruptedException {
        this.testMultiSampleAAImpl(false, true, 8);
    }

    @Test(timeout=10000L)
    public void testOffscreenFBOMultiSampleAA0() throws InterruptedException {
        this.testMultiSampleAAImpl(true, false, 0);
    }

    @Test(timeout=10000L)
    public void testOffsreenFBOMultiSampleAA8() throws InterruptedException {
        this.testMultiSampleAAImpl(true, false, 8);
    }

    private void testMultiSampleAAImpl(boolean bl, boolean bl2, int n) throws InterruptedException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        MultisampleChooser01 multisampleChooser01 = new MultisampleChooser01();
        gLCapabilities.setAlphaBits(1);
        gLCapabilities.setFBO(bl);
        gLCapabilities.setPBuffer(bl2);
        if (n > 0) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n);
        }
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setCapabilitiesChooser(multisampleChooser01);
        gLWindow.addGLEventListener(new MultisampleDemoES2(n > 0));
        gLWindow.addGLEventListener(new GLEventListener(){
            int displayCount = 0;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                TestMultisampleES2NEWT.this.snapshot(this.displayCount++, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        gLWindow.setSize(512, 512);
        gLWindow.setVisible(true);
        gLWindow.requestFocus();
        Thread.sleep(durationPerTest);
        gLWindow.destroy();
    }
}

