/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.kd;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.kd.DisplayDriver;
import jogamp.newt.driver.kd.ScreenDriver;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class WindowDriver
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private long eglWindowHandle;
    private long windowHandleClose;
    private long windowUserData;

    @Override
    protected void createNativeImpl() {
        if (0L != this.getParentWindowHandle()) {
            throw new RuntimeException("Window parenting not supported (yet)");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(this.getScreen().getDisplay().getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, this.getScreen().getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        int n = gLCapabilitiesImmutable.getVisualID(VisualIDHolder.VIDType.EGL_CONFIG);
        long l = EGLGraphicsConfiguration.EGLConfigId2EGLConfig(this.getDisplayHandle(), n);
        this.eglWindowHandle = this.CreateWindow(this.getDisplayHandle(), l);
        if (this.eglWindowHandle == 0L) {
            throw new NativeWindowException("Error creating egl window: " + abstractGraphicsConfiguration + ", eglConfigID " + n + ", eglConfig 0x" + Long.toHexString(l));
        }
        this.setVisible0(this.eglWindowHandle, false);
        this.setWindowHandle(this.RealizeWindow(this.eglWindowHandle));
        if (0L == this.getWindowHandle()) {
            throw new NativeWindowException("Error native Window Handle is null");
        }
        this.windowHandleClose = this.eglWindowHandle;
    }

    @Override
    protected void closeNativeImpl() {
        if (0L != this.windowHandleClose) {
            this.CloseWindow(this.windowHandleClose, this.windowUserData);
            this.windowUserData = 0L;
        }
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        if (0 != (0x10 & n5)) {
            this.setVisible0(this.eglWindowHandle, 0 != (0x2000 & n5));
            this.visibleChanged(false, 0 != (0x2000 & n5));
        }
        if (0L != this.eglWindowHandle) {
            if (0 != (4 & n5)) {
                boolean bl = 0 != (0x400 & n5);
                this.setFullScreen0(this.eglWindowHandle, bl);
                if (bl) {
                    return true;
                }
            }
            n3 = n3 > 0 ? n3 : this.getWidth();
            int n6 = n4 = n4 > 0 ? n4 : this.getHeight();
            if (n3 > 0 || n4 > 0) {
                this.setSize0(this.eglWindowHandle, n3, n4);
            }
            if (n >= 0 || n2 >= 0) {
                System.err.println("setPosition n/a in KD");
            }
        }
        if (0 != (0x10 & n5)) {
            this.visibleChanged(false, 0 != (0x2000 & n5));
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return new Point(n, n2);
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    protected static native boolean initIDs();

    private native long CreateWindow(long var1, long var3);

    private native long RealizeWindow(long var1);

    private native int CloseWindow(long var1, long var3);

    private native void setVisible0(long var1, boolean var3);

    private native void setSize0(long var1, int var3, int var4);

    private native void setFullScreen0(long var1, boolean var3);

    private void windowCreated(long l) {
        this.windowUserData = l;
    }

    @Override
    protected void sizeChanged(boolean bl, int n, int n2, boolean bl2) {
        if (this.isFullscreen()) {
            ((ScreenDriver)this.getScreen()).sizeChanged(this.getWidth(), this.getHeight());
        }
        super.sizeChanged(bl, n, n2, bl2);
    }

    static {
        DisplayDriver.initSingleton();
    }
}

