/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.Assert;

public class GLSLSimpleProgram {
    private int shaderProgram;
    private int vertShader;
    private int fragShader;
    private boolean isValid;

    private GLSLSimpleProgram(int n, int n2, int n3) {
        this.shaderProgram = n;
        this.vertShader = n2;
        this.fragShader = n3;
        this.isValid = true;
    }

    public static GLSLSimpleProgram create(GL2ES2 gL2ES2, String string, String string2, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        int n = gL2ES2.glCreateShader(35633);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        int n2 = gL2ES2.glCreateShader(35632);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        String[] stringArray = new String[]{gL2ES2.getContext().getGLSLVersionString() + string};
        int[] nArray = new int[]{stringArray[0].length()};
        gL2ES2.glShaderSource(n, stringArray.length, stringArray, nArray, 0);
        gL2ES2.glCompileShader(n);
        if (!ShaderUtil.isShaderStatusValid((GL)gL2ES2, n, 35713, printStream)) {
            System.out.println("getShader:postCompile vertShader: " + byteArrayOutputStream.toString());
            Assert.assertTrue((boolean)false);
        }
        printStream.flush();
        byteArrayOutputStream.reset();
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        String[] stringArray2 = new String[]{gL2ES2.getContext().getGLSLVersionString() + string2};
        int[] nArray2 = new int[]{stringArray2[0].length()};
        gL2ES2.glShaderSource(n2, stringArray2.length, stringArray2, nArray2, 0);
        gL2ES2.glCompileShader(n2);
        if (!ShaderUtil.isShaderStatusValid((GL)gL2ES2, n2, 35713, printStream)) {
            System.out.println("getShader:postCompile fragShader: " + byteArrayOutputStream.toString());
            Assert.assertTrue((boolean)false);
        }
        printStream.flush();
        byteArrayOutputStream.reset();
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        int n3 = gL2ES2.glCreateProgram();
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        gL2ES2.glAttachShader(n3, n);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        gL2ES2.glAttachShader(n3, n2);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        if (bl) {
            gL2ES2.glLinkProgram(n3);
            if (!ShaderUtil.isProgramLinkStatusValid(gL2ES2, n3, printStream)) {
                System.out.println("Error (GLSL link error):  " + byteArrayOutputStream.toString());
                Assert.assertTrue((boolean)false);
            }
        }
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        GLSLSimpleProgram gLSLSimpleProgram = new GLSLSimpleProgram(n3, n, n2);
        return gLSLSimpleProgram;
    }

    public void release(GL2ES2 gL2ES2) {
        gL2ES2.glUseProgram(0);
        gL2ES2.glDetachShader(this.shaderProgram, this.vertShader);
        gL2ES2.glDeleteShader(this.vertShader);
        gL2ES2.glDetachShader(this.shaderProgram, this.fragShader);
        gL2ES2.glDeleteShader(this.fragShader);
        gL2ES2.glDeleteProgram(this.shaderProgram);
        this.isValid = false;
        this.shaderProgram = 0;
        this.vertShader = 0;
        this.fragShader = 0;
    }

    public int getFragShader() {
        return this.fragShader;
    }

    public int getShaderProgram() {
        return this.shaderProgram;
    }

    public int getVertShader() {
        return this.vertShader;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

