/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.perf;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPerf001GLJPanelInit02AWT
extends UITestCase {
    final long INIT_TIMEOUT = 10000L;
    static GLCapabilitiesImmutable caps = null;
    static long duration = 0L;
    static boolean wait = false;
    static int width = 800;
    static int height = 600;
    static int frameCount = 25;
    AtomicInteger initCount = new AtomicInteger(0);

    @BeforeClass
    public static void initClass() {
        GLProfile.initSingleton();
    }

    public void test(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final boolean bl, final boolean bl2, final int n, int n2, final int n3, final boolean bl3, final boolean bl4, final CanvasType canvasType, boolean bl5, final boolean bl6) {
        long l;
        final Animator animator = bl5 ? new Animator() : null;
        int n4 = (int)Math.round(Math.sqrt(n3));
        int n5 = n3 / n4;
        final int n6 = n / n4 - 32;
        final int n7 = n2 / n5 - 32;
        System.err.println("Frame size: " + n + "x" + n2 + " -> " + n3 + " x " + n6 + "x" + n7 + ", overlap " + bl6);
        System.err.println("SkipGLOrientationVerticalFlip " + bl2 + ", useGears " + bl + ", initMT " + bl3 + ", useAnim " + bl5);
        final JFrame[] jFrameArray = new JFrame[n3];
        final ArrayList arrayList = new ArrayList();
        final long[] lArray = new long[10];
        if (wait) {
            UITestCase.waitForKey("Pre-Init");
        }
        System.err.println("INIT START");
        this.initCount.set(0);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int n4;
                    lArray[0] = Platform.currentTimeMillis();
                    int n2 = 32;
                    int n32 = 32;
                    for (n4 = 0; n4 < n3; ++n4) {
                        GLADComp gLADComp;
                        jFrameArray[n4] = new JFrame(n4 + "/" + n3);
                        jFrameArray[n4].setLocation(n2, n32);
                        if (!bl6 && (n2 += n6 + 32) >= n) {
                            n2 = 32;
                            n32 += n7 + 32;
                        }
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BorderLayout());
                        jPanel.setDoubleBuffered(bl4);
                        Dimension dimension = new Dimension(n6, n7);
                        switch (canvasType) {
                            case GLCanvas_T: {
                                gLADComp = TestPerf001GLJPanelInit02AWT.this.createGLCanvas(gLCapabilitiesImmutable, bl, animator, dimension);
                                break;
                            }
                            case GLJPanel_T: {
                                gLADComp = TestPerf001GLJPanelInit02AWT.this.createGLJPanel(bl3, bl4, gLCapabilitiesImmutable, bl, bl2, animator, dimension);
                                break;
                            }
                            case NewtCanvasAWT_T: {
                                gLADComp = TestPerf001GLJPanelInit02AWT.this.createNewtCanvasAWT(gLCapabilitiesImmutable, bl, animator, dimension);
                                arrayList.add((NewtCanvasAWT)gLADComp.comp);
                                break;
                            }
                            case NOP_T: {
                                gLADComp = null;
                                break;
                            }
                            default: {
                                throw new InternalError("XXX");
                            }
                        }
                        if (null != gLADComp) {
                            gLADComp.glad.addGLEventListener(new GLEventListener(){

                                @Override
                                public void init(GLAutoDrawable gLAutoDrawable) {
                                    TestPerf001GLJPanelInit02AWT.this.initCount.incrementAndGet();
                                }

                                @Override
                                public void dispose(GLAutoDrawable gLAutoDrawable) {
                                }

                                @Override
                                public void display(GLAutoDrawable gLAutoDrawable) {
                                }

                                @Override
                                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                                }
                            });
                            jPanel.add(gLADComp.comp);
                        } else {
                            JTextArea jTextArea = new JTextArea("area " + n4){
                                boolean initialized;
                                boolean added;
                                int reshapeWidth;
                                int reshapeHeight;
                                {
                                    this.initialized = false;
                                    this.added = false;
                                    this.reshapeWidth = 0;
                                    this.reshapeHeight = 0;
                                }

                                @Override
                                public void addNotify() {
                                    this.added = true;
                                    super.addNotify();
                                }

                                @Override
                                public void reshape(int n, int n2, int n3, int n4) {
                                    super.reshape(n, n2, n3, n4);
                                    this.reshapeWidth = n3;
                                    this.reshapeHeight = n4;
                                }

                                @Override
                                protected void paintComponent(Graphics graphics) {
                                    super.paintComponent(graphics);
                                    if (!this.initialized && this.added && this.reshapeWidth > 0 && this.reshapeHeight > 0 && this.isDisplayable()) {
                                        this.initialized = true;
                                        TestPerf001GLJPanelInit02AWT.this.initCount.incrementAndGet();
                                    }
                                }
                            };
                            jTextArea.setEditable(false);
                            jTextArea.setSize(dimension);
                            jTextArea.setPreferredSize(dimension);
                            jPanel.add(jTextArea);
                        }
                        jFrameArray[n4].getContentPane().add(jPanel);
                        jFrameArray[n4].pack();
                    }
                    lArray[1] = Platform.currentTimeMillis();
                    for (n4 = 0; n4 < n3; ++n4) {
                        jFrameArray[n4].setVisible(true);
                    }
                    lArray[2] = Platform.currentTimeMillis();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        long l2 = l = System.currentTimeMillis();
        while (n3 > this.initCount.get() && 10000L > l2 - l) {
            try {
                Thread.sleep(100L);
                System.err.println("Sleep initialized: " + this.initCount + "/" + n3);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
        }
        lArray[3] = Platform.currentTimeMillis();
        double d = this.initCount.get();
        System.err.printf("P: %d %s%s:%n\tctor\t%6d/t %6.2f/1%n\tvisible\t%6d/t %6.2f/1%n\tsum-i\t%6d/t %6.2f/1%n", new Object[]{this.initCount.get(), canvasType, bl3 ? " (mt)" : " (01)", lArray[1] - lArray[0], (double)(lArray[1] - lArray[0]) / d, lArray[3] - lArray[1], (double)(lArray[3] - lArray[1]) / d, lArray[3] - lArray[0], (double)(lArray[3] - lArray[0]) / d});
        System.err.println("INIT END: " + this.initCount + "/" + n3);
        if (wait) {
            UITestCase.waitForKey("Post-Init");
        }
        if (null != animator) {
            animator.start();
        }
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (null != animator) {
            animator.stop();
        }
        lArray[4] = Platform.currentTimeMillis();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    while (!arrayList.isEmpty()) {
                        ((NewtCanvasAWT)arrayList.remove(0)).destroy();
                    }
                    for (int i = 0; i < n3; ++i) {
                        jFrameArray[i].dispose();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l3 = lArray[4] - lArray[0] - duration;
        System.err.printf("T: duration %d %d%n\ttotal-d\t%6d/t %6.2f/1%n\ttotal-i\t%6d/t %6.2f/1%n", duration, lArray[4] - lArray[3], lArray[4] - lArray[0], (double)(lArray[4] - lArray[0]) / d, l3, (double)l3 / d);
        System.err.println("Total: " + (lArray[4] - lArray[0]));
    }

    private GLADComp createNewtCanvasAWT(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLWindow gLWindow = GLWindow.create(gLCapabilitiesImmutable);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        newtCanvasAWT.setSize(dimension);
        newtCanvasAWT.setPreferredSize(dimension);
        if (bl) {
            GearsES2 gearsES2 = new GearsES2(0);
            gearsES2.setVerbose(false);
            gLWindow.addGLEventListener(gearsES2);
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add(gLWindow);
        }
        return new GLADComp(gLWindow, newtCanvasAWT);
    }

    private GLADComp createGLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLCanvas gLCanvas = new GLCanvas(gLCapabilitiesImmutable);
        gLCanvas.setSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        if (bl) {
            GearsES2 gearsES2 = new GearsES2(0);
            gearsES2.setVerbose(false);
            gLCanvas.addGLEventListener(gearsES2);
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add(gLCanvas);
        }
        return new GLADComp(gLCanvas, gLCanvas);
    }

    private GLADComp createGLJPanel(boolean bl, boolean bl2, GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl3, boolean bl4, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLJPanel gLJPanel = new GLJPanel(gLCapabilitiesImmutable);
        gLJPanel.setSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        gLJPanel.setDoubleBuffered(bl2);
        if (bl4) {
            gLJPanel.setSkipGLOrientationVerticalFlip(bl4);
        }
        if (bl3) {
            GearsES2 gearsES2 = new GearsES2(0);
            gearsES2.setVerbose(false);
            gearsES2.setFlipVerticalInGLOrientation(bl4);
            gLJPanel.addGLEventListener(gearsES2);
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add(gLJPanel);
        }
        if (bl) {
            gLJPanel.initializeBackend(true);
        }
        return new GLADComp(gLJPanel, gLJPanel);
    }

    @Test
    public void test00NopNoGLDefGrid() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, false, false, CanvasType.NOP_T, false, false);
    }

    @Test
    public void test01NopGLCanvasDefGrid() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, false, false, CanvasType.GLCanvas_T, false, false);
    }

    @Test
    public void test02NopGLJPanelDefGridSingleAutoFlip() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, false, false, CanvasType.GLJPanel_T, false, false);
    }

    @Test
    public void test03NopGLJPanelDefGridSingleManualFlip() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, true, width, height, frameCount, false, false, CanvasType.GLJPanel_T, false, false);
    }

    @Test
    public void test04NopGLJPanelDefGridMTManualFlip() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, true, width, height, frameCount, true, false, CanvasType.GLJPanel_T, false, false);
    }

    @Test
    public void test05NopNewtCanvasAWTDefGrid() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, false, false, CanvasType.NewtCanvasAWT_T, false, false);
    }

    @Test
    public void test11GearsGLCanvasDefGrid() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), true, false, width, height, frameCount, false, false, CanvasType.GLCanvas_T, true, false);
    }

    @Test
    public void test12GearsGLJPanelDefGridSingleAutoFlip() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), true, false, width, height, frameCount, false, false, CanvasType.GLJPanel_T, true, false);
    }

    @Test
    public void test13GearsGLJPanelDefGridSingleManualFlip() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), true, true, width, height, frameCount, false, false, CanvasType.GLJPanel_T, true, false);
    }

    @Test
    public void test14GearsGLJPanelDefGridMTManualFlip() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), true, true, width, height, frameCount, true, false, CanvasType.GLJPanel_T, true, false);
    }

    @Test
    public void test15GearsNewtCanvasAWTDefGrid() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), true, false, width, height, frameCount, false, false, CanvasType.NewtCanvasAWT_T, true, false);
    }

    @Test
    public void test20NopNoGLDefOverlap() throws InterruptedException, InvocationTargetException {
        this.test(null, false, false, width, height, frameCount, false, false, CanvasType.NOP_T, false, true);
    }

    @Test
    public void test21NopGLCanvasDefOverlap() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, false, false, CanvasType.GLCanvas_T, false, true);
    }

    @Test
    public void test22NopGLJPanelDefOverlapSingle() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, false, false, CanvasType.GLJPanel_T, false, true);
    }

    @Test
    public void test23NopGLJPanelDefOverlapMT() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, true, false, CanvasType.GLJPanel_T, false, true);
    }

    @Test
    public void test25NopNewtCanvasAWTDefOverlap() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, false, false, CanvasType.NewtCanvasAWT_T, false, true);
    }

    public void testXXNopGLJPanelDefOverlapSingle() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, false, width, height, frameCount, false, false, CanvasType.GLJPanel_T, false, true);
    }

    public void testXXNopGLJPanelBitmapGridSingle() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setBitmap(true);
        this.test(gLCapabilities, false, false, width, height, frameCount, false, false, CanvasType.GLJPanel_T, false, false);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        CanvasType canvasType = CanvasType.GLJPanel_T;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (stringArray[i].equals("-count")) {
                frameCount = MiscUtils.atoi(stringArray[++i], frameCount);
                continue;
            }
            if (stringArray[i].equals("-initMT")) {
                bl3 = true;
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-type")) {
                canvasType = CanvasType.valueOf(stringArray[++i]);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-swingDoubleBuffer")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].equals("-gears")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-anim")) {
                bl7 = true;
                continue;
            }
            if (stringArray[i].equals("-userVertFlip")) {
                bl6 = true;
                continue;
            }
            if (stringArray[i].equals("-overlap")) {
                bl8 = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                wait = true;
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-waitMain")) {
                bl2 = true;
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            bl = true;
        }
        if (bl2) {
            UITestCase.waitForKey("Main-Start");
        }
        if (bl) {
            GLProfile.initSingleton();
            TestPerf001GLJPanelInit02AWT testPerf001GLJPanelInit02AWT = new TestPerf001GLJPanelInit02AWT();
            testPerf001GLJPanelInit02AWT.test(null, bl5, bl6, width, height, frameCount, bl3, bl4, canvasType, bl7, bl8);
        } else {
            JUnitCore.main((String[])new String[]{TestPerf001GLJPanelInit02AWT.class.getName()});
        }
    }

    static class GLADComp {
        final GLAutoDrawable glad;
        final Component comp;

        GLADComp(GLAutoDrawable gLAutoDrawable, Component component) {
            this.glad = gLAutoDrawable;
            this.comp = component;
        }
    }

    static enum CanvasType {
        NOP_T,
        GLCanvas_T,
        GLJPanel_T,
        NewtCanvasAWT_T;

    }
}

