/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glu;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.nio.ByteBuffer;
import jogamp.opengl.glu.mipmap.Mipmap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug365TextureGenerateMipMaps
extends UITestCase {
    static GLOffscreenAutoDrawable drawable;

    @BeforeClass
    public static void setup() throws Throwable {
        System.setProperty("jogl.texture.nonpot", "true");
        TestBug365TextureGenerateMipMaps.setUpOffscreenAutoDrawable();
    }

    @AfterClass
    public static void teardown() {
        TestBug365TextureGenerateMipMaps.tearDownOffscreenAutoDrawable();
    }

    private static void setUpOffscreenAutoDrawable() throws Throwable {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLProfile);
        drawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, 2, 2);
        drawable.display();
        GLContext gLContext = drawable.getContext();
        try {
            Assert.assertTrue((String)"Could not make context current", (0 < gLContext.makeCurrent() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            TestBug365TextureGenerateMipMaps.tearDownOffscreenAutoDrawable();
            throw throwable;
        }
    }

    private static void tearDownOffscreenAutoDrawable() {
        if (drawable != null) {
            drawable.getContext().release();
            drawable.destroy();
            drawable = null;
        }
    }

    private static void testTextureMipMapGeneration(int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = Mipmap.image_size(n, n2, n3, n4);
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(n6);
        TextureData textureData = new TextureData(drawable.getGLProfile(), n5, n, n2, 0, n3, n4, true, false, false, byteBuffer, null);
        Texture texture = TextureIO.newTexture(drawable.getGL(), textureData);
        texture.destroy(drawable.getGL());
        textureData.destroy();
        byteBuffer.clear();
        byteBuffer = null;
    }

    @Test
    public void test00_MipMap_ScaleInternal_RGB_UBYTE() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6407, 5121);
    }

    @Test
    public void test01_MipMap_ScaleInternal_RGBA_UBYTE() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6408, 5121);
    }

    @Test
    public void test02_MipMap_ScaleInternal_RGB_BYTE() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6407, 5120);
    }

    @Test
    public void test03_MipMap_ScaleInternal_RGBA_BYTE() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6408, 5120);
    }

    @Test
    public void test04_MipMap_ScaleInternal_RGB_USHORT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6407, 5123);
    }

    @Test
    public void test05_MipMap_ScaleInternal_RGBA_USHORT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6408, 5123);
    }

    @Test
    public void test06_MipMap_ScaleInternal_RGB_SHORT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6407, 5122);
    }

    @Test
    public void test07_MipMap_ScaleInternal_RGBA_SHORT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6408, 5122);
    }

    @Test
    public void test08_MipMap_ScaleInternal_RGB_UINT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6407, 5125);
    }

    @Test
    public void test09_MipMap_ScaleInternal_RGBA_UINT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6408, 5125);
    }

    @Test
    public void test10_MipMap_ScaleInternal_RGB_INT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6407, 5124);
    }

    @Test
    public void test11_MipMap_ScaleInternal_RGBA_INT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6408, 5124);
    }

    @Test
    public void test12_MipMap_ScaleInternal_RGB_FLOAT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6407, 5126);
    }

    @Test
    public void test13_MipMap_ScaleInternal_RGBA_FLOAT() {
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(1, 7, 6408, 5126);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug365TextureGenerateMipMaps.class.getName()});
    }
}

