/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2.newt;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Teapot;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTeapotNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2")) {
            glp = GLProfile.get("GL2");
            Assert.assertNotNull((Object)glp);
            width = 640;
            height = 480;
        } else {
            TestTeapotNEWT.setTestSupported(false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities, boolean bl) throws InterruptedException {
        long l;
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle("Teapot NEWT Test");
        Teapot teapot = new Teapot();
        if (!bl) {
            teapot.rotIncr *= 10.0f;
        }
        gLWindow.addGLEventListener(teapot);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener(snapshotGLEventListener);
        Animator animator = bl ? new Animator(gLWindow) : null;
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        if (bl) {
            animator.setUpdateFPSFrames(60, System.err);
            animator.start();
        }
        long l2 = l = System.currentTimeMillis();
        int n = 3;
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
            if (n-- > 0) {
                snapshotGLEventListener.setMakeSnapshot();
            }
            if (bl) continue;
            gLWindow.display();
        }
        if (bl) {
            animator.stop();
        }
        gLWindow.destroy();
    }

    @Test
    public void test01_DefCaps_Anim() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getMaxFixedFunc(true));
        this.runTestGL(gLCapabilities, true);
    }

    @Test
    public void test02_DefCaps_NoAnim() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getMaxFixedFunc(true));
        this.runTestGL(gLCapabilities, false);
    }

    @Test
    public void test12_FBOCaps_NoAnim() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getMaxFixedFunc(true));
        gLCapabilities.setHardwareAccelerated(true);
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setDepthBits(8);
        gLCapabilities.setNumSamples(0);
        gLCapabilities.setSampleBuffers(false);
        gLCapabilities.setStencilBits(0);
        gLCapabilities.setRedBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setFBO(true);
        this.runTestGL(gLCapabilities, false);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestTeapotNEWT.class.getName()});
    }

    static {
        duration = 500L;
    }
}

