/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.caps;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTranslucencyAWT
extends UITestCase {
    static Dimension size;
    static long durationPerTest;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        size = new Dimension(400, 200);
        glCaps = new GLCapabilities(null);
        glCaps.setBackgroundOpaque(false);
    }

    static Frame getTranslucentFrame() {
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        block2: for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[j];
                ColorModel colorModel = graphicsConfiguration2.getColorModel(3);
                boolean bl = null != colorModel ? colorModel.getTransparency() == 3 : false;
                boolean bl2 = false;
                try {
                    bl2 = (Boolean)ReflectionUtil.callStaticMethod("com.sun.awt.AWTUtilities", "isTranslucencyCapable", new Class[]{GraphicsConfiguration.class}, new Object[]{graphicsConfiguration2}, GraphicsConfiguration.class.getClassLoader());
                    System.err.println("com.sun.awt.AWTUtilities.isTranslucencyCapable(config) passed: " + bl2);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("com.sun.awt.AWTUtilities.isTranslucencyCapable(config) failed: " + runtimeException.getMessage());
                }
                System.err.println(i + ":" + j + " " + graphicsConfiguration2 + ", " + colorModel + ", capable " + bl + "/" + bl2);
                if (!bl || !bl2) continue;
                graphicsConfiguration = graphicsConfigurationArray[j];
                System.err.println("Chosen " + i + ":" + j + " " + graphicsConfiguration2 + ", " + colorModel + ", capable " + bl + "/" + bl2);
                continue block2;
            }
        }
        Frame frame = new Frame(graphicsConfiguration);
        if (null != graphicsConfiguration) {
            frame.setUndecorated(true);
            frame.setBackground(new Color(0, 0, 0, 0));
        }
        frame.setTitle("AWT Parent Frame (opaque: " + (null == graphicsConfiguration) + ")");
        return frame;
    }

    @Test
    public void test() throws InterruptedException, InvocationTargetException {
        final Frame frame = TestTranslucencyAWT.getTranslucentFrame();
        GLCanvas gLCanvas = new GLCanvas(glCaps);
        gLCanvas.setPreferredSize(size);
        GearsES2 gearsES2 = new GearsES2(1);
        gLCanvas.addGLEventListener(gearsES2);
        Animator animator = new Animator(gLCanvas);
        animator.start();
        final Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)gLCanvas, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                container.setVisible(true);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)container, "East");
        frame.add((Component)new Label("center"), "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setLocation(0, 0);
                frame.setSize((int)size.getWidth(), (int)size.getHeight());
                frame.pack();
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertNotNull((Object)animator.getThread());
        Thread.sleep(durationPerTest);
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals(null, (Object)animator.getThread());
        frame.dispose();
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestTranslucencyAWT.atoi(stringArray[++i]);
        }
        String string = TestTranslucencyAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 400L;
    }
}

