/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.nativewindow.NativeWindowVersion;
import com.jogamp.newt.NewtVersion;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.acore.GLProfile0XBase;
import java.io.IOException;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLProfile01NEWT
extends GLProfile0XBase {
    @Test
    public void test00Version() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory;
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println(NativeWindowVersion.getInstance());
        System.err.println(JoglVersion.getInstance());
        System.err.println(NewtVersion.getInstance());
        GLDrawableFactory gLDrawableFactory2 = GLDrawableFactory.getDesktopFactory();
        if (null != gLDrawableFactory2) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(gLDrawableFactory2.getDefaultDevice(), null, true).toString());
        }
        if (null != (gLDrawableFactory = GLDrawableFactory.getEGLFactory())) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(gLDrawableFactory.getDefaultDevice(), null, true).toString());
        }
    }

    @Test
    public void test01GLProfileDefault() throws InterruptedException {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
        System.out.println("GLProfile.getDefaultDevice(): " + GLProfile.getDefaultDevice());
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile.getDefault(): " + gLProfile);
        TestGLProfile01NEWT.validateOffline("default", gLProfile);
        this.validateOnlineOnscreen("default", gLProfile);
    }

    @Test
    public void test02GLProfileMaxProgrammable() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxProgrammable(true);
        System.out.println("GLProfile.getMaxProgrammable(): " + gLProfile);
        TestGLProfile01NEWT.validateOffline("maxProgrammable", gLProfile);
        this.validateOnlineOnscreen("maxProgrammable", gLProfile);
    }

    @Test
    public void test03GLProfileMaxFixedFunc() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        System.out.println("GLProfile.getMaxFixedFunc(): " + gLProfile);
        TestGLProfile01NEWT.validateOffline("maxFixedFunc", gLProfile);
        this.validateOnlineOnscreen("maxFixedFunc", gLProfile);
    }

    @Test
    public void test04GLProfileGL2ES1() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2ES1")) {
            System.out.println("GLProfile GL2ES1 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES1();
        TestGLProfile01NEWT.validateOffline("GL2ES1", gLProfile);
        this.validateOnlineOnscreen("GL2ES1", gLProfile);
    }

    @Test
    public void test05GLProfileGL2ES2() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2ES2")) {
            System.out.println("GLProfile GL2ES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        TestGLProfile01NEWT.validateOffline("GL2ES2", gLProfile);
        this.validateOnlineOnscreen("GL2ES2", gLProfile);
    }

    @Test
    public void test06GLProfileGL4ES3() throws InterruptedException {
        if (!GLProfile.isAvailable("GL4ES3")) {
            System.out.println("GLProfile GL4ES3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL4ES3();
        TestGLProfile01NEWT.validateOffline("GL4ES3", gLProfile);
        this.validateOnlineOnscreen("GL4ES3", gLProfile);
    }

    @Test
    public void test07GLProfileGL2GL3() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2GL3")) {
            System.out.println("GLProfile GL2GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2GL3();
        TestGLProfile01NEWT.validateOffline("GL2GL3", gLProfile);
        this.validateOnlineOnscreen("GL2GL3", gLProfile);
    }

    void testSpecificProfile(String string) throws InterruptedException {
        if (GLProfile.isAvailable(string)) {
            GLProfile gLProfile = GLProfile.get(string);
            TestGLProfile01NEWT.validateOffline(string, gLProfile);
            this.validateOnlineOnscreen(string, gLProfile);
        } else {
            System.err.println("Profile " + string + " n/a");
        }
    }

    @Test
    public void test10_GL4bc() throws InterruptedException {
        this.testSpecificProfile("GL4bc");
    }

    @Test
    public void test11_GL3bc() throws InterruptedException {
        this.testSpecificProfile("GL3bc");
    }

    @Test
    public void test12_GL2() throws InterruptedException {
        this.testSpecificProfile("GL2");
    }

    @Test
    public void test13_GL4() throws InterruptedException {
        this.testSpecificProfile("GL4");
    }

    @Test
    public void test14_GL3() throws InterruptedException {
        this.testSpecificProfile("GL3");
    }

    @Test
    public void test15_GLES1() throws InterruptedException {
        this.testSpecificProfile("GLES1");
    }

    @Test
    public void test16_GLES2() throws InterruptedException {
        this.testSpecificProfile("GLES2");
    }

    @Test
    public void test17_GLES3() throws InterruptedException {
        this.testSpecificProfile("GLES3");
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGLProfile01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

