/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;

public abstract class UIShape {
    public static final boolean DRAW_DEBUG_BOX = false;
    protected static final int DIRTY_SHAPE = 1;
    protected static final int DIRTY_STATE = 2;
    private final Vertex.Factory<? extends Vertex> vertexFactory;
    private final int renderModes;
    protected final AABBox box;
    protected final float[] translate = new float[]{0.0f, 0.0f, 0.0f};
    protected final Quaternion rotation = new Quaternion();
    protected final float[] rotOrigin = new float[]{0.0f, 0.0f, 0.0f};
    protected final float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    protected GLRegion region = null;
    protected int regionQuality = 1;
    protected int dirty = 3;
    protected float shapesSharpness = 0.5f;
    protected final float[] rgbaColor = new float[]{0.75f, 0.75f, 0.75f, 1.0f};
    protected final float[] pressedRGBAModulate = new float[]{1.2f, 1.2f, 1.2f, 0.7f};
    protected final float[] toggleOnRGBAModulate = new float[]{1.13f, 1.13f, 1.13f, 1.0f};
    protected final float[] toggleOffRGBAModulate = new float[]{0.86f, 0.86f, 0.86f, 1.0f};
    private int name = -1;
    private boolean down = false;
    private boolean toggle = false;
    private boolean toggleable = false;
    private boolean enabled = true;
    private ArrayList<MouseGestureListener> mouseListeners = new ArrayList();

    public UIShape(Vertex.Factory<? extends Vertex> factory, int n) {
        this.vertexFactory = factory;
        this.renderModes = n;
        this.box = new AABBox();
    }

    public void setName(int n) {
        this.name = n;
    }

    public int getName() {
        return this.name;
    }

    public final Vertex.Factory<? extends Vertex> getVertexFactory() {
        return this.vertexFactory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void clear(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.clearImpl(gL2ES2, regionRenderer);
        this.translate[0] = 0.0f;
        this.translate[1] = 0.0f;
        this.translate[2] = 0.0f;
        this.rotation.setIdentity();
        this.rotOrigin[0] = 0.0f;
        this.rotOrigin[1] = 0.0f;
        this.rotOrigin[2] = 0.0f;
        this.scale[0] = 1.0f;
        this.scale[1] = 1.0f;
        this.scale[2] = 1.0f;
        this.box.reset();
        this.markShapeDirty();
    }

    public void destroy(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.destroyImpl(gL2ES2, regionRenderer);
        this.translate[0] = 0.0f;
        this.translate[1] = 0.0f;
        this.translate[2] = 0.0f;
        this.rotation.setIdentity();
        this.rotOrigin[0] = 0.0f;
        this.rotOrigin[1] = 0.0f;
        this.rotOrigin[2] = 0.0f;
        this.scale[0] = 1.0f;
        this.scale[1] = 1.0f;
        this.scale[2] = 1.0f;
        this.box.reset();
        this.markShapeDirty();
    }

    public void setTranslate(float f, float f2, float f3) {
        this.translate[0] = f;
        this.translate[1] = f2;
        this.translate[2] = f3;
    }

    public void translate(float f, float f2, float f3) {
        this.translate[0] = this.translate[0] + f;
        this.translate[1] = this.translate[1] + f2;
        this.translate[2] = this.translate[2] + f3;
    }

    public final float[] getTranslate() {
        return this.translate;
    }

    public final Quaternion getRotation() {
        return this.rotation;
    }

    public final float[] getRotationOrigin() {
        return this.rotOrigin;
    }

    public void setRotationOrigin(float f, float f2, float f3) {
        this.rotOrigin[0] = f;
        this.rotOrigin[1] = f2;
        this.rotOrigin[2] = f3;
    }

    public void setScale(float f, float f2, float f3) {
        this.scale[0] = f;
        this.scale[1] = f2;
        this.scale[2] = f3;
    }

    public void scale(float f, float f2, float f3) {
        this.scale[0] = this.scale[0] * f;
        this.scale[1] = this.scale[1] * f2;
        this.scale[2] = this.scale[2] * f3;
    }

    public final float[] getScale() {
        return this.scale;
    }

    public final void markShapeDirty() {
        this.dirty |= 1;
    }

    public final boolean isShapeDirty() {
        return 0 != (this.dirty & 1);
    }

    public final void markStateDirty() {
        this.dirty |= 2;
    }

    public final boolean isStateDirty() {
        return 0 != (this.dirty & 2);
    }

    public final AABBox getBounds() {
        return this.box;
    }

    public final int getRenderModes() {
        return this.renderModes;
    }

    public GLRegion getRegion(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.validate(gL2ES2, regionRenderer);
        return this.region;
    }

    public void drawShape(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray) {
        float f;
        float f2;
        float f3;
        float f4;
        boolean bl;
        boolean bl2 = this.isPressed();
        boolean bl3 = this.isToggleOn();
        boolean bl4 = bl = !Region.hasColorChannel(this.renderModes) && !Region.hasColorTexture(this.renderModes);
        if (bl) {
            if (bl2) {
                f4 = this.rgbaColor[0] * this.pressedRGBAModulate[0];
                f3 = this.rgbaColor[1] * this.pressedRGBAModulate[1];
                f2 = this.rgbaColor[2] * this.pressedRGBAModulate[2];
                f = this.rgbaColor[3] * this.pressedRGBAModulate[3];
            } else if (this.isToggleable()) {
                if (bl3) {
                    f4 = this.rgbaColor[0] * this.toggleOnRGBAModulate[0];
                    f3 = this.rgbaColor[1] * this.toggleOnRGBAModulate[1];
                    f2 = this.rgbaColor[2] * this.toggleOnRGBAModulate[2];
                    f = this.rgbaColor[3] * this.toggleOnRGBAModulate[3];
                } else {
                    f4 = this.rgbaColor[0] * this.toggleOffRGBAModulate[0];
                    f3 = this.rgbaColor[1] * this.toggleOffRGBAModulate[1];
                    f2 = this.rgbaColor[2] * this.toggleOffRGBAModulate[2];
                    f = this.rgbaColor[3] * this.toggleOffRGBAModulate[3];
                }
            } else {
                f4 = this.rgbaColor[0];
                f3 = this.rgbaColor[1];
                f2 = this.rgbaColor[2];
                f = this.rgbaColor[3];
            }
        } else if (bl2) {
            f4 = this.pressedRGBAModulate[0];
            f3 = this.pressedRGBAModulate[1];
            f2 = this.pressedRGBAModulate[2];
            f = this.pressedRGBAModulate[3];
        } else if (this.isToggleable()) {
            if (bl3) {
                f4 = this.toggleOnRGBAModulate[0];
                f3 = this.toggleOnRGBAModulate[1];
                f2 = this.toggleOnRGBAModulate[2];
                f = this.toggleOnRGBAModulate[3];
            } else {
                f4 = this.toggleOffRGBAModulate[0];
                f3 = this.toggleOffRGBAModulate[1];
                f2 = this.toggleOffRGBAModulate[2];
                f = this.toggleOffRGBAModulate[3];
            }
        } else {
            f4 = this.rgbaColor[0];
            f3 = this.rgbaColor[1];
            f2 = this.rgbaColor[2];
            f = this.rgbaColor[3];
        }
        regionRenderer.getRenderState().setColorStatic(f4, f3, f2, f);
        this.getRegion(gL2ES2, regionRenderer).draw(gL2ES2, regionRenderer, nArray);
    }

    protected GLRegion createGLRegion() {
        return GLRegion.create(this.renderModes, null);
    }

    public final void validate(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        if (this.isShapeDirty() || null == this.region) {
            this.box.reset();
            if (null == this.region) {
                this.region = this.createGLRegion();
            } else {
                this.region.clear(gL2ES2);
            }
            this.addShapeToRegion(gL2ES2, regionRenderer);
            this.region.setQuality(this.regionQuality);
            this.dirty &= 0xFFFFFFFC;
        } else if (this.isStateDirty()) {
            this.region.markStateDirty();
            this.dirty &= 0xFFFFFFFD;
        }
    }

    public float[] getColor() {
        return this.rgbaColor;
    }

    public final int getQuality() {
        return this.regionQuality;
    }

    public final void setQuality(int n) {
        this.regionQuality = n;
        if (null != this.region) {
            this.region.setQuality(n);
        }
    }

    public final void setSharpness(float f) {
        this.shapesSharpness = f;
        this.markShapeDirty();
    }

    public final float getSharpness() {
        return this.shapesSharpness;
    }

    public final void setColor(float f, float f2, float f3, float f4) {
        this.rgbaColor[0] = f;
        this.rgbaColor[1] = f2;
        this.rgbaColor[2] = f3;
        this.rgbaColor[3] = f4;
    }

    public final void setPressedColorMod(float f, float f2, float f3, float f4) {
        this.pressedRGBAModulate[0] = f;
        this.pressedRGBAModulate[1] = f2;
        this.pressedRGBAModulate[2] = f3;
        this.pressedRGBAModulate[3] = f4;
    }

    public final void setToggleOnColorMod(float f, float f2, float f3, float f4) {
        this.toggleOnRGBAModulate[0] = f;
        this.toggleOnRGBAModulate[1] = f2;
        this.toggleOnRGBAModulate[2] = f3;
        this.toggleOnRGBAModulate[3] = f4;
    }

    public final void setToggleOffColorMod(float f, float f2, float f3, float f4) {
        this.toggleOffRGBAModulate[0] = f;
        this.toggleOffRGBAModulate[1] = f2;
        this.toggleOffRGBAModulate[2] = f3;
        this.toggleOffRGBAModulate[3] = f4;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSubString() + "]";
    }

    public String getSubString() {
        return "enabled " + this.enabled + ", toggle[able " + this.toggleable + ", state " + this.toggle + "], " + this.translate[0] + " / " + this.translate[1] + ", box " + this.box;
    }

    public void setPressed(boolean bl) {
        this.down = bl;
        this.markStateDirty();
    }

    public boolean isPressed() {
        return this.down;
    }

    public void setToggleable(boolean bl) {
        this.toggleable = bl;
    }

    public boolean isToggleable() {
        return this.toggleable;
    }

    public void setToggle(boolean bl) {
        this.toggle = bl;
        this.markStateDirty();
    }

    public void toggle() {
        if (this.isToggleable()) {
            this.toggle = !this.toggle;
        }
        this.markStateDirty();
    }

    public boolean isToggleOn() {
        return this.toggle;
    }

    public final void addMouseListener(MouseGestureListener mouseGestureListener) {
        if (mouseGestureListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.add(mouseGestureListener);
        this.mouseListeners = arrayList;
    }

    public final void removeMouseListener(MouseGestureListener mouseGestureListener) {
        if (mouseGestureListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.remove(mouseGestureListener);
        this.mouseListeners = arrayList;
    }

    public final void dispatchGestureEvent(GestureHandler.GestureEvent gestureEvent, int n, int n2, float[] fArray) {
        gestureEvent.setAttachment(new PointerEventInfo(n, n2, this, fArray));
        for (int i = 0; !gestureEvent.isConsumed() && i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).gestureDetected(gestureEvent);
        }
    }

    public final void dispatchMouseEvent(MouseEvent mouseEvent, int n, int n2, float[] fArray) {
        mouseEvent.setAttachment(new PointerEventInfo(n, n2, this, fArray));
        short s = mouseEvent.getEventType();
        if (1 == mouseEvent.getPointerCount()) {
            switch (s) {
                case 200: {
                    this.toggle();
                    break;
                }
                case 203: {
                    this.setPressed(true);
                    break;
                }
                case 204: {
                    this.setPressed(false);
                }
            }
        }
        block15: for (int i = 0; !mouseEvent.isConsumed() && i < this.mouseListeners.size(); ++i) {
            MouseGestureListener mouseGestureListener = this.mouseListeners.get(i);
            switch (s) {
                case 200: {
                    mouseGestureListener.mouseClicked(mouseEvent);
                    continue block15;
                }
                case 201: {
                    mouseGestureListener.mouseEntered(mouseEvent);
                    continue block15;
                }
                case 202: {
                    mouseGestureListener.mouseExited(mouseEvent);
                    continue block15;
                }
                case 203: {
                    mouseGestureListener.mousePressed(mouseEvent);
                    continue block15;
                }
                case 204: {
                    mouseGestureListener.mouseReleased(mouseEvent);
                    continue block15;
                }
                case 205: {
                    mouseGestureListener.mouseMoved(mouseEvent);
                    continue block15;
                }
                case 206: {
                    mouseGestureListener.mouseDragged(mouseEvent);
                    continue block15;
                }
                case 207: {
                    mouseGestureListener.mouseWheelMoved(mouseEvent);
                    continue block15;
                }
                default: {
                    throw new NativeWindowException("Unexpected mouse event type " + mouseEvent.getEventType());
                }
            }
        }
    }

    protected abstract void clearImpl(GL2ES2 var1, RegionRenderer var2);

    protected abstract void destroyImpl(GL2ES2 var1, RegionRenderer var2);

    protected abstract void addShapeToRegion(GL2ES2 var1, RegionRenderer var2);

    protected OutlineShape createDebugOutline(OutlineShape outlineShape, AABBox aABBox) {
        float f = aABBox.getWidth();
        float f2 = aABBox.getHeight();
        float f3 = aABBox.getMinX();
        float f4 = aABBox.getMinY();
        float f5 = aABBox.getMinZ() + 0.025f;
        outlineShape.addVertex(f3, f4, f5, true);
        outlineShape.addVertex(f3 + f, f4, f5, true);
        outlineShape.addVertex(f3 + f, f4 + f2, f5, true);
        outlineShape.addVertex(f3, f4 + f2, f5, true);
        outlineShape.closeLastOutline(true);
        return outlineShape;
    }

    public static class PointerEventInfo {
        public final UIShape shape;
        public final float[] objPos;
        public final int glWinX;
        public final int glWinY;

        PointerEventInfo(int n, int n2, UIShape uIShape, float[] fArray) {
            this.glWinX = n;
            this.glWinY = n2;
            this.shape = uIShape;
            this.objPos = fArray;
        }

        public String toString() {
            return "EventDetails[winPos [" + this.glWinX + ", " + this.glWinY + "], objPos [" + this.objPos[0] + ", " + this.objPos[1] + ", " + this.objPos[2] + "], " + this.shape + "]";
        }
    }

    public static abstract class MouseGestureAdapter
    extends MouseAdapter
    implements MouseGestureListener {
        @Override
        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
        }
    }

    public static interface MouseGestureListener
    extends MouseListener,
    GestureHandler.GestureListener {
    }
}

