/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.NEWTKeyUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNewtKeyCodeModifiersAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long awtWaitTimeout;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @AfterClass
    public static void release() {
    }

    @Before
    public void initTest() {
    }

    @After
    public void releaseTest() {
    }

    @Test(timeout=180000L)
    public void test01NEWT() throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        this.testImpl(gLWindow);
        gLWindow.destroy();
    }

    private void testNewtCanvasAWT_Impl(boolean bl) throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        if (!bl) {
            newtCanvasAWT.setShallUseOffscreenLayer(true);
        }
        final JFrame jFrame = new JFrame("Swing AWT Parent Frame: " + gLWindow.getTitle());
        jFrame.getContentPane().add((Component)newtCanvasAWT, "Center");
        jFrame.setSize(width, height);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true));
        this.testImpl(gLWindow);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLWindow.destroy();
    }

    @Test(timeout=180000L)
    public void test02NewtCanvasAWT_Onscreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("Platform doesn't support onscreen rendering.");
            return;
        }
        this.testNewtCanvasAWT_Impl(true);
    }

    @Test(timeout=180000L)
    public void test03NewtCanvasAWT_Offsccreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (!JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("Platform doesn't support offscreen rendering.");
            return;
        }
        this.testNewtCanvasAWT_Impl(false);
    }

    static void testKeyCodeModifier(Robot robot, NEWTKeyAdapter nEWTKeyAdapter, short s, int n, short s2, char c, char c2) {
        int n2;
        nEWTKeyAdapter.reset();
        AWTRobotUtil.waitForIdle(robot);
        AWTRobotUtil.newtKeyPress(0, robot, true, s2, 10);
        AWTRobotUtil.newtKeyPress(0, robot, false, s2, 100);
        AWTRobotUtil.waitForIdle(robot);
        for (n2 = 0; n2 < 100 && nEWTKeyAdapter.getQueueSize() < 2; ++n2) {
            robot.delay(100);
        }
        AWTRobotUtil.waitForIdle(robot);
        AWTRobotUtil.newtKeyPress(0, robot, true, s, 10);
        AWTRobotUtil.newtKeyPress(0, robot, true, s2, 10);
        AWTRobotUtil.newtKeyPress(0, robot, false, s2, 10);
        AWTRobotUtil.newtKeyPress(0, robot, false, s, 100);
        AWTRobotUtil.waitForIdle(robot);
        for (n2 = 0; n2 < 100 && nEWTKeyAdapter.getQueueSize() < 6; ++n2) {
            robot.delay(100);
        }
        NEWTKeyUtil.validateKeyAdapterStats(nEWTKeyAdapter, 3, 3, 0, 0);
        List<EventObject> list = nEWTKeyAdapter.copyQueue();
        int n3 = 0;
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n3++), (short)300, 0, s2, c);
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n3++), (short)301, 0, s2, c);
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n3++), (short)300, n, s, '\u0000');
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n3++), (short)300, n, s2, c2);
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n3++), (short)301, n, s2, c2);
        KeyEvent keyEvent = (KeyEvent)list.get(n3++);
        NEWTKeyUtil.validateKeyEvent(keyEvent, (short)301, n, s, '\u0000');
    }

    static void testKeyCodeAllModifierV1(Robot robot, NEWTKeyAdapter nEWTKeyAdapter) {
        nEWTKeyAdapter.reset();
        AWTRobotUtil.waitForIdle(robot);
        AWTRobotUtil.newtKeyPress(0, robot, true, (short)18, 10);
        AWTRobotUtil.newtKeyPress(0, robot, true, (short)17, 10);
        AWTRobotUtil.newtKeyPress(0, robot, true, (short)15, 10);
        AWTRobotUtil.newtKeyPress(0, robot, true, (short)49, 10);
        AWTRobotUtil.newtKeyPress(0, robot, false, (short)49, 100);
        AWTRobotUtil.newtKeyPress(0, robot, false, (short)15, 10);
        AWTRobotUtil.newtKeyPress(0, robot, false, (short)17, 10);
        AWTRobotUtil.newtKeyPress(0, robot, false, (short)18, 10);
        AWTRobotUtil.waitForIdle(robot);
        for (int i = 0; i < 100 && nEWTKeyAdapter.getQueueSize() < 8; ++i) {
            robot.delay(100);
        }
        NEWTKeyUtil.validateKeyAdapterStats(nEWTKeyAdapter, 4, 4, 0, 0);
        List<EventObject> list = nEWTKeyAdapter.copyQueue();
        int n = 0;
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n++), (short)300, 8, (short)18, '\u0000');
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n++), (short)300, 10, (short)17, '\u0000');
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n++), (short)300, 11, (short)15, '\u0000');
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n++), (short)300, 11, (short)49, '\u0000');
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n++), (short)301, 11, (short)49, '\u0000');
        KeyEvent keyEvent = (KeyEvent)list.get(n++);
        NEWTKeyUtil.validateKeyEvent(keyEvent, (short)301, 11, (short)15, '\u0000');
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n++), (short)301, 10, (short)17, '\u0000');
        NEWTKeyUtil.validateKeyEvent((KeyEvent)list.get(n++), (short)301, 8, (short)18, '\u0000');
    }

    void testImpl(GLWindow gLWindow) throws AWTException, InterruptedException, InvocationTargetException {
        Robot robot = new Robot();
        robot.setAutoWaitForIdle(true);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        gLWindow.addGLEventListener(redSquareES2);
        NEWTKeyAdapter nEWTKeyAdapter = new NEWTKeyAdapter("GLWindow1");
        nEWTKeyAdapter.setVerbose(false);
        gLWindow.addKeyListener(nEWTKeyAdapter);
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, true));
        Animator animator = new Animator(gLWindow);
        animator.start();
        Thread.sleep(durationPerTest);
        AWTRobotUtil.assertRequestFocusAndWait(null, gLWindow, gLWindow, null, null);
        AWTRobotUtil.requestFocus(robot, gLWindow, false);
        nEWTKeyAdapter.reset();
        TestNewtKeyCodeModifiersAWT.testKeyCodeModifier(robot, nEWTKeyAdapter, (short)15, 1, (short)49, '1', '!');
        TestNewtKeyCodeModifiersAWT.testKeyCodeModifier(robot, nEWTKeyAdapter, (short)15, 1, (short)89, 'y', 'Y');
        TestNewtKeyCodeModifiersAWT.testKeyCodeModifier(robot, nEWTKeyAdapter, (short)15, 1, (short)80, 'p', 'P');
        TestNewtKeyCodeModifiersAWT.testKeyCodeModifier(robot, nEWTKeyAdapter, (short)17, 2, (short)49, '1', '\u0000');
        TestNewtKeyCodeModifiersAWT.testKeyCodeModifier(robot, nEWTKeyAdapter, (short)18, 8, (short)49, '1', '\u0000');
        TestNewtKeyCodeModifiersAWT.testKeyCodeAllModifierV1(robot, nEWTKeyAdapter);
        gLWindow.removeKeyListener(nEWTKeyAdapter);
        animator.stop();
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestNewtKeyCodeModifiersAWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestNewtKeyCodeModifiersAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 100L;
        awtWaitTimeout = 1000L;
    }
}

