/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureData;
import com.jogamp.opengl.util.texture.spi.JPEGImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestJPEGJoglAWTCompareNewtAWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 100L;
    String[] files = new String[]{"test-ntscN_3-01-160x90-90pct-yuv444-base.jpg", "test-ntscN_3-01-160x90-90pct-yuv444-prog.jpg", "test-ntscN_3-01-160x90-60pct-yuv422h-base.jpg", "test-ntscN_3-01-160x90-60pct-yuv422h-prog.jpg", "j1-baseline.jpg", "j2-progressive.jpg", "j3-baseline_gray.jpg", "test-cmyk-01.jpg", "test-ycck-01.jpg"};

    void testImpl(String string) throws InterruptedException, IOException {
        Animator animator = new Animator();
        GLWindow gLWindow = this.testJOGLJpeg(string);
        GLWindow gLWindow2 = this.testAWTJpeg(string, gLWindow.getSurfaceWidth() + 50);
        animator.add(gLWindow);
        animator.add(gLWindow2);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.setVisible(true);
        gLWindow2.setVisible(true);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
    }

    GLWindow testJOGLJpeg(String string) throws InterruptedException, IOException {
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), string);
        Assert.assertNotNull((Object)uRLConnection);
        InputStream inputStream = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)inputStream);
        JPEGImage jPEGImage = JPEGImage.read(inputStream);
        Assert.assertNotNull((Object)jPEGImage);
        System.err.println("JPEGImage: " + jPEGImage);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        int n = jPEGImage.getBytesPerPixel() == 4 ? 6408 : 6407;
        TextureData textureData = new TextureData(gLProfile, n, jPEGImage.getWidth(), jPEGImage.getHeight(), 0, new GLPixelBuffer.GLPixelAttributes(jPEGImage.getGLFormat(), jPEGImage.getGLType()), false, false, false, jPEGImage.getData(), null);
        System.err.println("TextureData: " + textureData);
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(1);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle("JPEG JOGL");
        gLWindow.setSize(textureData.getWidth(), textureData.getHeight());
        gLWindow.setPosition(0, 0);
        final TextureDraw01ES2Listener textureDraw01ES2Listener = new TextureDraw01ES2Listener(textureData, 0);
        gLWindow.addGLEventListener(textureDraw01ES2Listener);
        gLWindow.addGLEventListener(new GLEventListener(){
            boolean shot = false;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != ((TextureDraw01Accessor)((Object)textureDraw01ES2Listener)).getTexture() && !this.shot) {
                    this.shot = true;
                    TestJPEGJoglAWTCompareNewtAWT.this.snapshot(0, "JoglJPEG", gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        return gLWindow;
    }

    GLWindow testAWTJpeg(String string, int n) throws InterruptedException, IOException {
        TextureDraw01ES2Listener textureDraw01ES2Listener;
        Object object;
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), string);
        Assert.assertNotNull((Object)uRLConnection);
        InputStream inputStream = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)inputStream);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        AWTTextureData aWTTextureData = null;
        int n2 = 300;
        int n3 = 300;
        try {
            object = ImageIO.read(inputStream);
            aWTTextureData = new AWTTextureData(gLProfile, 0, 0, false, (BufferedImage)object);
            System.err.println("TextureData: " + aWTTextureData);
            n2 = aWTTextureData.getWidth();
            n3 = aWTTextureData.getHeight();
        }
        catch (Exception exception) {
            System.err.println("AWT ImageIO failure w/ file " + string + ": " + exception.getMessage());
        }
        object = new GLReadBufferUtil(true, false);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(1);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle("JPEG AWT");
        gLWindow.setSize(n2, n3);
        gLWindow.setPosition(n, 0);
        if (aWTTextureData != null) {
            textureDraw01ES2Listener = new TextureDraw01ES2Listener(aWTTextureData, 0);
            gLWindow.addGLEventListener(textureDraw01ES2Listener);
        } else {
            textureDraw01ES2Listener = null;
        }
        gLWindow.addGLEventListener(new GLEventListener((GLReadBufferUtil)object){
            boolean shot = false;
            final /* synthetic */ GLReadBufferUtil val$screenshot;
            {
                this.val$screenshot = gLReadBufferUtil;
            }

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != textureDraw01ES2Listener && null != ((TextureDraw01Accessor)((Object)textureDraw01ES2Listener)).getTexture() && !this.shot) {
                    this.shot = true;
                    TestJPEGJoglAWTCompareNewtAWT.this.snapshot(0, "AWTJPEG", gLAutoDrawable.getGL(), this.val$screenshot, "png", null);
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        return gLWindow;
    }

    @Test
    public void test01YUV444Base__ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[0]);
    }

    @Test
    public void test01YUV444Prog__ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[1]);
    }

    @Test
    public void test01YUV422hBase__ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[2]);
    }

    @Test
    public void test01YUV422hProg_ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[3]);
    }

    @Test
    public void test02YUV420Base__ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[4]);
    }

    @Test
    public void test02YUV420Prog_ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[5]);
    }

    @Test
    public void test02YUV420BaseGray_ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[6]);
    }

    @Test
    public void test03CMYK_01_ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[7]);
    }

    @Test
    public void test03YCCK_01_ES2() throws InterruptedException, IOException {
        this.testImpl(this.files[8]);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestJPEGJoglAWTCompareNewtAWT.class.getName()});
    }
}

