/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.RandomTileRenderer;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRandomTiledRendering3GL2AWT
extends UITestCase {
    static long duration = 3500L;
    static int width = 512;
    static int height = 512;

    @Test
    public void test01_aa0() throws IOException, InterruptedException, InvocationTargetException {
        this.doTest(0);
    }

    @Test
    public void test02_aa8() throws IOException, InterruptedException, InvocationTargetException {
        this.doTest(8);
    }

    void doTest(int n) throws IOException, InterruptedException, InvocationTargetException {
        final GLCapabilities gLCapabilities = new GLCapabilities(null);
        if (n > 0) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n);
        }
        final Frame frame = new Frame("Gears AWT Test");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        Dimension dimension = new Dimension(width, height);
        gLCanvas.setMinimumSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        gLCanvas.setSize(dimension);
        frame.add(gLCanvas);
        Gears gears = new Gears();
        gLCanvas.addGLEventListener(gears);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(gLCanvas);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(frame);
        final RandomTileRenderer randomTileRenderer = new RandomTileRenderer();
        randomTileRenderer.setImageSize(1536, 1024);
        final GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider = GLPixelBuffer.defaultProviderWithRowStride;
        final boolean[] blArray = new boolean[]{false};
        final boolean[] blArray2 = new boolean[]{true};
        GLEventListener gLEventListener = new GLEventListener(){
            final int w = 64;
            final int h = 64;
            int dx = 0;
            int dy = 0;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                PixelFormat.Composition composition = gLPixelBufferProvider.getHostPixelComp(gL.getGLProfile(), 3);
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = gLPixelBufferProvider.getAttributes(gL, 3, true);
                GLPixelBuffer gLPixelBuffer = gLPixelBufferProvider.allocate(gL, composition, gLPixelAttributes, true, 1536, 1024, 1, 0);
                randomTileRenderer.setImageBuffer(gLPixelBuffer);
                blArray[0] = !gLAutoDrawable.isGLOriented();
                System.err.println("XXX pre-init: " + randomTileRenderer);
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (this.dx + 64 <= 1536 && this.dy + 64 <= 1024) {
                    randomTileRenderer.setTileRect(this.dx, this.dy, 64, 64);
                    this.dx += 96;
                    if (this.dx + 64 > 1536) {
                        this.dx = 0;
                        this.dy += 96;
                    }
                } else if (blArray2[0]) {
                    blArray2[0] = false;
                }
                System.err.println("XXX pre-display: " + randomTileRenderer);
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        };
        GLEventListener gLEventListener2 = new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (!blArray2[0]) {
                    GLPixelBuffer gLPixelBuffer = randomTileRenderer.getImageBuffer();
                    gLPixelBuffer.clear();
                    System.err.println("XXX !active -> save");
                    System.err.println("XXX post-display: " + randomTileRenderer);
                    TextureData textureData = new TextureData(gLCapabilities.getGLProfile(), 0, 1536, 1024, 0, gLPixelBuffer.pixelAttributes, false, false, blArray[0], gLPixelBuffer.buffer, null);
                    try {
                        String string = TestRandomTiledRendering3GL2AWT.this.getSnapshotFilename(0, "-tile", gLCanvas.getChosenGLCapabilities(), 1536, 1024, false, "png", null);
                        File file = new File(string);
                        TextureIO.write(textureData, file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    randomTileRenderer.detachAutoDrawable();
                    System.err.println("XXX post-display detached: " + randomTileRenderer);
                    gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
                    gLCanvas.getGLEventListener(0).reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
                }
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        };
        randomTileRenderer.setGLEventListener(gLEventListener, gLEventListener2);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setVisible(true);
            }
        });
        Animator animator = new Animator(gLCanvas);
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        boolean bl = true;
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && (blArray2[0] || animator.getTotalFPSDuration() < duration)) {
            if (bl && animator.getTotalFPSDuration() > 90L) {
                bl = false;
                System.err.println("XXX START TILE RENDERING");
                randomTileRenderer.attachAutoDrawable(gLCanvas);
            }
            Thread.sleep(100L);
        }
        Assert.assertNotNull((Object)frame);
        Assert.assertNotNull((Object)gLCanvas);
        Assert.assertNotNull((Object)animator);
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(gLCanvas);
                frame.dispose();
            }
        });
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestRandomTiledRendering3GL2AWT.class.getName()});
    }
}

