/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es1;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.gl2es1.GLUgl2es1;
import com.jogamp.opengl.test.junit.jogl.demos.PointsDemo;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.fixedfunc.FixedFuncUtil;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import java.nio.FloatBuffer;

public class PointsDemoES1
extends PointsDemo {
    static final GLU glu = new GLUgl2es1();
    private boolean debugFFPEmu = false;
    private boolean verboseFFPEmu = false;
    private boolean traceFFPEmu = false;
    private boolean forceFFPEmu = false;
    private boolean debug = false;
    private boolean trace = false;
    GLArrayDataServer vertices;
    float[] pointSizes;
    private int swapInterval = 0;
    final int edge = 8;
    boolean smooth = false;
    private float pointMinSize = 0.0f;
    private float pointMaxSize = 4096.0f;
    private float pointFadeThreshold = 1.0f;
    private final FloatBuffer pointDistAtten = Buffers.newDirectFloatBuffer(new float[]{1.0f, 0.0f, 0.0f});

    public PointsDemoES1(int n) {
        this.swapInterval = n;
    }

    public PointsDemoES1() {
        this.swapInterval = 1;
    }

    public void setForceFFPEmu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.forceFFPEmu = bl;
        this.verboseFFPEmu = bl2;
        this.debugFFPEmu = bl3;
        this.traceFFPEmu = bl4;
    }

    @Override
    public void setSmoothPoints(boolean bl) {
        this.smooth = bl;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        if (this.debugFFPEmu) {
            gL = gL.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Debug", GL2ES2.class, gL, null));
            this.debug = false;
        }
        if (this.traceFFPEmu) {
            gL = gL.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Trace", GL2ES2.class, gL, new Object[]{System.err}));
            this.trace = false;
        }
        GL2ES1 gL2ES1 = FixedFuncUtil.wrapFixedFuncEmul(gL, ShaderSelectionMode.AUTO, null, this.forceFFPEmu, this.verboseFFPEmu);
        if (this.debug) {
            try {
                gL2ES1 = (GL2ES1)gL2ES1.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Debug", GL2ES1.class, gL2ES1, null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.trace) {
            try {
                gL2ES1 = (GL2ES1)gL2ES1.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Trace", GL2ES1.class, gL2ES1, new Object[]{System.err}));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.err.println("GL_VENDOR: " + gL2ES1.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL2ES1.glGetString(7937));
        System.err.println("GL_VERSION: " + gL2ES1.glGetString(7938));
        System.err.println("GL Profile: " + gL2ES1.getGLProfile());
        this.vertices = GLArrayDataServer.createFixed(32884, 3, 5126, false, 64, 35044);
        this.pointSizes = new float[64];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                float f = -3.0f + (float)j * 0.7f;
                float f2 = -3.0f + (float)i * 0.7f;
                float f3 = Math.max(1.0E-6f, (float)(i * 8 + j) * 0.5f);
                this.vertices.putf(f);
                this.vertices.putf(f2);
                this.vertices.putf(0.0f);
                this.pointSizes[i * 8 + j] = f3;
            }
        }
        this.vertices.seal(gL2ES1, true);
        this.vertices.enableBuffer(gL2ES1, false);
        gL2ES1.glEnable(2929);
    }

    @Override
    public void setPointParams(float f, float f2, float f3, float f4, float f5, float f6) {
        this.pointMinSize = f;
        this.pointMaxSize = f2;
        this.pointFadeThreshold = f6;
        this.pointDistAtten.put(0, f3);
        this.pointDistAtten.put(1, f4);
        this.pointDistAtten.put(2, f5);
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2ES1.glClear(16640);
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(0.0f, 0.0f, -10.0f);
        gL2ES1.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.vertices.enableBuffer(gL2ES1, true);
        gL2ES1.glEnable(3042);
        gL2ES1.glBlendFunc(770, 1);
        if (this.smooth) {
            gL2ES1.glEnable(2832);
        } else {
            gL2ES1.glDisable(2832);
        }
        gL2ES1.glPointParameterf(33062, this.pointMinSize);
        gL2ES1.glPointParameterf(33063, this.pointMaxSize);
        gL2ES1.glPointParameterf(33064, this.pointFadeThreshold);
        gL2ES1.glPointParameterfv(33065, this.pointDistAtten);
        for (int i = 63; i >= 0; --i) {
            gL2ES1.glPointSize(this.pointSizes[i]);
            gL2ES1.glDrawArrays(0, i, 1);
        }
        this.vertices.enableBuffer(gL2ES1, false);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        if (-1 != this.swapInterval) {
            gL2ES1.setSwapInterval(this.swapInterval);
        }
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        glu.gluPerspective(45.0f, (float)n3 / (float)n4 / 1.0f, 1.0f, 100.0f);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        this.vertices.destroy(gL2ES1);
        this.vertices = null;
    }
}

