/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2AWT3b
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2AWT3b.setTestSupported(false);
        }
    }

    protected GLJPanel createGLJPanel(Frame frame, int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLJPanel gLJPanel = new GLJPanel(caps);
        Assert.assertNotNull((Object)gLJPanel);
        gLJPanel.addGLEventListener(gearsES2);
        frame.add(gLJPanel);
        frame.setLocation(n, n2);
        frame.setSize(width, height);
        frame.setTitle("AWT GLJPanel Shared Gears Test: " + n + "/" + n2 + " shared true");
        return gLJPanel;
    }

    @Test
    public void test01SyncedOneAnimator() throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame();
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLJPanel gLJPanel = this.createGLJPanel(frame, 0, 0, gearsES2);
        animator.add(gLJPanel);
        final Frame frame2 = new Frame();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLJPanel gLJPanel2 = this.createGLJPanel(frame2, frame.getX() + width, frame.getY() + 0, gearsES22);
        gLJPanel2.setSharedAutoDrawable(gLJPanel);
        animator.add(gLJPanel2);
        final Frame frame3 = new Frame();
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLJPanel gLJPanel3 = this.createGLJPanel(frame3, frame.getX() + 0, frame.getY() + height, gearsES23);
        gLJPanel3.setSharedAutoDrawable(gLJPanel);
        animator.add(gLJPanel3);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setVisible(true);
                frame.setVisible(true);
                frame3.setVisible(true);
            }
        });
        animator.start();
        Thread.sleep(160L);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLJPanel, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLJPanel, true));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLJPanel2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLJPanel2, true));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLJPanel3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLJPanel3, true));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        GLContext gLContext = gLJPanel.getContext();
        GLContext gLContext2 = gLJPanel2.getContext();
        GLContext gLContext3 = gLJPanel3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame3.dispose();
                    frame2.dispose();
                    frame.dispose();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel3, false));
    }

    @Test
    public void test02AsyncEachAnimator() throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame();
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLJPanel gLJPanel = this.createGLJPanel(frame, 0, 0, gearsES2);
        animator.add(gLJPanel);
        animator.start();
        final Frame frame2 = new Frame();
        Animator animator2 = new Animator();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLJPanel gLJPanel2 = this.createGLJPanel(frame2, frame.getX() + width, frame.getY() + 0, gearsES22);
        gLJPanel2.setSharedAutoDrawable(gLJPanel);
        animator2.add(gLJPanel2);
        animator2.start();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setVisible(true);
            }
        });
        Thread.sleep(200L);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        final Frame frame3 = new Frame();
        Animator animator3 = new Animator();
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLJPanel gLJPanel3 = this.createGLJPanel(frame3, frame.getX() + 0, frame.getY() + height, gearsES23);
        gLJPanel3.setSharedAutoDrawable(gLJPanel);
        animator3.add(gLJPanel3);
        animator3.start();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame3.setVisible(true);
            }
        });
        Thread.sleep(160L);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLJPanel, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLJPanel, true));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLJPanel2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLJPanel2, true));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLJPanel3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated(gLJPanel3, true));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        GLContext gLContext = gLJPanel.getContext();
        GLContext gLContext2 = gLJPanel2.getContext();
        GLContext gLContext3 = gLJPanel3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        animator2.stop();
        Assert.assertEquals((Object)false, (Object)animator2.isAnimating());
        animator3.stop();
        Assert.assertEquals((Object)false, (Object)animator3.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame3.dispose();
                    frame2.dispose();
                    frame.dispose();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLJPanel3, false));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextVBOES2AWT3b.class.getName()});
    }

    static {
        duration = 1000L;
    }
}

