/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.util.VersionUtil;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.acore.GLReadBuffer00Base;
import com.jogamp.opengl.test.junit.jogl.acore.GLReadBuffer00BaseAWT;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.MultisampleDemoES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLReadBuffer01GLCanvasAWT
extends GLReadBuffer00BaseAWT {
    static GLCapabilitiesImmutable caps = null;
    static boolean doSnapshot = true;
    static boolean keyFrame = false;

    @BeforeClass
    public static void initClass() {
        GLProfile.initSingleton();
    }

    @Override
    public void test(final GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, boolean bl2) {
        if (bl2 || bl) {
            return;
        }
        AWTGLReadBufferUtil aWTGLReadBufferUtil = new AWTGLReadBufferUtil(gLCapabilitiesImmutable.getGLProfile(), false);
        final Frame frame = new Frame();
        Dimension dimension = new Dimension(320, 240);
        final GLCanvas gLCanvas = this.createGLCanvas(gLCapabilitiesImmutable, dimension);
        final GLReadBuffer00Base.TextRendererGLEL textRendererGLEL = new GLReadBuffer00Base.TextRendererGLEL();
        final GLReadBuffer00BaseAWT.SnapshotGLELAWT snapshotGLELAWT = doSnapshot ? new GLReadBuffer00BaseAWT.SnapshotGLELAWT(textRendererGLEL, aWTGLReadBufferUtil, false) : null;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setLocation(64, 64);
                    frame.setLayout(new BorderLayout());
                    gLCanvas.addGLEventListener(new GLEventListener(){

                        @Override
                        public void init(GLAutoDrawable gLAutoDrawable) {
                            GL gL = gLAutoDrawable.getGL();
                            System.err.println(VersionUtil.getPlatformInfo());
                            System.err.println("GLEventListener init on " + Thread.currentThread());
                            System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
                            System.err.println("INIT GL IS: " + gL.getClass().getName());
                            System.err.println(JoglVersion.getGLStrings(gL, null, false).toString());
                        }

                        @Override
                        public void dispose(GLAutoDrawable gLAutoDrawable) {
                        }

                        @Override
                        public void display(GLAutoDrawable gLAutoDrawable) {
                        }

                        @Override
                        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                        }
                    });
                    GLEventListener gLEventListener = new GearsES2(1);
                    ((GearsES2)gLEventListener).setVerbose(false);
                    gLCanvas.addGLEventListener(gLEventListener);
                    gLEventListener = new MultisampleDemoES2(gLCapabilitiesImmutable.getSampleBuffers());
                    ((MultisampleDemoES2)gLEventListener).setClearBuffers(false);
                    gLCanvas.addGLEventListener(gLEventListener);
                    gLCanvas.addGLEventListener(textRendererGLEL);
                    if (doSnapshot) {
                        gLCanvas.addGLEventListener(snapshotGLELAWT);
                    }
                    frame.add((Component)gLCanvas, "Center");
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLCanvas.display();
        final Dimension dimension2 = frame.getSize();
        final Dimension dimension3 = new Dimension(dimension2.width + 100, dimension2.height + 100);
        final Dimension dimension4 = new Dimension(dimension2.width - 100, dimension2.height - 100);
        try {
            for (int i = 0; i < 3; ++i) {
                String string = "Frame# " + textRendererGLEL.frameNo + ", user #" + (i + 1);
                System.err.println(string);
                if (keyFrame) {
                    TestGLReadBuffer01GLCanvasAWT.waitForKey(string);
                }
                textRendererGLEL.userCounter = i + 1;
                gLCanvas.display();
            }
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(dimension3);
                    frame.validate();
                }
            });
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(dimension4);
                    frame.validate();
                }
            });
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(dimension2);
                    frame.validate();
                }
            });
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (doSnapshot) {
                gLCanvas.disposeGLEventListener(snapshotGLELAWT, true);
            }
            Animator animator = new Animator(gLCanvas);
            animator.start();
            try {
                Thread.sleep(2L * duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            animator.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private GLCanvas createGLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, Dimension dimension) {
        GLCanvas gLCanvas = new GLCanvas(gLCapabilitiesImmutable);
        gLCanvas.setSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        gLCanvas.setMinimumSize(dimension);
        return gLCanvas;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-keyFrame")) {
                keyFrame = true;
                continue;
            }
            if (!stringArray[i].equals("-noSnapshot")) continue;
            doSnapshot = false;
        }
        JUnitCore.main((String[])new String[]{TestGLReadBuffer01GLCanvasAWT.class.getName()});
    }
}

