/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl.nativesig;

import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.opengl.GLEmitter;
import com.jogamp.gluegen.opengl.GLJavaMethodBindingEmitter;
import com.jogamp.gluegen.opengl.nativesig.NativeSignatureEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;
import java.io.PrintWriter;

public class NativeSignatureJavaMethodBindingEmitter
extends GLJavaMethodBindingEmitter {
    public NativeSignatureJavaMethodBindingEmitter(GLJavaMethodBindingEmitter gLJavaMethodBindingEmitter) {
        super(gLJavaMethodBindingEmitter);
    }

    public NativeSignatureJavaMethodBindingEmitter(ProcAddressJavaMethodBindingEmitter procAddressJavaMethodBindingEmitter, GLEmitter gLEmitter, boolean bl) {
        super(procAddressJavaMethodBindingEmitter, gLEmitter, bl);
    }

    public NativeSignatureJavaMethodBindingEmitter(JavaMethodBindingEmitter javaMethodBindingEmitter, NativeSignatureEmitter nativeSignatureEmitter) {
        super(javaMethodBindingEmitter, false, null, false, false, nativeSignatureEmitter);
    }

    @Override
    protected void emitSignature(PrintWriter printWriter) {
        printWriter.print(this.getBaseIndentString());
        this.emitNativeSignatureAnnotation(printWriter);
        super.emitSignature(printWriter);
    }

    protected void emitNativeSignatureAnnotation(PrintWriter printWriter) {
        if (this.hasModifier(JavaMethodBindingEmitter.NATIVE)) {
            printWriter.print("@NativeSignature(\"l");
            MethodBinding methodBinding = this.getBinding();
            if (this.callThroughProcAddress) {
                printWriter.print("p");
            }
            printWriter.print("(");
            if (this.callThroughProcAddress) {
                printWriter.print("P");
            }
            for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
                this.emitNativeSignatureElement(printWriter, methodBinding.getJavaArgumentType(i), methodBinding.getCArgumentType(i), i);
            }
            printWriter.print(")");
            this.emitNativeSignatureElement(printWriter, methodBinding.getJavaReturnType(), methodBinding.getCReturnType(), -1);
            printWriter.println("\")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void emitNativeSignatureElement(PrintWriter printWriter, JavaType javaType, Type type, int n) {
        if (javaType.isVoid()) {
            if (n <= 0) return;
            throw new InternalError("Error parsing arguments -- void should not be seen aside from argument 0");
        }
        if (javaType.isNIOBuffer()) {
            printWriter.print("A");
            return;
        } else if (javaType.isPrimitiveArray()) {
            printWriter.print("MO");
            return;
        } else if (javaType.isPrimitive()) {
            Class<?> clazz = javaType.getJavaClass();
            if (clazz == Byte.TYPE) {
                printWriter.print("B");
                return;
            } else if (clazz == Character.TYPE) {
                printWriter.print("C");
                return;
            } else if (clazz == Double.TYPE) {
                printWriter.print("D");
                return;
            } else if (clazz == Float.TYPE) {
                printWriter.print("F");
                return;
            } else if (clazz == Integer.TYPE) {
                printWriter.print("I");
                return;
            } else if (clazz == Long.TYPE) {
                if (type.isPointer()) {
                    printWriter.print("A");
                    return;
                } else {
                    printWriter.print("J");
                }
                return;
            } else if (clazz == Short.TYPE) {
                printWriter.print("S");
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new InternalError("Unhandled primitive type " + clazz);
                printWriter.print("Z");
            }
            return;
        } else {
            if (!javaType.isString()) throw new RuntimeException("Type not yet handled: " + javaType);
            printWriter.print("A");
        }
    }

    @Override
    protected String getReturnTypeString(boolean bl) {
        JavaType javaType;
        if (this.isPrivateNativeMethod() && ((javaType = this.getBinding().getJavaReturnType()).isString() || javaType.isNIOByteBuffer())) {
            return "long";
        }
        return super.getReturnTypeString(bl);
    }

    @Override
    protected void emitPreCallSetup(MethodBinding methodBinding, PrintWriter printWriter) {
        super.emitPreCallSetup(methodBinding, printWriter);
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (javaType.isNIOBuffer() && !this.useNIODirectOnly) {
                printWriter.println("  Object " + this.getNIOBufferArrayName(i) + " = (_direct ? null : Buffers.getArray(" + this.getArgumentName(i) + "));");
                continue;
            }
            if (!javaType.isString()) continue;
            printWriter.println("    long " + methodBinding.getArgumentName(i) + "_c_str = BuffersInternal.newCString(" + methodBinding.getArgumentName(i) + ");");
        }
    }

    protected String getNIOBufferArrayName(int n) {
        return "__buffer_array_" + n;
    }

    @Override
    protected int emitArguments(PrintWriter printWriter) {
        boolean bl = false;
        int n = 0;
        if (this.callThroughProcAddress && this.changeNameAndArguments) {
            printWriter.print("long procAddress");
            ++n;
            bl = true;
        }
        if (this.isPrivateNativeMethod() && this.binding.hasContainingType()) {
            if (bl) {
                printWriter.print(", ");
            }
            printWriter.print("long ");
            printWriter.print(NativeSignatureJavaMethodBindingEmitter.javaThisArgumentName());
            ++n;
            bl = true;
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (this.binding.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this.binding + "\"");
            }
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (bl) {
                printWriter.print(", ");
            }
            if (this.isPrivateNativeMethod() && (this.isForDirectBufferImplementation() && javaType.isNIOBuffer() || javaType.isString())) {
                printWriter.print("long");
            } else {
                printWriter.print(this.erasedTypeString(javaType, false));
            }
            printWriter.print(" ");
            printWriter.print(this.getArgumentName(i));
            ++n;
            bl = true;
            if (this.isForIndirectBufferAndArrayImplementation()) {
                if (javaType.isNIOBuffer()) {
                    printWriter.print(", int " + this.byteOffsetArgName(i));
                } else if (javaType.isNIOBufferArray()) {
                    printWriter.print(", int[] " + this.byteOffsetArrayArgName(i));
                }
            }
            if (!javaType.isPrimitiveArray()) continue;
            printWriter.print(", int " + this.offsetArgName(i));
        }
        return n;
    }

    @Override
    protected void emitReturnVariableSetupAndCall(MethodBinding methodBinding, PrintWriter printWriter) {
        printWriter.print("    ");
        JavaType javaType = methodBinding.getJavaReturnType();
        boolean bl = false;
        if (!javaType.isVoid()) {
            if (javaType.isCompoundTypeWrapper() || javaType.isNIOByteBuffer()) {
                printWriter.println("final java.nio.ByteBuffer _res;");
                bl = true;
            } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                printWriter.println("final java.nio.ByteBuffer[] _res;");
                bl = true;
            } else if (javaType.isString() || javaType.isNIOByteBuffer()) {
                printWriter.print("final ");
                printWriter.print(javaType);
                printWriter.println(" _res;");
                bl = true;
            } else {
                printWriter.print("final ");
                this.emitReturnType(printWriter);
                printWriter.println(" _res;");
                bl = true;
            }
        }
        if (methodBinding.signatureCanUseIndirectNIO() && !this.useNIODirectOnly) {
            printWriter.println("if (_direct) {");
            printWriter.print("    ");
        }
        if (bl) {
            printWriter.print("  _res = ");
            if (javaType.isString()) {
                printWriter.print("BuffersInternal.newJavaString(");
            } else if (javaType.isNIOByteBuffer()) {
                printWriter.print("BuffersInternal.newDirectByteBuffer(");
            }
        } else {
            printWriter.print("  ");
            if (!javaType.isVoid()) {
                printWriter.print("return ");
            }
        }
        if (methodBinding.signatureUsesJavaPrimitiveArrays() && !methodBinding.signatureCanUseIndirectNIO()) {
            this.emitCall(methodBinding, printWriter);
            if (javaType.isString() || javaType.isNIOByteBuffer()) {
                printWriter.print(")");
            }
            printWriter.print(";");
            printWriter.println();
        } else {
            this.emitCall(methodBinding, printWriter);
            if (javaType.isString() || javaType.isNIOByteBuffer()) {
                printWriter.print(")");
            }
            printWriter.print(";");
        }
        if (methodBinding.signatureCanUseIndirectNIO() && !this.useNIODirectOnly) {
            printWriter.println();
            printWriter.println("    } else {");
            printWriter.print("    ");
            if (bl) {
                printWriter.print("    _res = ");
            } else {
                printWriter.print("  ");
                if (!javaType.isVoid()) {
                    printWriter.print("return ");
                }
            }
            this.emitCall(methodBinding, printWriter);
            printWriter.print(";");
            printWriter.println();
            printWriter.println("    }");
        } else {
            printWriter.println();
        }
        this.emitPrologueOrEpilogue(this.epilogue, printWriter);
        if (bl) {
            this.emitCallResultReturn(methodBinding, printWriter);
        }
    }

    protected int emitCallArguments(MethodBinding methodBinding, PrintWriter printWriter, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        if (this.callThroughProcAddress) {
            printWriter.print("__addr_");
            bl2 = true;
            ++n;
        }
        if (methodBinding.hasContainingType()) {
            assert (methodBinding.getContainingType().isCompoundTypeWrapper());
            printWriter.print("BuffersInternal.getDirectBufferAddress(");
            printWriter.print("getBuffer()");
            printWriter.print(")");
            bl2 = true;
            ++n;
        }
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || methodBinding.isArgumentThisPointer(i)) continue;
            if (javaType.isVoid()) {
                assert (methodBinding.getNumArguments() == 1);
                continue;
            }
            if (bl2) {
                printWriter.print(", ");
            }
            if (javaType.isCompoundTypeWrapper()) {
                printWriter.print("BuffersInternal.getDirectBufferAddress(");
                printWriter.print("((");
            }
            if (javaType.isNIOBuffer()) {
                if (!bl) {
                    printWriter.print(this.getNIOBufferArrayName(i));
                } else {
                    printWriter.print("BuffersInternal.getDirectBufferAddress(");
                    printWriter.print(this.getArgumentName(i));
                    printWriter.print(")");
                }
            } else {
                printWriter.print(this.getArgumentName(i));
            }
            if (javaType.isCompoundTypeWrapper()) {
                printWriter.print(" == null) ? null : ");
                printWriter.print(this.getArgumentName(i));
                printWriter.print(".getBuffer())");
                printWriter.print(")");
            }
            if (javaType.isNIOBuffer()) {
                if (bl) {
                    printWriter.print("+ Buffers.getDirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                } else {
                    printWriter.print(", BuffersInternal.arrayBaseOffset(" + this.getNIOBufferArrayName(i) + ") + Buffers.getIndirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                }
            } else if (javaType.isNIOBufferArray()) {
                printWriter.print(", " + this.byteOffsetArrayArgName(i));
            }
            if (javaType.isPrimitiveArray()) {
                printWriter.print(", ");
                printWriter.print("BuffersInternal.arrayBaseOffset(" + this.getArgumentName(i) + ") + ");
                if (javaType.isFloatArray()) {
                    printWriter.print("Buffers.SIZEOF_FLOAT * ");
                } else if (javaType.isDoubleArray()) {
                    printWriter.print("Buffers.SIZEOF_DOUBLE * ");
                } else if (javaType.isByteArray()) {
                    printWriter.print("1 * ");
                } else if (javaType.isLongArray()) {
                    printWriter.print("Buffers.SIZEOF_LONG * ");
                } else if (javaType.isShortArray()) {
                    printWriter.print("Buffers.SIZEOF_SHORT * ");
                } else if (javaType.isIntArray()) {
                    printWriter.print("Buffers.SIZEOF_INT * ");
                } else {
                    throw new GlueGenException("Unsupported type for calculating array offset argument for " + this.getArgumentName(i) + "-- error occurred while processing Java glue code for " + methodBinding.getCSymbol().getAliasedString(), methodBinding.getCSymbol().getASTLocusTag());
                }
                printWriter.print(this.offsetArgName(i));
            }
            if (javaType.isString()) {
                printWriter.print("_c_str");
            }
            if (javaType.isCompoundTypeWrapper()) {
                printWriter.print(")");
            }
            bl2 = true;
            ++n;
        }
        return n;
    }

    @Override
    protected void emitCallResultReturn(MethodBinding methodBinding, PrintWriter printWriter) {
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (!javaType.isString()) continue;
            printWriter.println(";");
            printWriter.println("    BuffersInternal.freeCString(" + methodBinding.getArgumentName(i) + "_c_str);");
        }
        super.emitCallResultReturn(methodBinding, printWriter);
    }

    @Override
    public String getNativeName() {
        String string = super.getNativeName();
        if (this.isPrivateNativeMethod() && this.bufferObjectVariant) {
            return string + "BufObj";
        }
        return string;
    }

    protected String getImplMethodName(boolean bl) {
        String string = null;
        string = bl ? this.binding.getName() + "$0" : this.binding.getName() + "$1";
        if (this.bufferObjectVariant) {
            return string + "BufObj";
        }
        return string;
    }
}

