/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.Field;
import com.jogamp.gluegen.cgram.types.MemoryLayoutType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;

public class StructLayout {
    private final int baseOffset;

    protected StructLayout(int n) {
        this.baseOffset = n;
    }

    public void layout(CompoundType compoundType) {
        MachineDataInfo machineDataInfo;
        int n = compoundType.getNumFields();
        SizeThunk sizeThunk = SizeThunk.constant(this.baseOffset);
        SizeThunk sizeThunk2 = SizeThunk.constant(0);
        if (GlueGen.debug()) {
            machineDataInfo = MachineDataInfo.StaticConfig.LP64_UNIX.md;
            System.err.printf("SL.__: o %03d, s %03d, t %s{%d}%n", sizeThunk.computeSize(machineDataInfo), 0, compoundType, compoundType.getNumFields());
        } else {
            machineDataInfo = null;
        }
        for (int i = 0; i < n; ++i) {
            Cloneable cloneable;
            Object object;
            Field field = compoundType.getField(i);
            Type type = field.getType();
            if (type.isInt() || type.isFloat() || type.isDouble() || type.isPointer()) {
                object = type.getSize();
                sizeThunk = SizeThunk.align(sizeThunk, (SizeThunk)object);
                field.setOffset(sizeThunk);
                if (compoundType.isUnion()) {
                    sizeThunk2 = SizeThunk.max(sizeThunk2, (SizeThunk)object);
                } else {
                    sizeThunk = SizeThunk.add(sizeThunk, (SizeThunk)object);
                }
            } else if (type.isCompound()) {
                object = type.asCompound();
                if (!((MemoryLayoutType)object).isLayouted()) {
                    StructLayout.layout(0, (CompoundType)object);
                }
                cloneable = ((Type)object).getSize();
                sizeThunk = SizeThunk.align(sizeThunk, (SizeThunk)cloneable);
                field.setOffset(sizeThunk);
                if (compoundType.isUnion()) {
                    sizeThunk2 = SizeThunk.max(sizeThunk2, (SizeThunk)cloneable);
                } else {
                    sizeThunk = SizeThunk.add(sizeThunk, (SizeThunk)cloneable);
                }
            } else if (type.isArray()) {
                object = type.asArray();
                if (!((MemoryLayoutType)object).isLayouted()) {
                    cloneable = ((ArrayType)object).getBaseElementType().asCompound();
                    if (cloneable != null) {
                        if (!((MemoryLayoutType)((Object)cloneable)).isLayouted()) {
                            StructLayout.layout(0, (CompoundType)cloneable);
                        }
                        ((ArrayType)object).recomputeSize();
                    }
                    ((MemoryLayoutType)object).setLayouted();
                }
                cloneable = type.getSize();
                sizeThunk = SizeThunk.align(sizeThunk, (SizeThunk)cloneable);
                field.setOffset(sizeThunk);
                sizeThunk = SizeThunk.add(sizeThunk, (SizeThunk)cloneable);
            } else {
                object = compoundType.getName();
                if (object == null) {
                    object = compoundType.toString();
                }
                throw new RuntimeException("Complicated field types (" + type + " " + field.getName() + " in type " + (String)object + ") not implemented yet");
            }
            if (!GlueGen.debug()) continue;
            System.err.printf("SL.%02d: o %03d, s %03d: %s, %s%n", i + 1, field.getOffset(machineDataInfo), type.getSize(machineDataInfo), field, type.getDebugString());
        }
        if (compoundType.isUnion()) {
            compoundType.setSize(sizeThunk2);
        } else {
            sizeThunk = SizeThunk.align(sizeThunk, sizeThunk);
            compoundType.setSize(sizeThunk);
        }
        if (GlueGen.debug()) {
            System.err.printf("SL.XX: o %03d, s %03d, t %s{%d}%n%n", sizeThunk.computeSize(machineDataInfo), compoundType.getSize(machineDataInfo), compoundType, compoundType.getNumFields());
        }
        compoundType.setLayouted();
    }

    public static StructLayout create(int n) {
        return new StructLayout(n);
    }

    public static void layout(int n, CompoundType compoundType) {
        StructLayout.create(n).layout(compoundType);
    }
}

